/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import java.util.Date;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;
import prefuse.util.TimeLib;

public class DateColumn
extends AbstractColumn {
    private long[] m_values;
    private int m_size;

    public DateColumn() {
        this(Date.class, 0, 10, 0L);
    }

    public DateColumn(int nRows) {
        this(Date.class, nRows, nRows, 0L);
    }

    public DateColumn(Class type, int nRows) {
        this(type, nRows, nRows, 0L);
    }

    public DateColumn(Class type, int nRows, int capacity, long defaultValue) {
        super(type, TimeLib.getDate(type, defaultValue));
        if (!Date.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Column type must be an instance or subclass of java.util.Date.");
        }
        if (capacity < nRows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new long[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nRows;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int nRows) {
        if (nRows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nRows);
            long[] values = new long[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, ((Date)this.m_defaultValue).getTime());
            this.m_values = values;
        }
        this.m_size = nRows;
    }

    @Override
    public boolean canSet(Class type) {
        if (type == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return true;
        }
        return this.m_columnType.isAssignableFrom(type);
    }

    @Override
    public Object get(int row) {
        return TimeLib.getDate(this.m_columnType, this.getLong(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Date) {
            this.setLong(((Date)val).getTime(), row);
            return;
        } else if (val instanceof Number) {
            this.setLong(((Number)val).longValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    @Override
    public long getLong(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    @Override
    public void setLong(long val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        long prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = val;
        this.fireColumnEvent(row, prev);
    }

    @Override
    public double getDouble(int row) throws DataTypeException {
        return this.getLong(row);
    }
}

