/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import prefuse.data.Table;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.util.Index;
import prefuse.util.DataLib;
import prefuse.util.TypeLib;
import prefuse.util.collections.DefaultLiteralComparator;

public class ColumnMetadata
implements ColumnListener {
    private Table m_table;
    private String m_field;
    private boolean m_dynamic;
    private boolean m_init;
    private Comparator m_cmp;
    private Object m_default;
    private int m_min;
    private int m_max;
    private int m_median;
    private int m_unique;
    private Double m_mean;
    private Double m_stdDev;
    private Double m_sum;
    private Object[] m_ordinalA;
    private Map m_ordinalM;

    public ColumnMetadata(Table table, String column) {
        this(table, column, DefaultLiteralComparator.getInstance(), true);
    }

    public ColumnMetadata(Table table, String column, Comparator cmp, boolean dynamic) {
        this.m_table = table;
        this.m_field = column;
        this.m_cmp = cmp;
        this.m_dynamic = dynamic;
    }

    public void dispose() {
        this.m_table.getColumn(this.m_field).removeColumnListener(this);
    }

    private void clearCachedValues() {
        this.m_min = -1;
        this.m_max = -1;
        this.m_median = -1;
        this.m_unique = -1;
        this.m_mean = null;
        this.m_stdDev = null;
        this.m_sum = null;
        this.m_ordinalA = null;
        this.m_ordinalM = null;
    }

    public void calculateValues() {
        this.clearCachedValues();
        boolean dyn = this.m_dynamic;
        this.m_dynamic = true;
        this.getMinimumRow();
        this.getMaximumRow();
        this.getMedianRow();
        this.getUniqueCount();
        if (TypeLib.isNumericType(this.m_table.getColumnType(this.m_field))) {
            this.getMean();
            this.getDeviation();
            this.getSum();
        }
        this.getOrdinalArray();
        this.getOrdinalMap();
        this.m_init = true;
        this.m_dynamic = dyn;
    }

    private void accessCheck() {
        if (this.m_init) {
            return;
        }
        if (this.m_dynamic) {
            this.clearCachedValues();
            this.m_table.getColumn(this.m_field).addColumnListener(this);
        } else {
            this.calculateValues();
        }
        this.m_init = true;
    }

    public Comparator getComparator() {
        return this.m_cmp;
    }

    public void setComparator(Comparator c) {
        this.m_cmp = c;
        this.clearCachedValues();
    }

    public Object getDefaultValue() {
        return this.m_default;
    }

    public int getMinimumRow() {
        this.accessCheck();
        if (this.m_min == -1 && this.m_dynamic) {
            Index idx = this.m_table.getIndex(this.m_field);
            this.m_min = idx != null ? idx.minimum() : DataLib.min(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
        }
        return this.m_min;
    }

    public int getMaximumRow() {
        this.accessCheck();
        if (this.m_max == -1 && this.m_dynamic) {
            Index idx = this.m_table.getIndex(this.m_field);
            this.m_max = idx != null ? idx.maximum() : DataLib.max(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
        }
        return this.m_max;
    }

    public int getMedianRow() {
        this.accessCheck();
        if (this.m_median == -1 && this.m_dynamic) {
            Index idx = this.m_table.getIndex(this.m_field);
            if (idx != null) {
                this.m_max = idx.median();
            } else {
                this.m_median = DataLib.median(this.m_table.tuples(), this.m_field, this.m_cmp).getRow();
            }
        }
        return this.m_median;
    }

    public int getUniqueCount() {
        this.accessCheck();
        if (this.m_unique == -1 && this.m_dynamic) {
            Index idx = this.m_table.getIndex(this.m_field);
            this.m_unique = idx != null ? idx.uniqueCount() : DataLib.uniqueCount(this.m_table.tuples(), this.m_field);
        }
        return this.m_unique;
    }

    public double getMean() {
        this.accessCheck();
        if (this.m_mean == null && this.m_dynamic) {
            this.m_mean = new Double(DataLib.mean(this.m_table.tuples(), this.m_field));
        }
        return this.m_mean;
    }

    public double getDeviation() {
        this.accessCheck();
        if (this.m_stdDev == null && this.m_dynamic) {
            this.m_stdDev = new Double(DataLib.deviation(this.m_table.tuples(), this.m_field, this.getMean()));
        }
        return this.m_stdDev;
    }

    public double getSum() {
        this.accessCheck();
        if (this.m_sum == null && this.m_dynamic) {
            this.m_sum = new Double(DataLib.sum(this.m_table.tuples(), this.m_field));
        }
        return this.m_sum;
    }

    public Object[] getOrdinalArray() {
        this.accessCheck();
        if (this.m_ordinalA == null && this.m_dynamic) {
            this.m_ordinalA = DataLib.ordinalArray(this.m_table.tuples(), this.m_field, this.m_cmp);
        }
        return this.m_ordinalA;
    }

    public Map getOrdinalMap() {
        this.accessCheck();
        if (this.m_ordinalM == null && this.m_dynamic) {
            Object[] a = this.getOrdinalArray();
            this.m_ordinalM = new HashMap();
            for (int i = 0; i < a.length; ++i) {
                this.m_ordinalM.put(a[i], new Integer(i));
            }
        }
        return this.m_ordinalM;
    }

    @Override
    public void columnChanged(Column src, int type, int start, int end) {
        this.clearCachedValues();
    }

    @Override
    public void columnChanged(Column src, int idx, boolean prev) {
        this.columnChanged(src, 0, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, double prev) {
        this.columnChanged(src, 0, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, float prev) {
        this.columnChanged(src, 0, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, int prev) {
        this.columnChanged(src, 0, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, long prev) {
        this.columnChanged(src, 0, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, Object prev) {
        this.columnChanged(src, 0, idx, idx);
    }
}

