/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.Table;
import prefuse.data.column.BooleanColumn;
import prefuse.data.column.ByteColumn;
import prefuse.data.column.Column;
import prefuse.data.column.ConstantColumn;
import prefuse.data.column.DateColumn;
import prefuse.data.column.DoubleColumn;
import prefuse.data.column.ExpressionColumn;
import prefuse.data.column.FloatColumn;
import prefuse.data.column.IntColumn;
import prefuse.data.column.LongColumn;
import prefuse.data.column.ObjectColumn;
import prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class type) {
        return ColumnFactory.getColumn(type, 0, 0, null);
    }

    public static final Column getColumn(Class type, int nRows) {
        return ColumnFactory.getColumn(type, nRows, nRows, null);
    }

    public static final Column getColumn(Class type, int nRows, Object defaultValue) {
        return ColumnFactory.getColumn(type, nRows, nRows, defaultValue);
    }

    public static final Column getColumn(Class type, int nRows, int nnz, Object defaultValue) {
        if (type == Byte.TYPE) {
            if (defaultValue == null) {
                return new ByteColumn(nRows);
            }
            byte def = ((Number)defaultValue).byteValue();
            return new ByteColumn(nRows, nRows, def);
        }
        if (type == Integer.TYPE) {
            if (defaultValue == null) {
                return new IntColumn(nRows);
            }
            int def = ((Number)defaultValue).intValue();
            return new IntColumn(nRows, nRows, def);
        }
        if (type == Long.TYPE) {
            if (defaultValue == null) {
                return new LongColumn(nRows);
            }
            long def = ((Number)defaultValue).longValue();
            return new LongColumn(nRows, nRows, def);
        }
        if (type == Float.TYPE) {
            if (defaultValue == null) {
                return new FloatColumn(nRows);
            }
            float def = ((Number)defaultValue).floatValue();
            return new FloatColumn(nRows, nRows, def);
        }
        if (type == Double.TYPE) {
            if (defaultValue == null) {
                return new DoubleColumn(nRows);
            }
            double def = ((Number)defaultValue).doubleValue();
            return new DoubleColumn(nRows, nRows, def);
        }
        if (type == Boolean.TYPE) {
            if (defaultValue == null) {
                return new BooleanColumn(nRows);
            }
            boolean def = (Boolean)defaultValue;
            return new BooleanColumn(nRows, nRows, def);
        }
        if (Date.class.isAssignableFrom(type)) {
            if (defaultValue == null) {
                return new DateColumn(type, nRows);
            }
            Date d = (Date)defaultValue;
            return new DateColumn(type, nRows, nRows, d.getTime());
        }
        if (type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Void.TYPE) {
            throw new DataTypeException(type);
        }
        return new ObjectColumn(type, nRows, nRows, defaultValue);
    }

    public static final Column getColumn(Table t, Expression expr) {
        return new ExpressionColumn(t, expr);
    }

    public static final Column getConstantColumn(Class type, Object dFlt) {
        return new ConstantColumn(type, dFlt);
    }
}

