/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Date;
import prefuse.data.DataTypeException;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ObjectParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class AbstractColumn
implements Column {
    protected final Class m_columnType;
    protected DataParser m_parser;
    protected Object m_defaultValue;
    protected boolean m_readOnly;
    protected CopyOnWriteArrayList m_listeners;

    public AbstractColumn() {
        this(Object.class, null);
    }

    public AbstractColumn(Class columnType) {
        this(columnType, null);
    }

    public AbstractColumn(Class columnType, Object defaultValue) {
        this.m_columnType = columnType;
        DataParser p = ParserFactory.getDefaultFactory().getParser(columnType);
        this.m_parser = p == null ? new ObjectParser() : p;
        this.setDefaultValue(defaultValue);
        this.m_readOnly = false;
        this.m_listeners = new CopyOnWriteArrayList();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    @Override
    public boolean isCellEditable(int row) {
        return !this.m_readOnly;
    }

    @Override
    public Class getColumnType() {
        return this.m_columnType;
    }

    @Override
    public DataParser getParser() {
        return this.m_parser;
    }

    @Override
    public void setParser(DataParser parser) {
        if (!this.m_columnType.isAssignableFrom(parser.getType())) {
            throw new IllegalArgumentException("Parser type (" + parser.getType().getName() + ") incompatible with" + " this column's data type (" + this.m_columnType.getName() + ")");
        }
        this.m_parser = parser;
    }

    @Override
    public void addColumnListener(ColumnListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeColumnListener(ColumnListener listener) {
        this.m_listeners.remove(listener);
    }

    protected final void fireColumnEvent(int type, int start, int end) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged(this, type, start, end);
        }
    }

    protected final void fireColumnEvent(int idx, int prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    protected final void fireColumnEvent(int idx, long prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    protected final void fireColumnEvent(int idx, float prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    protected final void fireColumnEvent(int idx, double prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    protected final void fireColumnEvent(int idx, boolean prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    protected final void fireColumnEvent(int idx, Object prev) {
        Object[] listeners = this.m_listeners.getArray();
        for (int i = 0; i < listeners.length; ++i) {
            ((ColumnListener)listeners[i]).columnChanged((Column)this, idx, prev);
        }
    }

    @Override
    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public void setDefaultValue(Object dFlt) {
        boolean prim = this.m_columnType.isPrimitive();
        if (dFlt != null && (!prim && !this.m_columnType.isInstance(dFlt) || prim && !TypeLib.isWrapperInstance(this.m_columnType, dFlt))) {
            throw new IllegalArgumentException("Default value is not of type " + this.m_columnType.getName());
        }
        this.m_defaultValue = dFlt;
    }

    @Override
    public void revertToDefault(int row) {
        this.set(this.m_defaultValue, row);
    }

    @Override
    public boolean canGet(Class type) {
        if (type == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            boolean primTypes = type.isAssignableFrom(this.m_columnType) || TypeLib.isNumericType(this.m_columnType) && TypeLib.isNumericType(type);
            return primTypes || type.isAssignableFrom(TypeLib.getWrapperType(this.m_columnType)) || type.isAssignableFrom(String.class);
        }
        return type.isAssignableFrom(this.m_columnType);
    }

    @Override
    public boolean canSet(Class type) {
        if (type == null) {
            return false;
        }
        if (this.m_columnType.isPrimitive()) {
            return this.m_columnType.isAssignableFrom(type) || TypeLib.getWrapperType(this.m_columnType).isAssignableFrom(type) || String.class.isAssignableFrom(type);
        }
        return this.m_columnType.isAssignableFrom(type);
    }

    @Override
    public boolean canGetInt() {
        return this.canGet(Integer.TYPE);
    }

    @Override
    public boolean canSetInt() {
        return this.canSet(Integer.TYPE);
    }

    @Override
    public int getInt(int row) throws DataTypeException {
        if (this.canGetInt()) {
            return (Integer)this.get(row);
        }
        throw new DataTypeException(Integer.TYPE);
    }

    @Override
    public void setInt(int val, int row) throws DataTypeException {
        if (!this.canSetInt()) {
            throw new DataTypeException(Integer.TYPE);
        }
        this.set(new Integer(val), row);
    }

    @Override
    public boolean canGetLong() {
        return this.canGet(Long.TYPE);
    }

    @Override
    public boolean canSetLong() {
        return this.canSet(Long.TYPE);
    }

    @Override
    public long getLong(int row) throws DataTypeException {
        if (this.canGetLong()) {
            return (Long)this.get(row);
        }
        throw new DataTypeException(Long.TYPE);
    }

    @Override
    public void setLong(long val, int row) throws DataTypeException {
        if (!this.canSetLong()) {
            throw new DataTypeException(Long.TYPE);
        }
        this.set(new Long(val), row);
    }

    @Override
    public boolean canGetFloat() {
        return this.canGet(Float.TYPE);
    }

    @Override
    public boolean canSetFloat() {
        return this.canSet(Float.TYPE);
    }

    @Override
    public float getFloat(int row) throws DataTypeException {
        if (this.canGetFloat()) {
            return ((Float)this.get(row)).floatValue();
        }
        throw new DataTypeException(Float.TYPE);
    }

    @Override
    public void setFloat(float val, int row) throws DataTypeException {
        if (!this.canSetFloat()) {
            throw new DataTypeException(Float.TYPE);
        }
        this.set(new Float(val), row);
    }

    @Override
    public boolean canGetDouble() {
        return this.canGet(Double.TYPE);
    }

    @Override
    public boolean canSetDouble() {
        return this.canSet(Double.TYPE);
    }

    @Override
    public double getDouble(int row) throws DataTypeException {
        if (this.canGetDouble()) {
            return (Double)this.get(row);
        }
        throw new DataTypeException(Double.TYPE);
    }

    @Override
    public void setDouble(double val, int row) throws DataTypeException {
        if (!this.canSetDouble()) {
            throw new DataTypeException(Double.TYPE);
        }
        this.set(new Double(val), row);
    }

    @Override
    public boolean canGetBoolean() {
        return this.canGet(Boolean.TYPE);
    }

    @Override
    public boolean canSetBoolean() {
        return this.canSet(Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(int row) throws DataTypeException {
        if (this.canGetBoolean()) {
            return (Boolean)this.get(row);
        }
        throw new DataTypeException(Boolean.TYPE);
    }

    @Override
    public void setBoolean(boolean val, int row) throws DataTypeException {
        if (!this.canSetBoolean()) {
            throw new DataTypeException(Boolean.TYPE);
        }
        this.set(val, row);
    }

    @Override
    public boolean canGetString() {
        return true;
    }

    @Override
    public boolean canSetString() {
        return this.m_parser != null && !(this.m_parser instanceof ObjectParser);
    }

    @Override
    public String getString(int row) throws DataTypeException {
        if (this.canGetString()) {
            return this.m_parser.format(this.get(row));
        }
        throw new DataTypeException(String.class);
    }

    @Override
    public void setString(String val, int row) throws DataTypeException {
        try {
            this.set(this.m_parser.parse(val), row);
        }
        catch (DataParseException e) {
            throw new DataTypeException(e);
        }
    }

    @Override
    public boolean canGetDate() {
        return this.canGet(Date.class);
    }

    @Override
    public boolean canSetDate() {
        return this.canSet(Date.class);
    }

    @Override
    public Date getDate(int row) throws DataTypeException {
        if (this.canGetDate()) {
            return (Date)this.get(row);
        }
        throw new DataTypeException(Date.class);
    }

    @Override
    public void setDate(Date val, int row) throws DataTypeException {
        this.set(val, row);
    }
}

