/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.GraphListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.TableEdge;
import prefuse.data.tuple.TableNode;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.Index;
import prefuse.data.util.NeighborIterator;
import prefuse.util.PrefuseConfig;
import prefuse.util.TypeLib;
import prefuse.util.collections.CompositeIntIterator;
import prefuse.util.collections.CompositeIterator;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntArrayIterator;
import prefuse.util.collections.IntIterator;

public class Graph
extends CompositeTupleSet {
    public static final int INEDGES = 0;
    public static final int OUTEDGES = 1;
    public static final int UNDIRECTED = 2;
    public static final String DEFAULT_NODE_KEY = PrefuseConfig.get("data.graph.nodeKey");
    public static final String DEFAULT_SOURCE_KEY = PrefuseConfig.get("data.graph.sourceKey");
    public static final String DEFAULT_TARGET_KEY = PrefuseConfig.get("data.graph.targetKey");
    public static final String NODES = PrefuseConfig.get("data.graph.nodeGroup");
    public static final String EDGES = PrefuseConfig.get("data.graph.edgeGroup");
    protected Table m_links;
    protected TupleManager m_nodeTuples;
    protected TupleManager m_edgeTuples;
    protected boolean m_directed = false;
    protected SpanningTree m_spanning = null;
    protected String m_nkey;
    protected String m_skey;
    protected String m_tkey;
    protected Index m_nidx;
    protected boolean m_longKey = false;
    private Listener m_listener;
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected static final String INDEGREE = "_indegree";
    protected static final String OUTDEGREE = "_outdegree";
    protected static final String INLINKS = "_inlinks";
    protected static final String OUTLINKS = "_outlinks";
    protected static final Schema LINKS_SCHEMA = new Schema();

    public Graph() {
        this(false);
    }

    public Graph(boolean directed) {
        this(new Table(), directed);
    }

    public Graph(Table nodes, boolean directed) {
        this(nodes, directed, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table nodes, boolean directed, String nodeKey, String sourceKey, String targetKey) {
        Table edges = new Table();
        edges.addColumn(sourceKey, Integer.TYPE, new Integer(-1));
        edges.addColumn(targetKey, Integer.TYPE, new Integer(-1));
        this.init(nodes, edges, directed, nodeKey, sourceKey, targetKey);
    }

    public Graph(Table nodes, Table edges, boolean directed) {
        this(nodes, edges, directed, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table nodes, Table edges, boolean directed, String sourceKey, String targetKey) {
        this.init(nodes, edges, directed, DEFAULT_NODE_KEY, sourceKey, targetKey);
    }

    public Graph(Table nodes, Table edges, boolean directed, String nodeKey, String sourceKey, String targetKey) {
        this.init(nodes, edges, directed, nodeKey, sourceKey, targetKey);
    }

    protected void init(Table nodes, Table edges, boolean directed, String nodeKey, String sourceKey, String targetKey) {
        if (nodeKey != null && !TypeLib.isIntegerType(nodes.getColumnType(nodeKey)) || !TypeLib.isIntegerType(edges.getColumnType(sourceKey)) || !TypeLib.isIntegerType(edges.getColumnType(targetKey))) {
            throw new IllegalArgumentException("Incompatible column types for graph keys");
        }
        this.removeAllSets();
        super.addSet(EDGES, edges);
        super.addSet(NODES, nodes);
        this.m_directed = directed;
        this.m_nkey = nodeKey;
        this.m_skey = sourceKey;
        this.m_tkey = targetKey;
        if (nodeKey != null) {
            if (nodes.getColumnType(nodeKey) == Long.TYPE) {
                this.m_longKey = true;
            }
            nodes.index(nodeKey);
            this.m_nidx = nodes.getIndex(nodeKey);
        }
        if (this.m_nodeTuples == null) {
            this.m_nodeTuples = new TupleManager(nodes, this, TableNode.class);
        }
        this.m_edgeTuples = new TupleManager(edges, this, TableEdge.class);
        this.initLinkTable();
        if (this.m_listener == null) {
            this.m_listener = new Listener();
        }
        nodes.addTableListener(this.m_listener);
        edges.addTableListener(this.m_listener);
        this.m_listener.setEdgeTable(edges);
    }

    public void setTupleManagers(TupleManager ntm, TupleManager etm) {
        if (!Node.class.isAssignableFrom(ntm.getTupleType())) {
            throw new IllegalArgumentException("The provided node TupleManager must generate tuples that implement the Node interface.");
        }
        if (!Edge.class.isAssignableFrom(etm.getTupleType())) {
            throw new IllegalArgumentException("The provided edge TupleManager must generate tuples that implement the Edge interface.");
        }
        this.m_nodeTuples = ntm;
        this.m_edgeTuples = etm;
    }

    public void dispose() {
        this.getNodeTable().removeTableListener(this.m_listener);
        this.getEdgeTable().removeTableListener(this.m_listener);
    }

    public void setEdgeTable(Table edges) {
        Table oldEdges = this.getEdgeTable();
        oldEdges.removeTableListener(this.m_listener);
        this.m_edgeTuples.invalidateAll();
        this.m_links.clear();
        this.init(this.getNodeTable(), edges, this.m_directed, this.m_nkey, this.m_skey, this.m_tkey);
    }

    protected void initLinkTable() {
        this.m_links = this.createLinkTable();
        IntIterator edges = this.getEdgeTable().rows();
        while (edges.hasNext()) {
            this.updateDegrees(edges.nextInt(), 1);
        }
    }

    protected Table createLinkTable() {
        return LINKS_SCHEMA.instantiate(this.getNodeTable().getMaximumRow() + 1);
    }

    protected void updateDegrees(int e, int incr) {
        if (!this.getEdgeTable().isValidRow(e)) {
            return;
        }
        int s = this.getSourceNode(e);
        int t = this.getTargetNode(e);
        if (s < 0 || t < 0) {
            return;
        }
        this.updateDegrees(e, s, t, incr);
        if (incr < 0) {
            this.m_edgeTuples.invalidate(e);
        }
    }

    protected void updateDegrees(int e, int s, int t, int incr) {
        int od = this.m_links.getInt(s, OUTDEGREE);
        int id = this.m_links.getInt(t, INDEGREE);
        if (incr > 0) {
            this.addLink(OUTLINKS, od, s, e);
            this.addLink(INLINKS, id, t, e);
        } else if (incr < 0) {
            this.remLink(OUTLINKS, od, s, e);
            this.remLink(INLINKS, id, t, e);
        }
        this.m_links.setInt(s, OUTDEGREE, od + incr);
        this.m_links.setInt(t, INDEGREE, id + incr);
        this.m_spanning = null;
    }

    protected void addLink(String field, int len, int n, int e) {
        int[] array = (int[])this.m_links.get(n, field);
        if (array == null) {
            array = new int[]{e};
            this.m_links.set(n, field, (Object)array);
            return;
        }
        if (len == array.length) {
            int[] narray = new int[Math.max(3 * array.length / 2, len + 1)];
            System.arraycopy(array, 0, narray, 0, array.length);
            array = narray;
            this.m_links.set(n, field, (Object)array);
        }
        array[len] = e;
    }

    protected boolean remLink(String field, int len, int n, int e) {
        int[] array = (int[])this.m_links.get(n, field);
        for (int i = 0; i < len; ++i) {
            if (array[i] != e) continue;
            System.arraycopy(array, i + 1, array, i, len - i - 1);
            return true;
        }
        return false;
    }

    protected void updateNodeData(int r, boolean added) {
        if (added) {
            this.m_links.addRow();
        } else {
            this.m_nodeTuples.invalidate(r);
            this.m_links.removeRow(r);
        }
    }

    public String getNodeKeyField() {
        return this.m_nkey;
    }

    public String getEdgeSourceField() {
        return this.m_skey;
    }

    public String getEdgeTargetField() {
        return this.m_tkey;
    }

    public long getKey(int node) {
        return this.m_nkey == null ? (long)node : this.getNodeTable().getLong(node, this.m_nkey);
    }

    public int getNodeIndex(long key) {
        if (this.m_nidx == null) {
            return (int)key;
        }
        int idx = this.m_longKey ? this.m_nidx.get(key) : this.m_nidx.get((int)key);
        return idx < 0 ? -1 : idx;
    }

    public int addNodeRow() {
        return this.getNodeTable().addRow();
    }

    public Node addNode() {
        int nrow = this.addNodeRow();
        return (Node)this.m_nodeTuples.getTuple(nrow);
    }

    public int addEdge(int s, int t) {
        long key1 = this.getKey(s);
        long key2 = this.getKey(t);
        Table edges = this.getEdgeTable();
        int r = edges.addRow();
        if (this.m_longKey) {
            edges.setLong(r, this.m_skey, key1);
            edges.setLong(r, this.m_tkey, key2);
        } else {
            edges.setInt(r, this.m_skey, (int)key1);
            edges.setInt(r, this.m_tkey, (int)key2);
        }
        return r;
    }

    public Edge addEdge(Node s, Node t) {
        this.nodeCheck(s, true);
        this.nodeCheck(t, true);
        int e = this.addEdge(s.getRow(), t.getRow());
        return this.getEdge(e);
    }

    public boolean removeNode(int node) {
        Table nodeTable = this.getNodeTable();
        if (nodeTable.isValidRow(node)) {
            int od;
            int id = this.getInDegree(node);
            if (id > 0) {
                int[] links = (int[])this.m_links.get(node, INLINKS);
                int i = id;
                while (--i >= 0) {
                    this.removeEdge(links[i]);
                }
            }
            if ((od = this.getOutDegree(node)) > 0) {
                int[] links = (int[])this.m_links.get(node, OUTLINKS);
                int i = od;
                while (--i >= 0) {
                    this.removeEdge(links[i]);
                }
            }
        }
        return nodeTable.removeRow(node);
    }

    public boolean removeNode(Node n) {
        this.nodeCheck(n, true);
        return this.removeNode(n.getRow());
    }

    public boolean removeEdge(int edge) {
        return this.getEdgeTable().removeRow(edge);
    }

    public boolean removeEdge(Edge e) {
        this.edgeCheck(e, true);
        return this.removeEdge(e.getRow());
    }

    protected void clearEdges() {
        this.getEdgeTable().clear();
    }

    protected boolean nodeCheck(Node n, boolean throwException) {
        if (!n.isValid()) {
            if (throwException) {
                throw new IllegalArgumentException("Node must be valid.");
            }
            return false;
        }
        Graph ng = n.getGraph();
        if (ng != this && ng.m_spanning != this) {
            if (throwException) {
                throw new IllegalArgumentException("Node must be part of this Graph.");
            }
            return false;
        }
        return true;
    }

    public TupleSet getNodes() {
        return this.getSet(NODES);
    }

    public Table getNodeTable() {
        return (Table)this.getSet(NODES);
    }

    public int getNodeCount() {
        return this.getNodeTable().getRowCount();
    }

    public Node getNode(int n) {
        return (Node)this.m_nodeTuples.getTuple(n);
    }

    public Node getNodeFromKey(long key) {
        int n = this.getNodeIndex(key);
        return n < 0 ? null : this.getNode(n);
    }

    public int getInDegree(int node) {
        return this.m_links.getInt(node, INDEGREE);
    }

    public int getInDegree(Node n) {
        this.nodeCheck(n, true);
        return this.getInDegree(n.getRow());
    }

    public int getOutDegree(int node) {
        return this.m_links.getInt(node, OUTDEGREE);
    }

    public int getOutDegree(Node n) {
        this.nodeCheck(n, true);
        return this.getOutDegree(n.getRow());
    }

    public int getDegree(int node) {
        return this.getInDegree(node) + this.getOutDegree(node);
    }

    public int getDegree(Node n) {
        this.nodeCheck(n, true);
        return this.getDegree(n.getRow());
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    protected boolean edgeCheck(Edge e, boolean throwException) {
        if (!e.isValid()) {
            if (throwException) {
                throw new IllegalArgumentException("Edge must be valid.");
            }
            return false;
        }
        if (e.getGraph() != this) {
            if (throwException) {
                throw new IllegalArgumentException("Edge must be part of this Graph.");
            }
            return false;
        }
        return true;
    }

    public TupleSet getEdges() {
        return this.getSet(EDGES);
    }

    public Table getEdgeTable() {
        return (Table)this.getSet(EDGES);
    }

    public int getEdgeCount() {
        return this.getEdgeTable().getRowCount();
    }

    public Edge getEdge(int e) {
        return e < 0 ? null : (Edge)this.m_edgeTuples.getTuple(e);
    }

    public int getEdge(int source, int target) {
        int outd = this.getOutDegree(source);
        if (outd > 0) {
            int[] edges = (int[])this.m_links.get(source, OUTLINKS);
            for (int i = 0; i < outd; ++i) {
                if (this.getTargetNode(edges[i]) != target) continue;
                return edges[i];
            }
        }
        return -1;
    }

    public Edge getEdge(Node source, Node target) {
        this.nodeCheck(source, true);
        this.nodeCheck(target, true);
        return this.getEdge(this.getEdge(source.getRow(), target.getRow()));
    }

    public int getSourceNode(int edge) {
        return this.getNodeIndex(this.getEdgeTable().getLong(edge, this.m_skey));
    }

    public Node getSourceNode(Edge e) {
        this.edgeCheck(e, true);
        return this.getNode(this.getSourceNode(e.getRow()));
    }

    public int getTargetNode(int edge) {
        return this.getNodeIndex(this.getEdgeTable().getLong(edge, this.m_tkey));
    }

    public Node getTargetNode(Edge e) {
        this.edgeCheck(e, true);
        return this.getNode(this.getTargetNode(e.getRow()));
    }

    public int getAdjacentNode(int edge, int node) {
        int s = this.getSourceNode(edge);
        int d = this.getTargetNode(edge);
        if (s == node) {
            return d;
        }
        if (d == node) {
            return s;
        }
        throw new IllegalArgumentException("Edge is not incident on the input node.");
    }

    public Node getAdjacentNode(Edge e, Node n) {
        this.edgeCheck(e, true);
        this.nodeCheck(n, true);
        return this.getNode(this.getAdjacentNode(e.getRow(), n.getRow()));
    }

    public IntIterator nodeRows() {
        return this.getNodeTable().rows();
    }

    public IntIterator edgeRows() {
        return this.getEdgeTable().rows();
    }

    public IntIterator edgeRows(int node) {
        return this.edgeRows(node, 2);
    }

    public IntIterator edgeRows(int node, int direction) {
        if (direction == 1) {
            int[] outedges = (int[])this.m_links.get(node, OUTLINKS);
            return new IntArrayIterator(outedges, 0, this.getOutDegree(node));
        }
        if (direction == 0) {
            int[] inedges = (int[])this.m_links.get(node, INLINKS);
            return new IntArrayIterator(inedges, 0, this.getInDegree(node));
        }
        if (direction == 2) {
            return new CompositeIntIterator(this.edgeRows(node, 1), this.edgeRows(node, 0));
        }
        throw new IllegalArgumentException("Unrecognized edge type: " + direction + ". Type should be one of Graph.OUTEDGES, " + "Graoh.INEDGES, or Graph.ALL");
    }

    public IntIterator inEdgeRows(int node) {
        return this.edgeRows(node, 0);
    }

    public IntIterator outEdgeRows(int node) {
        return this.edgeRows(node, 1);
    }

    public Iterator nodes() {
        return this.m_nodeTuples.iterator(this.nodeRows());
    }

    public Iterator neighbors(Node n) {
        return new NeighborIterator(n, this.edges(n));
    }

    public Iterator inNeighbors(Node n) {
        return new NeighborIterator(n, this.inEdges(n));
    }

    public Iterator outNeighbors(Node n) {
        return new NeighborIterator(n, this.outEdges(n));
    }

    public Iterator edges() {
        return this.m_edgeTuples.iterator(this.edgeRows());
    }

    public Iterator edges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.edgeRows(node.getRow(), 2));
    }

    public Iterator inEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.inEdgeRows(node.getRow()));
    }

    public Iterator outEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.outEdgeRows(node.getRow()));
    }

    @Override
    public void clear() {
        this.m_nodeTuples.invalidateAll();
        this.m_edgeTuples.invalidateAll();
        super.clear();
        this.m_links.clear();
    }

    @Override
    public boolean removeTuple(Tuple t) {
        if (t instanceof Node) {
            return this.removeNode((Node)t);
        }
        if (t instanceof Edge) {
            return this.removeEdge((Edge)t);
        }
        throw new IllegalArgumentException("Input tuple must be part of this graph");
    }

    @Override
    public Iterator tuples(Predicate filter) {
        if (filter == null) {
            return this.tuples();
        }
        return new CompositeIterator(this.m_edgeTuples.iterator(this.getEdgeTable().rows(filter)), this.m_nodeTuples.iterator(this.getNodeTable().rows(filter)));
    }

    @Override
    public Iterator tuples() {
        return new CompositeIterator(this.edges(), this.nodes());
    }

    public Tree getSpanningTree() {
        if (this.m_spanning == null) {
            return this.getSpanningTree((Node)this.nodes().next());
        }
        return this.m_spanning;
    }

    public Tree getSpanningTree(Node root) {
        this.nodeCheck(root, true);
        if (this.m_spanning == null) {
            this.m_spanning = new SpanningTree(this, root);
        } else if (this.m_spanning.getRoot() != root) {
            this.m_spanning.buildSpanningTree(root);
        }
        return this.m_spanning;
    }

    public void clearSpanningTree() {
        this.m_spanning = null;
    }

    public void addGraphModelListener(GraphListener listnr) {
        if (!this.m_listeners.contains(listnr)) {
            this.m_listeners.add(listnr);
        }
    }

    public void removeGraphModelListener(GraphListener listnr) {
        this.m_listeners.remove(listnr);
    }

    public void removeAllGraphModelListeners() {
        this.m_listeners.clear();
    }

    protected void fireGraphEvent(Table t, int first, int last, int col, int type) {
        String table;
        String string = table = t == this.getNodeTable() ? NODES : EDGES;
        if (type != 0) {
            this.fireTupleEvent(t, first, last, type);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] lstnrs = this.m_listeners.getArray();
            for (int i = 0; i < lstnrs.length; ++i) {
                ((GraphListener)lstnrs[i]).graphChanged(this, table, first, last, col, type);
            }
        }
    }

    static {
        Integer defaultValue = new Integer(0);
        LINKS_SCHEMA.addColumn(INDEGREE, Integer.TYPE, defaultValue);
        LINKS_SCHEMA.addColumn(OUTDEGREE, Integer.TYPE, defaultValue);
        LINKS_SCHEMA.addColumn(INLINKS, int[].class);
        LINKS_SCHEMA.addColumn(OUTLINKS, int[].class);
        LINKS_SCHEMA.lockSchema();
    }

    protected class Listener
    implements TableListener,
    ColumnListener {
        private Table m_edges;
        private Column m_scol;
        private Column m_tcol;
        private int m_sidx;
        private int m_tidx;

        protected Listener() {
        }

        public void setEdgeTable(Table edges) {
            if (this.m_scol != null) {
                this.m_scol.removeColumnListener(this);
            }
            if (this.m_tcol != null) {
                this.m_tcol.removeColumnListener(this);
            }
            this.m_tcol = null;
            this.m_scol = null;
            this.m_tidx = -1;
            this.m_sidx = -1;
            this.m_edges = edges;
            if (this.m_edges != null) {
                this.m_sidx = edges.getColumnNumber(Graph.this.m_skey);
                this.m_tidx = edges.getColumnNumber(Graph.this.m_tkey);
                this.m_scol = edges.getColumn(this.m_sidx);
                this.m_tcol = edges.getColumn(this.m_tidx);
                this.m_scol.addColumnListener(this);
                this.m_tcol.addColumnListener(this);
            }
        }

        @Override
        public void tableChanged(Table t, int start, int end, int col, int type) {
            if (!Graph.this.containsSet(t)) {
                throw new IllegalStateException("Graph shouldn't be listening to an unrelated table");
            }
            if (type != 0) {
                if (t == Graph.this.getNodeTable()) {
                    if (col == -1) {
                        boolean added = type == 1;
                        for (int r = start; r <= end; ++r) {
                            Graph.this.updateNodeData(r, added);
                        }
                    }
                } else if (col == -1) {
                    boolean added = type == 1;
                    for (int r = start; r <= end; ++r) {
                        Graph.this.updateDegrees(start, added ? 1 : -1);
                    }
                }
                Graph.this.m_spanning = null;
            }
            Graph.this.fireGraphEvent(t, start, end, col, type);
        }

        @Override
        public void columnChanged(Column src, int idx, int prev) {
            this.columnChanged(src, idx, (long)prev);
        }

        @Override
        public void columnChanged(Column src, int idx, long prev) {
            if (src == this.m_scol || src == this.m_tcol) {
                boolean isSrc = src == this.m_scol;
                int e = this.m_edges.getTableRow(idx, isSrc ? this.m_sidx : this.m_tidx);
                if (e == -1) {
                    return;
                }
                int s = Graph.this.getSourceNode(e);
                int t = Graph.this.getTargetNode(e);
                int p = Graph.this.getNodeIndex(prev);
                if (p > -1 && (isSrc && t > -1 || !isSrc && s > -1)) {
                    Graph.this.updateDegrees(e, isSrc ? p : s, isSrc ? t : p, -1);
                }
                if (s > -1 && t > -1) {
                    Graph.this.updateDegrees(e, s, t, 1);
                }
            } else {
                throw new IllegalStateException();
            }
        }

        @Override
        public void columnChanged(Column src, int type, int start, int end) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column src, int idx, float prev) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column src, int idx, double prev) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column src, int idx, boolean prev) {
            throw new IllegalStateException();
        }

        @Override
        public void columnChanged(Column src, int idx, Object prev) {
            throw new IllegalStateException();
        }
    }
}

