/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

public class ToolTipControl
extends ControlAdapter {
    private String[] label;
    private StringBuffer sBuf;

    public ToolTipControl(String field) {
        this(new String[]{field});
    }

    public ToolTipControl(String[] fields) {
        this.label = fields;
        if (fields.length > 1) {
            this.sBuf = new StringBuffer();
        }
    }

    @Override
    public void itemEntered(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        if (this.label.length == 1) {
            if (item.canGetString(this.label[0])) {
                d.setToolTipText(item.getString(this.label[0]));
            }
        } else {
            this.sBuf.delete(0, this.sBuf.length());
            for (int i = 0; i < this.label.length; ++i) {
                if (!item.canGetString(this.label[i])) continue;
                if (this.sBuf.length() > 0) {
                    this.sBuf.append("; ");
                }
                this.sBuf.append(item.getString(this.label[i]));
            }
            if (this.sBuf.length() > 0) {
                d.setToolTipText(this.sBuf.toString());
            }
        }
    }

    @Override
    public void itemExited(VisualItem item, MouseEvent e) {
        Display d = (Display)e.getSource();
        d.setToolTipText(null);
    }
}

