/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class SubtreeDragControl
extends ControlAdapter {
    private Point2D down = new Point2D.Double();
    private Point2D tmp = new Point2D.Double();
    private boolean wasFixed;

    @Override
    public void itemEntered(VisualItem item, MouseEvent e) {
        if (!(item instanceof NodeItem)) {
            return;
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void itemExited(VisualItem item, MouseEvent e) {
        if (!(item instanceof NodeItem)) {
            return;
        }
        Display d = (Display)e.getSource();
        d.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void itemPressed(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!(item instanceof NodeItem)) {
            return;
        }
        Display d = (Display)e.getComponent();
        this.down = d.getAbsoluteCoordinate(e.getPoint(), this.down);
        this.wasFixed = item.isFixed();
        item.setFixed(true);
    }

    @Override
    public void itemReleased(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!(item instanceof NodeItem)) {
            return;
        }
        item.setFixed(this.wasFixed);
    }

    @Override
    public void itemDragged(VisualItem item, MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (!(item instanceof NodeItem)) {
            return;
        }
        Display d = (Display)e.getComponent();
        this.tmp = d.getAbsoluteCoordinate(e.getPoint(), this.tmp);
        double dx = this.tmp.getX() - this.down.getX();
        double dy = this.tmp.getY() - this.down.getY();
        this.updateLocations((NodeItem)item, dx, dy);
        this.down.setLocation(this.tmp);
        item.getVisualization().repaint();
    }

    private void updateLocations(NodeItem n, double dx, double dy) {
        double x = n.getX();
        double y = n.getY();
        n.setStartX(x);
        n.setStartY(y);
        n.setX(x += dx);
        n.setY(y += dy);
        n.setEndX(x);
        n.setEndY(y);
        Iterator children = n.children();
        while (children.hasNext()) {
            this.updateLocations((NodeItem)children.next(), dx, dy);
        }
    }
}

