/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;

public class RotationControl
extends ControlAdapter {
    private Point down = new Point();
    private double baseAngle = 0.0;
    private int m_button;

    public RotationControl() {
        this(16);
    }

    public RotationControl(int mouseButton) {
        this.m_button = mouseButton;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            Display display = (Display)e.getComponent();
            display.setCursor(Cursor.getPredefinedCursor(11));
            this.down.setLocation(e.getPoint());
            this.baseAngle = Double.NaN;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            int dy = e.getY() - this.down.y;
            int dx = e.getX() - this.down.x;
            double angle = Math.atan2(dy, dx);
            if (!Double.isNaN(this.baseAngle)) {
                Display display = (Display)e.getComponent();
                display.rotate(this.down, angle - this.baseAngle);
            }
            this.baseAngle = angle;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }
}

