/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import prefuse.controls.ControlAdapter;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class NeighborHighlightControl
extends ControlAdapter {
    private String activity = null;
    private boolean highlightWithInvisibleEdge = false;

    public NeighborHighlightControl() {
        this(null);
    }

    public NeighborHighlightControl(String activity) {
        this.activity = activity;
    }

    @Override
    public void itemEntered(VisualItem item, MouseEvent e) {
        if (item instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)item, true);
        }
    }

    @Override
    public void itemExited(VisualItem item, MouseEvent e) {
        if (item instanceof NodeItem) {
            this.setNeighborHighlight((NodeItem)item, false);
        }
    }

    protected void setNeighborHighlight(NodeItem n, boolean state) {
        Iterator iter = n.edges();
        while (iter.hasNext()) {
            EdgeItem eItem = (EdgeItem)iter.next();
            NodeItem nItem = eItem.getAdjacentItem(n);
            if (!eItem.isVisible() && !this.highlightWithInvisibleEdge) continue;
            eItem.setHighlighted(state);
            nItem.setHighlighted(state);
        }
        if (this.activity != null) {
            n.getVisualization().run(this.activity);
        }
    }

    public boolean isHighlightWithInvisibleEdge() {
        return this.highlightWithInvisibleEdge;
    }

    public void setHighlightWithInvisibleEdge(boolean highlightWithInvisibleEdge) {
        this.highlightWithInvisibleEdge = highlightWithInvisibleEdge;
    }
}

