/*
 * Decompiled with CFR 0.152.
 */
package prefuse;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import prefuse.Display;
import prefuse.action.Action;
import prefuse.activity.Activity;
import prefuse.activity.ActivityMap;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.DefaultTupleSet;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.PrefuseConfig;
import prefuse.util.PrefuseLib;
import prefuse.util.collections.CompositeIterator;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.VisualTree;
import prefuse.visual.VisualTupleSet;
import prefuse.visual.expression.ValidatedPredicate;
import prefuse.visual.expression.VisiblePredicate;
import prefuse.visual.tuple.TableDecoratorItem;
import prefuse.visual.tuple.TableEdgeItem;
import prefuse.visual.tuple.TableNodeItem;

public class Visualization {
    public static final String ALL_ITEMS = PrefuseConfig.get("visualization.allItems");
    public static final String FOCUS_ITEMS = PrefuseConfig.get("visualization.focusItems");
    public static final String SELECTED_ITEMS = PrefuseConfig.get("visualization.selectedItems");
    public static final String SEARCH_ITEMS = PrefuseConfig.get("visualization.searchItems");
    private Map m_visual;
    private Map m_source;
    private Map m_focus;
    private ActivityMap m_actions = new ActivityMap();
    private RendererFactory m_renderers = new DefaultRendererFactory();
    private ArrayList m_displays;

    public Visualization() {
        this.m_visual = new LinkedHashMap();
        this.m_source = new HashMap();
        this.m_focus = new HashMap();
        this.m_displays = new ArrayList();
        this.addFocusGroup(FOCUS_ITEMS, new DefaultTupleSet());
        this.addFocusGroup(SELECTED_ITEMS, new DefaultTupleSet());
    }

    public synchronized VisualTupleSet add(String group, TupleSet data) {
        return this.add(group, data, null);
    }

    public synchronized VisualTupleSet add(String group, TupleSet data, Predicate filter) {
        if (data instanceof Table) {
            return this.addTable(group, (Table)data, filter);
        }
        if (data instanceof Tree) {
            return this.addTree(group, (Tree)data, filter);
        }
        if (data instanceof Graph) {
            return this.addGraph(group, (Graph)data, filter);
        }
        throw new IllegalArgumentException("Unsupported TupleSet type.");
    }

    protected void checkGroupExists(String group) {
        if (this.m_visual.containsKey(group) || this.m_focus.containsKey(group)) {
            throw new IllegalArgumentException("Group name '" + group + "' already in use");
        }
    }

    protected void addDataGroup(String group, VisualTupleSet ts, TupleSet src) {
        this.checkGroupExists(group);
        this.m_visual.put(group, ts);
        if (src != null) {
            this.m_source.put(group, src);
        }
    }

    public synchronized VisualTable addTable(String group) {
        VisualTable vt = new VisualTable(this, group);
        this.addDataGroup(group, vt, null);
        return vt;
    }

    public synchronized VisualTable addTable(String group, Schema schema) {
        VisualTable vt = new VisualTable(this, group, schema);
        this.addDataGroup(group, vt, null);
        return vt;
    }

    public synchronized VisualTable addTable(String group, Table table) {
        return this.addTable(group, table, (Predicate)null);
    }

    public synchronized VisualTable addTable(String group, Table table, Predicate filter) {
        VisualTable vt = new VisualTable(table, this, group, filter);
        this.addDataGroup(group, vt, table);
        return vt;
    }

    public synchronized VisualTable addTable(String group, Table table, Schema schema) {
        return this.addTable(group, table, null, schema);
    }

    public synchronized VisualTable addTable(String group, Table table, Predicate filter, Schema schema) {
        VisualTable vt = new VisualTable(table, this, group, filter, schema);
        this.addDataGroup(group, vt, table);
        return vt;
    }

    public synchronized VisualTable addTable(VisualTable table) {
        this.addDataGroup(table.getGroup(), table, table.getParentTable());
        table.setVisualization(this);
        return table;
    }

    public synchronized VisualGraph addGraph(String group, Graph graph) {
        return this.addGraph(group, graph, null);
    }

    public synchronized VisualGraph addGraph(String group, Graph graph, Predicate filter) {
        return this.addGraph(group, graph, filter, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualGraph addGraph(String group, Graph graph, Predicate filter, Schema nodeSchema, Schema edgeSchema) {
        this.checkGroupExists(group);
        String nGroup = PrefuseLib.getGroupName(group, Graph.NODES);
        String eGroup = PrefuseLib.getGroupName(group, Graph.EDGES);
        VisualTable nt = this.addTable(nGroup, graph.getNodeTable(), filter, nodeSchema);
        VisualTable et = this.addTable(eGroup, graph.getEdgeTable(), filter, edgeSchema);
        VisualGraph vg = new VisualGraph(nt, et, graph.isDirected(), graph.getNodeKeyField(), graph.getEdgeSourceField(), graph.getEdgeTargetField());
        vg.setVisualization(this);
        vg.setGroup(group);
        this.addDataGroup(group, vg, graph);
        TupleManager ntm = new TupleManager(nt, vg, TableNodeItem.class);
        TupleManager etm = new TupleManager(et, vg, TableEdgeItem.class);
        nt.setTupleManager(ntm);
        et.setTupleManager(etm);
        vg.setTupleManagers(ntm, etm);
        return vg;
    }

    public synchronized VisualTree addTree(String group, Tree tree) {
        return this.addTree(group, tree, null);
    }

    public synchronized VisualTree addTree(String group, Tree tree, Predicate filter) {
        return this.addTree(group, tree, filter, VisualItem.SCHEMA, VisualItem.SCHEMA);
    }

    public synchronized VisualTree addTree(String group, Tree tree, Predicate filter, Schema nodeSchema, Schema edgeSchema) {
        this.checkGroupExists(group);
        String nGroup = PrefuseLib.getGroupName(group, Graph.NODES);
        String eGroup = PrefuseLib.getGroupName(group, Graph.EDGES);
        VisualTable nt = this.addTable(nGroup, tree.getNodeTable(), filter, nodeSchema);
        VisualTable et = this.addTable(eGroup, tree.getEdgeTable(), filter, edgeSchema);
        VisualTree vt = new VisualTree(nt, et, tree.getNodeKeyField(), tree.getEdgeSourceField(), tree.getEdgeTargetField());
        vt.setVisualization(this);
        vt.setGroup(group);
        this.addDataGroup(group, vt, tree);
        TupleManager ntm = new TupleManager(nt, vt, TableNodeItem.class);
        TupleManager etm = new TupleManager(et, vt, TableEdgeItem.class);
        nt.setTupleManager(ntm);
        et.setTupleManager(etm);
        vt.setTupleManagers(ntm, etm);
        return vt;
    }

    public synchronized AggregateTable addAggregates(String group) {
        return this.addAggregates(group, VisualItem.SCHEMA);
    }

    public synchronized AggregateTable addAggregates(String group, Schema schema) {
        AggregateTable vat = new AggregateTable(this, group, schema);
        this.addDataGroup(group, vat, null);
        return vat;
    }

    public synchronized VisualTable addDerivedTable(String group, String source, Predicate filter, Schema override) {
        VisualTable src = (VisualTable)this.getGroup(source);
        VisualTable vt = new VisualTable(src, this, group, filter, override);
        this.addDataGroup(group, vt, this.getSourceData(source));
        return vt;
    }

    public synchronized VisualTable addDecorators(String group, String source) {
        return this.addDecorators(group, source, (Predicate)null);
    }

    public synchronized VisualTable addDecorators(String group, String source, Schema schema) {
        return this.addDecorators(group, source, null, schema);
    }

    public synchronized VisualTable addDecorators(String group, String source, Predicate filter) {
        VisualTable t = this.addDerivedTable(group, source, filter, VisualItem.SCHEMA);
        t.setTupleManager(new TupleManager(t, null, TableDecoratorItem.class));
        return t;
    }

    public synchronized VisualTable addDecorators(String group, String source, Predicate filter, Schema schema) {
        VisualTable t = this.addDerivedTable(group, source, filter, schema);
        t.setTupleManager(new TupleManager(t, null, TableDecoratorItem.class));
        return t;
    }

    public synchronized boolean removeGroup(String group) {
        TupleSet ts = this.getFocusGroup(group);
        if (ts != null) {
            Iterator items = ts.tuples(ValidatedPredicate.TRUE);
            while (items.hasNext()) {
                ((VisualItem)items.next()).setValidated(false);
            }
            ts.clear();
            this.m_focus.remove(group);
            return true;
        }
        ts = this.getVisualGroup(group);
        if (ts == null) {
            return false;
        }
        TupleSet[] focus = new TupleSet[this.m_focus.size()];
        this.m_focus.values().toArray(focus);
        Iterator items = ts.tuples();
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            for (int j = 0; j < focus.length; ++j) {
                focus[j].removeTuple(item);
            }
            item.setValidated(false);
        }
        if (ts instanceof CompositeTupleSet) {
            CompositeTupleSet cts = (CompositeTupleSet)ts;
            Iterator names = cts.setNames();
            while (names.hasNext()) {
                String name = (String)names.next();
                String subgroup = PrefuseLib.getGroupName(group, name);
                this.m_visual.remove(subgroup);
                this.m_source.remove(subgroup);
            }
        }
        this.m_visual.remove(group);
        this.m_source.remove(group);
        return true;
    }

    public synchronized void reset() {
        for (Map.Entry entry : this.m_focus.entrySet()) {
            TupleSet ts = (TupleSet)entry.getValue();
            ts.clear();
        }
        this.m_visual.clear();
        this.m_source.clear();
    }

    public TupleSet getSourceData(String group) {
        return (TupleSet)this.m_source.get(group);
    }

    public TupleSet getSourceData(VisualTupleSet ts) {
        return (TupleSet)this.m_source.get(ts.getGroup());
    }

    public Tuple getSourceTuple(VisualItem item) {
        String group = item.getGroup();
        TupleSet source = this.getSourceData(group);
        if (source == null) {
            return null;
        }
        int row = item.getRow();
        Table t = item.getTable();
        while (t instanceof VisualTable) {
            VisualTable vt = (VisualTable)t;
            row = vt.getParentRow(row);
            t = vt.getParentTable();
        }
        String cGroup = PrefuseLib.getChildGroup(group);
        if (cGroup != null) {
            String pGroup = PrefuseLib.getParentGroup(group);
            Graph g = (Graph)this.getSourceData(pGroup);
            if (t == g.getNodeTable()) {
                return g.getNode(row);
            }
            return g.getEdge(row);
        }
        return t.getTuple(row);
    }

    public VisualItem getVisualItem(String group, Tuple t) {
        VisualTable vt;
        TupleSet ts = this.getVisualGroup(group);
        if (ts instanceof VisualTable) {
            vt = (VisualTable)ts;
        } else if (ts instanceof Graph) {
            Graph g = (Graph)ts;
            vt = (VisualTable)(t instanceof Node ? g.getNodeTable() : g.getEdgeTable());
        } else {
            return null;
        }
        int pr = t.getRow();
        int cr = vt.getChildRow(pr);
        return cr < 0 ? null : vt.getItem(cr);
    }

    public TupleSet getGroup(String group) {
        TupleSet ts = this.getVisualGroup(group);
        if (ts == null) {
            ts = this.getFocusGroup(group);
        }
        return ts;
    }

    public boolean isInGroup(VisualItem item, String group) {
        if (ALL_ITEMS.equals(group)) {
            return true;
        }
        if (item.getGroup().equals(group)) {
            return true;
        }
        TupleSet tSet = this.getGroup(group);
        return tSet == null ? false : tSet.containsTuple(item);
    }

    public void addFocusGroup(String group) {
        this.checkGroupExists(group);
        this.m_focus.put(group, new DefaultTupleSet());
    }

    public void addFocusGroup(String group, TupleSet tSet) {
        this.checkGroupExists(group);
        this.m_focus.put(group, tSet);
    }

    public int size(String group) {
        TupleSet tSet = this.getGroup(group);
        return tSet == null ? 0 : tSet.getTupleCount();
    }

    public TupleSet getVisualGroup(String group) {
        return (TupleSet)this.m_visual.get(group);
    }

    public TupleSet getFocusGroup(String group) {
        return (TupleSet)this.m_focus.get(group);
    }

    public void invalidate(String group) {
        Iterator items = this.items(group, ValidatedPredicate.TRUE);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            item.setValidated(false);
        }
    }

    public void invalidateAll() {
        this.invalidate(ALL_ITEMS);
    }

    public Iterator visibleItems() {
        return this.items(VisiblePredicate.TRUE);
    }

    public Iterator visibleItems(String group) {
        return this.items(group, VisiblePredicate.TRUE);
    }

    public Iterator items() {
        return this.items((Predicate)null);
    }

    public Iterator items(Predicate filter) {
        int size = this.m_visual.size();
        if (size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (size == 1) {
            Iterator it = this.m_visual.keySet().iterator();
            return this.items((String)it.next(), filter);
        }
        CompositeIterator iter = new CompositeIterator(this.m_visual.size());
        Iterator it = this.m_visual.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String group = (String)it.next();
            if (PrefuseLib.isChildGroup(group)) continue;
            iter.setIterator(i++, this.items(group, filter));
        }
        return iter;
    }

    public Iterator items(String group) {
        return this.items(group, (Predicate)null);
    }

    public Iterator items(String group, String expr) {
        Expression e = ExpressionParser.parse(expr);
        if (!(e instanceof Predicate) || ExpressionParser.getError() != null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.items(group, (Predicate)e);
    }

    public Iterator items(String group, Predicate filter) {
        if (ALL_ITEMS.equals(group)) {
            return this.items(filter);
        }
        TupleSet t = this.getGroup(group);
        return t == null ? Collections.EMPTY_LIST.iterator() : t.tuples(filter);
    }

    public void setValue(String group, Predicate p, String field, Object val) {
        Iterator items = this.items(group, p);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            item.set(field, val);
        }
    }

    public void setVisible(String group, Predicate p, boolean value) {
        Iterator items = this.items(group, p);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            item.setVisible(value);
        }
    }

    public void setInteractive(String group, Predicate p, boolean value) {
        Iterator items = this.items(group, p);
        while (items.hasNext()) {
            VisualItem item = (VisualItem)items.next();
            item.setInteractive(value);
        }
    }

    public Action putAction(String name, Action action) {
        action.setVisualization(this);
        this.m_actions.put(name, action);
        return action;
    }

    public Action getAction(String name) {
        return (Action)this.m_actions.get(name);
    }

    public Action removeAction(String name) {
        Action a = this.getAction(name);
        if (a != null) {
            a.cancel();
            this.m_actions.remove(name);
            a.setVisualization(null);
        }
        return a;
    }

    public Activity run(String action) {
        return this.m_actions.run(action);
    }

    public Activity runAfter(String action, long delay) {
        return this.m_actions.runAt(action, System.currentTimeMillis() + delay);
    }

    public Activity runAt(String action, long startTime) {
        return this.m_actions.runAt(action, startTime);
    }

    public Activity runAfter(String before, String after) {
        return this.m_actions.runAfter(before, after);
    }

    public Activity alwaysRunAfter(String before, String after) {
        return this.m_actions.alwaysRunAfter(before, after);
    }

    public Activity cancel(String action) {
        return this.m_actions.cancel(action);
    }

    public void setRendererFactory(RendererFactory rf) {
        this.invalidateAll();
        this.m_renderers = rf;
    }

    public RendererFactory getRendererFactory() {
        return this.m_renderers;
    }

    public Renderer getRenderer(VisualItem item) {
        if (item.getVisualization() != this) {
            throw new IllegalArgumentException("Input item not a member of this visualization.");
        }
        return this.m_renderers.getRenderer(item);
    }

    public synchronized void repaint() {
        Iterator items = this.items(ValidatedPredicate.FALSE);
        while (items.hasNext()) {
            ((VisualItem)items.next()).validateBounds();
        }
        for (int i = 0; i < this.m_displays.size(); ++i) {
            this.getDisplay(i).repaint();
        }
    }

    public Rectangle2D getBounds(String group) {
        return this.getBounds(group, new Rectangle2D.Double());
    }

    public Rectangle2D getBounds(String group, Rectangle2D r) {
        VisualItem item;
        Iterator iter = this.visibleItems(group);
        if (iter.hasNext()) {
            item = (VisualItem)iter.next();
            r.setRect(item.getBounds());
        }
        while (iter.hasNext()) {
            item = (VisualItem)iter.next();
            Rectangle2D.union(item.getBounds(), r, r);
        }
        return r;
    }

    public int getDisplayCount() {
        return this.m_displays.size();
    }

    void addDisplay(Display display) {
        this.m_displays.add(display);
    }

    public Display getDisplay(int idx) {
        return (Display)this.m_displays.get(idx);
    }

    boolean removeDisplay(Display display) {
        return this.m_displays.remove(display);
    }

    public void damageReport(VisualItem item, Rectangle2D region) {
        for (int i = 0; i < this.m_displays.size(); ++i) {
            Display d = this.getDisplay(i);
            if (!d.getPredicate().getBoolean(item)) continue;
            d.damageReport(region);
        }
    }
}

