/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import prefuse.Visualization;
import prefuse.data.CascadedTable;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.expression.Predicate;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTupleSet;
import prefuse.visual.tuple.TableVisualItem;

public class VisualTable
extends CascadedTable
implements VisualTupleSet {
    private Visualization m_vis;
    private String m_group;

    public VisualTable(Table parent, Visualization vis, String group) {
        this(parent, vis, group, null, VisualItem.SCHEMA);
    }

    public VisualTable(Table parent, Visualization vis, String group, Predicate rowFilter) {
        this(parent, vis, group, rowFilter, VisualItem.SCHEMA);
    }

    public VisualTable(Table parent, Visualization vis, String group, Predicate rowFilter, Schema schema) {
        super(parent, rowFilter, null, TableVisualItem.class);
        this.init(vis, group, schema);
    }

    public VisualTable(Visualization vis, String group) {
        super(TableVisualItem.class);
        this.init(vis, group, VisualItem.SCHEMA);
    }

    public VisualTable(Visualization vis, String group, Schema schema) {
        super(TableVisualItem.class);
        this.init(vis, group, schema);
    }

    public VisualTable(Visualization vis, String group, Schema schema, Class tupleType) {
        super(tupleType);
        this.init(vis, group, schema);
    }

    protected void init(Visualization vis, String group, Schema schema) {
        this.setVisualization(vis);
        this.setGroup(group);
        this.addColumns(schema);
        if (this.canGetBoolean(VisualItem.VISIBLE)) {
            this.index(VisualItem.VISIBLE);
        }
        if (this.canGetBoolean(VisualItem.STARTVISIBLE)) {
            this.index(VisualItem.STARTVISIBLE);
        }
        if (this.canGetBoolean(VisualItem.VALIDATED)) {
            this.index(VisualItem.VALIDATED);
        }
    }

    @Override
    protected void fireTableEvent(int row0, int row1, int col, int type) {
        if (type == 0) {
            if (col != VisualItem.IDX_VALIDATED) {
                for (int r = row0; r <= row1; ++r) {
                    this.setValidated(r, false);
                }
            } else {
                for (int r = row0; r <= row1; ++r) {
                    if (this.isValidated(r)) continue;
                    this.m_vis.damageReport(this.getItem(r), this.getBounds(r));
                }
            }
        } else if (type == -1 && col == -1) {
            for (int r = row0; r <= row1; ++r) {
                if (!this.isVisible(r) || !this.isValidated(r)) continue;
                VisualItem item = (VisualItem)this.getTuple(r);
                this.m_vis.damageReport(item, this.getBounds(r));
            }
        }
        super.fireTableEvent(row0, row1, col, type);
    }

    @Override
    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void setVisualization(Visualization vis) {
        this.m_vis = vis;
    }

    @Override
    public String getGroup() {
        return this.m_group;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public VisualItem getItem(int row) {
        return (VisualItem)this.getTuple(row);
    }

    public VisualItem addItem() {
        return this.getItem(this.addRow());
    }

    public boolean isValidated(int row) {
        return this.getBoolean(row, VisualItem.VALIDATED);
    }

    public void setValidated(int row, boolean value) {
        this.setBoolean(row, VisualItem.VALIDATED, value);
    }

    public boolean isVisible(int row) {
        return this.getBoolean(row, VisualItem.VISIBLE);
    }

    public void setVisible(int row, boolean value) {
        this.setBoolean(row, VisualItem.VISIBLE, value);
    }

    public boolean isStartVisible(int row) {
        return this.getBoolean(row, VisualItem.STARTVISIBLE);
    }

    public void setStartVisible(int row, boolean value) {
        this.setBoolean(row, VisualItem.STARTVISIBLE, value);
    }

    public boolean isEndVisible(int row) {
        return this.getBoolean(row, VisualItem.ENDVISIBLE);
    }

    public void setEndVisible(int row, boolean value) {
        this.setBoolean(row, VisualItem.ENDVISIBLE, value);
    }

    public boolean isInteractive(int row) {
        return this.getBoolean(row, VisualItem.INTERACTIVE);
    }

    public void setInteractive(int row, boolean value) {
        this.setBoolean(row, VisualItem.INTERACTIVE, value);
    }

    public boolean isExpanded(int row) {
        return this.getBoolean(row, VisualItem.EXPANDED);
    }

    public void setExpanded(int row, boolean value) {
        this.setBoolean(row, VisualItem.EXPANDED, value);
    }

    public boolean isFixed(int row) {
        return this.getBoolean(row, VisualItem.FIXED);
    }

    public void setFixed(int row, boolean value) {
        this.setBoolean(row, VisualItem.FIXED, value);
    }

    public boolean isHighlighted(int row) {
        return this.getBoolean(row, VisualItem.HIGHLIGHT);
    }

    public void setHighlighted(int row, boolean value) {
        this.setBoolean(row, VisualItem.HIGHLIGHT, value);
    }

    public boolean isHover(int row) {
        return this.getBoolean(row, VisualItem.HOVER);
    }

    public void setHover(int row, boolean value) {
        this.setBoolean(row, VisualItem.HOVER, value);
    }

    public double getX(int row) {
        return this.getDouble(row, VisualItem.X);
    }

    public void setX(int row, double x) {
        this.setDouble(row, VisualItem.X, x);
    }

    public double getY(int row) {
        return this.getDouble(row, VisualItem.Y);
    }

    public void setY(int row, double y) {
        this.setDouble(row, VisualItem.Y, y);
    }

    public double getStartX(int row) {
        return this.getDouble(row, VisualItem.STARTX);
    }

    public void setStartX(int row, double x) {
        this.setDouble(row, VisualItem.STARTX, x);
    }

    public double getStartY(int row) {
        return this.getDouble(row, VisualItem.STARTY);
    }

    public void setStartY(int row, double y) {
        this.setDouble(row, VisualItem.STARTY, y);
    }

    public double getEndX(int row) {
        return this.getDouble(row, VisualItem.ENDX);
    }

    public void setEndX(int row, double x) {
        this.setDouble(row, VisualItem.ENDX, x);
    }

    public double getEndY(int row) {
        return this.getDouble(row, VisualItem.ENDY);
    }

    public void setEndY(int row, double y) {
        this.setDouble(row, VisualItem.ENDY, y);
    }

    public Rectangle2D getBounds(int row) {
        return (Rectangle2D)this.get(row, VisualItem.BOUNDS);
    }

    public void setBounds(int row, double x, double y, double w, double h) {
        this.getBounds(row).setRect(x, y, w, h);
        this.fireTableEvent(row, row, this.getColumnNumber(VisualItem.BOUNDS), 0);
    }

    public int getStrokeColor(int row) {
        return this.getInt(row, VisualItem.STROKECOLOR);
    }

    public void setStrokeColor(int row, int color) {
        this.setInt(row, VisualItem.STROKECOLOR, color);
    }

    public int getStartStrokeColor(int row) {
        return this.getInt(row, VisualItem.STARTSTROKECOLOR);
    }

    public void setStartStrokeColor(int row, int color) {
        this.setInt(row, VisualItem.STARTSTROKECOLOR, color);
    }

    public int getEndStrokeColor(int row) {
        return this.getInt(row, VisualItem.ENDSTROKECOLOR);
    }

    public void setEndStrokeColor(int row, int color) {
        this.setInt(row, VisualItem.ENDSTROKECOLOR, color);
    }

    public int getFillColor(int row) {
        return this.getInt(row, VisualItem.FILLCOLOR);
    }

    public void setFillColor(int row, int color) {
        this.setInt(row, VisualItem.FILLCOLOR, color);
    }

    public int getStartFillColor(int row) {
        return this.getInt(row, VisualItem.STARTFILLCOLOR);
    }

    public void setStartFillColor(int row, int color) {
        this.setInt(row, VisualItem.STARTFILLCOLOR, color);
    }

    public int getEndFillColor(int row) {
        return this.getInt(row, VisualItem.ENDFILLCOLOR);
    }

    public void setEndFillColor(int row, int color) {
        this.setInt(row, VisualItem.ENDFILLCOLOR, color);
    }

    public int getTextColor(int row) {
        return this.getInt(row, VisualItem.TEXTCOLOR);
    }

    public void setTextColor(int row, int color) {
        this.setInt(row, VisualItem.TEXTCOLOR, color);
    }

    public int getStartTextColor(int row) {
        return this.getInt(row, VisualItem.STARTTEXTCOLOR);
    }

    public void setStartTextColor(int row, int color) {
        this.setInt(row, VisualItem.STARTTEXTCOLOR, color);
    }

    public int getEndTextColor(int row) {
        return this.getInt(row, VisualItem.ENDTEXTCOLOR);
    }

    public void setEndTextColor(int row, int color) {
        this.setInt(row, VisualItem.ENDTEXTCOLOR, color);
    }

    public double getSize(int row) {
        return this.getDouble(row, VisualItem.SIZE);
    }

    public void setSize(int row, double size) {
        this.setDouble(row, VisualItem.SIZE, size);
    }

    public double getStartSize(int row) {
        return this.getDouble(row, VisualItem.STARTSIZE);
    }

    public void setStartSize(int row, double size) {
        this.setDouble(row, VisualItem.STARTSIZE, size);
    }

    public double getEndSize(int row) {
        return this.getDouble(row, VisualItem.ENDSIZE);
    }

    public void setEndSize(int row, double size) {
        this.setDouble(row, VisualItem.ENDSIZE, size);
    }

    public int getShape(int row) {
        return this.getInt(row, VisualItem.SHAPE);
    }

    public void setShape(int row, int shape) {
        this.setInt(row, VisualItem.SHAPE, shape);
    }

    public BasicStroke getStroke(int row) {
        return (BasicStroke)this.get(row, VisualItem.STROKE);
    }

    public void setStroke(int row, BasicStroke stroke) {
        this.set(row, VisualItem.STROKE, (Object)stroke);
    }

    public Font getFont(int row) {
        return (Font)this.get(row, VisualItem.FONT);
    }

    public void setFont(int row, Font font) {
        this.set(row, VisualItem.FONT, (Object)font);
    }

    public Font getStartFont(int row) {
        return (Font)this.get(row, VisualItem.STARTFONT);
    }

    public void setStartFont(int row, Font font) {
        this.set(row, VisualItem.STARTFONT, (Object)font);
    }

    public Font getEndFont(int row) {
        return (Font)this.get(row, VisualItem.ENDFONT);
    }

    public void setEndFont(int row, Font font) {
        this.set(row, VisualItem.ENDFONT, (Object)font);
    }

    public double getDOI(int row) {
        return this.getDouble(row, VisualItem.DOI);
    }

    public void setDOI(int row, double doi) {
        this.setDouble(row, VisualItem.DOI, doi);
    }
}

