/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Arrays;
import java.util.Comparator;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.TupleComparator;
import prefuse.util.collections.CompositeComparator;
import prefuse.util.collections.NullComparator;

public class Sort {
    private static final String ASC = " ASC";
    private static final String DESC = " DESC";
    private static final String asc = " ASC".toLowerCase();
    private static final String desc = " DESC".toLowerCase();
    private String[] m_fields;
    private boolean[] m_ascend;

    public Sort() {
        this(new String[0], new boolean[0]);
    }

    public Sort(String[] fields) {
        this(fields, new boolean[fields.length]);
        Arrays.fill(this.m_ascend, true);
    }

    public Sort(String[] fields, boolean[] ascend) {
        this.m_fields = fields;
        this.m_ascend = ascend;
    }

    public void add(String field, boolean ascend) {
        String[] f = new String[this.m_fields.length + 1];
        System.arraycopy(this.m_fields, 0, f, 0, this.m_fields.length);
        f[this.m_fields.length] = field;
        this.m_fields = f;
        boolean[] b = new boolean[this.m_fields.length + 1];
        System.arraycopy(this.m_ascend, 0, b, 0, this.m_ascend.length);
        b[this.m_ascend.length] = ascend;
        this.m_ascend = b;
    }

    public int size() {
        return this.m_fields.length;
    }

    public String getField(int i) {
        return this.m_fields[i];
    }

    public boolean isAscending(int i) {
        return this.m_ascend[i];
    }

    public Comparator getComparator(TupleSet ts) {
        Schema s = null;
        if (ts instanceof Table) {
            s = ((Table)ts).getSchema();
        } else {
            if (ts.getTupleCount() == 0) {
                return new NullComparator();
            }
            s = ((Tuple)ts.tuples().next()).getSchema();
        }
        CompositeComparator cc = new CompositeComparator(this.m_fields.length);
        for (int i = 0; i < this.m_fields.length; ++i) {
            cc.add(new TupleComparator(this.m_fields[i], s.getColumnType(this.m_fields[i]), this.m_ascend[i]));
        }
        return cc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void subparse(String s, Object[] res) {
        s = s.trim();
        res[1] = Boolean.TRUE;
        if (s.endsWith(DESC) || s.endsWith(desc)) {
            res[1] = Boolean.FALSE;
            s = s.substring(0, s.length() - DESC.length()).trim();
        } else if (s.endsWith(ASC) || s.endsWith(asc)) {
            s = s.substring(0, s.length() - ASC.length()).trim();
        }
        if (s.startsWith("[")) {
            if (s.lastIndexOf("[") != 0 || !s.endsWith("]") || s.indexOf("]") != s.length()) throw new RuntimeException();
            res[0] = s.substring(1, s.length() - 1);
            return;
        } else {
            if (s.indexOf(" ") >= 0 || s.indexOf("\t") >= 0) throw new RuntimeException();
            res[0] = s;
        }
    }

    public static Sort parse(String s) {
        Sort sort = new Sort();
        Object[] res = new Object[2];
        int idx = 0;
        int len = s.length();
        int comma = s.indexOf(44);
        int quote = s.indexOf(91);
        while (idx < len) {
            if (comma < 0) {
                Sort.subparse(s.substring(idx), res);
                sort.add((String)res[0], (Boolean)res[1]);
                break;
            }
            if (quote < 0 || comma < quote) {
                Sort.subparse(s.substring(idx, comma), res);
                sort.add((String)res[0], (Boolean)res[1]);
                idx = comma + 1;
                comma = s.indexOf(idx, 44);
                continue;
            }
            int q2 = s.indexOf(quote, 93);
            if (q2 < 0) {
                throw new RuntimeException();
            }
            comma = s.indexOf(q2, 44);
            Sort.subparse(s.substring(idx, comma), res);
            sort.add((String)res[0], (Boolean)res[1]);
            idx = comma + 1;
            comma = s.indexOf(idx, 44);
        }
        return sort;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append('[').append(this.m_fields[i]).append(']');
            sbuf.append(this.m_ascend[i] ? ASC : DESC);
        }
        return sbuf.toString();
    }
}

