/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.expression.AndPredicate;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.ComparisonPredicate;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionAnalyzer;
import prefuse.data.expression.NotPredicate;
import prefuse.data.expression.OrPredicate;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.RangePredicate;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.FilterIterator;
import prefuse.data.util.FilterRowIterator;
import prefuse.data.util.Index;
import prefuse.data.util.UniqueRowIterator;
import prefuse.util.PrefuseConfig;
import prefuse.util.collections.CompositeIntIterator;
import prefuse.util.collections.IntIterator;

public class FilterIteratorFactory {
    private static final int OPTIMIZATION_THRESHOLD = PrefuseConfig.getInt("data.filter.optimizeThreshold");

    public static Iterator tuples(TupleSet ts, Predicate p) {
        Table t;
        IntIterator ii;
        if (p == null) {
            return ts.tuples();
        }
        Iterator iter = null;
        if (ts instanceof Table && (ii = FilterIteratorFactory.getOptimizedIterator(t = (Table)ts, p)) != null) {
            iter = t.tuples(ii);
        }
        if (iter == null) {
            iter = new FilterIterator(ts.tuples(), p);
        }
        return iter;
    }

    public static IntIterator rows(Table t, Predicate p) {
        IntIterator iter = null;
        iter = FilterIteratorFactory.getOptimizedIterator(t, p);
        if (iter == null) {
            iter = new FilterRowIterator(t.rows(), t, p);
        }
        return iter;
    }

    protected static IntIterator getOptimizedIterator(Table t, Predicate p) {
        if (t.getRowCount() < OPTIMIZATION_THRESHOLD) {
            return null;
        }
        if (p instanceof ColumnExpression) {
            return FilterIteratorFactory.getColumnIterator(t, ((ColumnExpression)p).getColumnName(), true);
        }
        if (p instanceof NotPredicate) {
            Predicate pp = ((NotPredicate)p).getPredicate();
            if (pp instanceof ColumnExpression) {
                return FilterIteratorFactory.getColumnIterator(t, ((ColumnExpression)pp).getColumnName(), false);
            }
        } else {
            if (p instanceof AndPredicate) {
                return FilterIteratorFactory.getAndIterator(t, (AndPredicate)p);
            }
            if (p instanceof OrPredicate) {
                return FilterIteratorFactory.getOrIterator(t, (OrPredicate)p);
            }
            if (p instanceof ComparisonPredicate) {
                return FilterIteratorFactory.getComparisonIterator(t, (ComparisonPredicate)p);
            }
            if (p instanceof RangePredicate) {
                return FilterIteratorFactory.getRangeIterator(t, (RangePredicate)p);
            }
        }
        return null;
    }

    protected static IntIterator getColumnIterator(Table t, String field, boolean val) {
        if (t.getColumnType(field) != Boolean.TYPE) {
            return null;
        }
        Index index = t.getIndex(field);
        if (index == null) {
            return null;
        }
        return index.rows(val);
    }

    protected static IntIterator getOrIterator(Table t, OrPredicate op) {
        int size = op.size();
        if (size > 1) {
            IntIterator[] rows = new IntIterator[size];
            for (int i = 0; i < rows.length; ++i) {
                rows[i] = FilterIteratorFactory.getOptimizedIterator(t, op.get(i));
                if (rows[i] != null) continue;
                return null;
            }
            return new UniqueRowIterator(new CompositeIntIterator(rows));
        }
        if (size == 1) {
            return FilterIteratorFactory.getOptimizedIterator(t, op.get(0));
        }
        return null;
    }

    protected static IntIterator getAndIterator(Table t, AndPredicate ap) {
        IntIterator rows = null;
        Predicate clause = null;
        int i = ap.size();
        while (--i >= 0 && (rows = FilterIteratorFactory.getOptimizedIterator(t, clause = ap.get(i))) == null) {
        }
        if (rows == null) {
            return null;
        }
        if (ap.size() == 1) {
            return rows;
        }
        return new FilterRowIterator(rows, t, ap.getSubPredicate(clause));
    }

    protected static IntIterator getComparisonIterator(Table t, ComparisonPredicate cp) {
        Expression lit;
        ColumnExpression col;
        Expression l = cp.getLeftExpression();
        Expression r = cp.getRightExpression();
        int operation = cp.getOperation();
        if (operation == 3) {
            return null;
        }
        if (l instanceof ColumnExpression && !ExpressionAnalyzer.hasDependency(r)) {
            col = (ColumnExpression)l;
            lit = r;
        } else if (r instanceof ColumnExpression && !ExpressionAnalyzer.hasDependency(l)) {
            col = (ColumnExpression)r;
            lit = l;
        } else {
            return null;
        }
        Comparator cmp = cp.getComparator();
        Index index = t.getIndex(col.getColumnName());
        if (index == null || !cmp.equals(index.getComparator())) {
            return null;
        }
        Class<?> ltype = lit.getClass();
        if (ltype == Integer.TYPE) {
            int val = lit.getInt(null);
            switch (operation) {
                case 0: {
                    return index.rows(Integer.MIN_VALUE, val, 41);
                }
                case 1: {
                    return index.rows(val, Integer.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(val, val, 42);
                }
                case 4: {
                    return index.rows(Integer.MIN_VALUE, val, 42);
                }
                case 5: {
                    return index.rows(val, Integer.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (ltype == Long.TYPE) {
            long val = lit.getLong(null);
            switch (operation) {
                case 0: {
                    return index.rows(Long.MIN_VALUE, val, 41);
                }
                case 1: {
                    return index.rows(val, Long.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(val, val, 42);
                }
                case 4: {
                    return index.rows(Long.MIN_VALUE, val, 42);
                }
                case 5: {
                    return index.rows(val, Long.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (ltype == Float.TYPE) {
            float val = lit.getFloat(null);
            switch (operation) {
                case 0: {
                    return index.rows(Float.MIN_VALUE, val, 41);
                }
                case 1: {
                    return index.rows(val, Float.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(val, val, 42);
                }
                case 4: {
                    return index.rows(Float.MIN_VALUE, val, 42);
                }
                case 5: {
                    return index.rows(val, Float.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        if (ltype == Double.TYPE) {
            double val = lit.getDouble(null);
            switch (operation) {
                case 0: {
                    return index.rows((double)Double.MIN_VALUE, val, 41);
                }
                case 1: {
                    return index.rows(val, (double)Double.MAX_VALUE, 38);
                }
                case 2: {
                    return index.rows(val, val, 42);
                }
                case 4: {
                    return index.rows((double)Double.MIN_VALUE, val, 42);
                }
                case 5: {
                    return index.rows(val, (double)Double.MAX_VALUE, 42);
                }
            }
            throw new IllegalStateException();
        }
        Object val = lit.get(null);
        switch (operation) {
            case 0: {
                return index.rows(null, val, 41);
            }
            case 1: {
                return index.rows(val, null, 38);
            }
            case 2: {
                return index.rows(val, val, 42);
            }
            case 4: {
                return index.rows(null, val, 42);
            }
            case 5: {
                return index.rows(val, null, 42);
            }
        }
        throw new IllegalStateException();
    }

    protected static IntIterator getRangeIterator(Table t, RangePredicate rp) {
        int indexType;
        if (!(rp.getMiddleExpression() instanceof ColumnExpression) || ExpressionAnalyzer.hasDependency(rp.getLeftExpression()) || ExpressionAnalyzer.hasDependency(rp.getRightExpression())) {
            return null;
        }
        ColumnExpression col = (ColumnExpression)rp.getMiddleExpression();
        Expression l = rp.getLeftExpression();
        Expression r = rp.getRightExpression();
        Comparator cmp = rp.getComparator();
        Index index = t.getIndex(col.getColumnName());
        if (index == null || !cmp.equals(index.getComparator())) {
            return null;
        }
        int operation = rp.getOperation();
        Class ltype = t.getColumnType(col.getColumnName());
        switch (operation) {
            case 0: {
                indexType = 42;
                break;
            }
            case 1: {
                indexType = 41;
                break;
            }
            case 2: {
                indexType = 38;
                break;
            }
            case 3: {
                indexType = 37;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (ltype == Integer.TYPE) {
            return index.rows(l.getInt(null), r.getInt(null), indexType);
        }
        if (ltype == Long.TYPE) {
            return index.rows(l.getLong(null), r.getLong(null), indexType);
        }
        if (ltype == Float.TYPE) {
            return index.rows(l.getFloat(null), r.getFloat(null), indexType);
        }
        if (ltype == Double.TYPE) {
            return index.rows(l.getDouble(null), r.getDouble(null), indexType);
        }
        return index.rows(l.get(null), r.get(null), indexType);
    }
}

