/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.collections.CompositeIterator;

public class CompositeTupleSet
extends AbstractTupleSet {
    private static final Logger s_logger = Logger.getLogger(CompositeTupleSet.class.getName());
    private Map m_map = new LinkedHashMap();
    private Set m_sets = new HashSet();
    private int m_count = 0;
    private Listener m_lstnr;

    public CompositeTupleSet() {
        this(true);
    }

    protected CompositeTupleSet(boolean listen) {
        this.m_lstnr = listen ? new Listener() : null;
    }

    public void addSet(String name, TupleSet set) {
        if (this.hasSet(name)) {
            throw new IllegalArgumentException("Name already in use: " + name);
        }
        this.m_map.put(name, set);
        this.m_sets.add(set);
        this.m_count += set.getTupleCount();
        if (this.m_lstnr != null) {
            set.addTupleSetListener(this.m_lstnr);
        }
    }

    public boolean hasSet(String name) {
        return this.m_map.containsKey(name);
    }

    public boolean containsSet(TupleSet set) {
        return this.m_sets.contains(set);
    }

    public TupleSet getSet(String name) {
        return (TupleSet)this.m_map.get(name);
    }

    public Iterator setNames() {
        return this.m_map.keySet().iterator();
    }

    public Iterator sets() {
        return this.m_map.values().iterator();
    }

    public TupleSet removeSet(String name) {
        TupleSet ts = (TupleSet)this.m_map.remove(name);
        if (ts != null) {
            this.m_sets.remove(ts);
            if (this.m_lstnr != null) {
                ts.removeTupleSetListener(this.m_lstnr);
            }
        }
        return ts;
    }

    public void removeAllSets() {
        Iterator sets = this.m_map.entrySet().iterator();
        while (sets.hasNext()) {
            Map.Entry entry = sets.next();
            TupleSet ts = (TupleSet)entry.getValue();
            sets.remove();
            this.m_sets.remove(ts);
            if (this.m_lstnr == null) continue;
            ts.removeTupleSetListener(this.m_lstnr);
        }
        this.m_count = 0;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : this.m_map.entrySet()) {
            ((TupleSet)entry.getValue()).clear();
        }
        this.m_count = 0;
    }

    @Override
    public Tuple addTuple(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Tuple setTuple(Tuple t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeTuple(Tuple t) {
        Table table = t.getTable();
        if (this.m_sets.contains(table)) {
            return table.removeTuple(t);
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple t) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet ts = (TupleSet)entry.getValue();
            if (!ts.containsTuple(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTupleCount() {
        if (this.m_lstnr != null) {
            return this.m_count;
        }
        int count = 0;
        Iterator it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            TupleSet ts = (TupleSet)entry.getValue();
            count += ts.getTupleCount();
            ++i;
        }
        return count;
    }

    @Override
    public Iterator tuples() {
        CompositeIterator ci = new CompositeIterator(this.m_map.size());
        Iterator it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            TupleSet ts = (TupleSet)entry.getValue();
            ci.setIterator(i, ts.tuples());
            ++i;
        }
        return ci;
    }

    @Override
    public Iterator tuples(Predicate filter) {
        CompositeIterator ci = new CompositeIterator(this.m_map.size());
        Iterator it = this.m_map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            TupleSet ts = (TupleSet)entry.getValue();
            ci.setIterator(i, ts.tuples(filter));
            ++i;
        }
        return ci;
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    @Override
    public void addColumn(String name, Class type, Object defaultValue) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet ts = (TupleSet)entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, type, defaultValue);
                }
                catch (IllegalArgumentException iae) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, Class type) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet ts = (TupleSet)entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, type);
                }
                catch (IllegalArgumentException iae) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, Expression expr) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet ts = (TupleSet)entry.getValue();
            if (ts.isAddColumnSupported()) {
                try {
                    ts.addColumn(name, expr);
                }
                catch (IllegalArgumentException iae) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    @Override
    public void addColumn(String name, String expr) {
        Expression ex = ExpressionParser.parse(expr);
        Throwable t = ExpressionParser.getError();
        if (t != null) {
            throw new RuntimeException(t);
        }
        this.addColumn(name, ex);
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        @Override
        public void tupleSetChanged(TupleSet tset, Tuple[] add, Tuple[] rem) {
            CompositeTupleSet.this.m_count += add.length - rem.length;
            CompositeTupleSet.this.fireTupleEvent(add, rem);
        }
    }
}

