/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.util.collections.IntIterator;

public class DelimitedTextTableWriter
extends AbstractTableWriter {
    private String m_delim;
    private boolean m_printHeader;

    public DelimitedTextTableWriter() {
        this("\t");
    }

    public DelimitedTextTableWriter(String delimiter) {
        this(delimiter, true);
    }

    public DelimitedTextTableWriter(String delimiter, boolean printHeader) {
        this.m_delim = delimiter;
        this.m_printHeader = printHeader;
    }

    public String getDelimiter() {
        return this.m_delim;
    }

    public void setDelimeter(String delimiter) {
        this.m_delim = delimiter;
    }

    public boolean isPrintHeader() {
        return this.m_printHeader;
    }

    public void setPrintHeader(boolean printHeader) {
        this.m_printHeader = printHeader;
    }

    @Override
    public void writeTable(Table table, OutputStream os) throws DataIOException {
        try {
            PrintStream out = new PrintStream(new BufferedOutputStream(os));
            if (this.m_printHeader) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        out.print(this.m_delim);
                    }
                    out.print(table.getColumnName(i));
                }
                out.println();
            }
            IntIterator rows = table.rows();
            while (rows.hasNext()) {
                int row = rows.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        out.print(this.m_delim);
                    }
                    out.print(table.getString(row, table.getColumnName(i)));
                }
                out.println();
            }
            out.flush();
        }
        catch (Exception e) {
            throw new DataIOException(e);
        }
    }
}

