/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.BitSet;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class BooleanColumn
extends AbstractColumn {
    private BitSet m_bits;
    private int m_size;

    public BooleanColumn() {
        this(0, 10, false);
    }

    public BooleanColumn(int nrows) {
        this(nrows, nrows, false);
    }

    public BooleanColumn(int nrows, int capacity, boolean defaultValue) {
        super(Boolean.TYPE, new Boolean(defaultValue));
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_bits = new BitSet(capacity);
        this.m_bits.set(0, capacity, defaultValue);
        this.m_size = nrows;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int nrows) {
        if (nrows > this.m_size) {
            this.m_bits.set(this.m_size, nrows, (Boolean)this.m_defaultValue);
        }
        this.m_size = nrows;
    }

    @Override
    public Object get(int row) {
        return new Boolean(this.getBoolean(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Boolean) {
            this.setBoolean((Boolean)val, row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    @Override
    public boolean getBoolean(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_bits.get(row);
    }

    @Override
    public void setBoolean(boolean val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        boolean prev = this.m_bits.get(row);
        if (prev == val) {
            return;
        }
        this.m_bits.set(row, val);
        this.fireColumnEvent(row, prev);
    }
}

