/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnFactory;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleManager;
import prefuse.data.util.FilterIteratorFactory;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.data.util.Sort;
import prefuse.data.util.TableIterator;
import prefuse.data.util.TreeIndex;
import prefuse.util.TypeLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIterator;

public class Table
extends AbstractTupleSet
implements ColumnListener {
    protected CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected ArrayList m_columns;
    protected ArrayList m_names;
    protected HashMap m_entries;
    protected RowManager m_rows;
    protected TupleManager m_tuples;
    protected int m_modCount = 0;
    protected int m_lastCol = -1;
    protected Schema m_schema;

    public Table() {
        this(0, 0);
    }

    public Table(int nrows, int ncols) {
        this(nrows, ncols, TableTuple.class);
    }

    protected Table(int nrows, int ncols, Class tupleType) {
        this.m_columns = new ArrayList(ncols);
        this.m_names = new ArrayList(ncols);
        this.m_rows = new RowManager(this);
        this.m_entries = new HashMap(ncols + 5);
        this.m_tuples = new TupleManager(this, null, tupleType);
        if (nrows > 0) {
            this.addRows(nrows);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public Class getColumnType(int col) {
        return this.getColumn(col).getColumnType();
    }

    public Class getColumnType(String field) {
        Column c = this.getColumn(field);
        return c == null ? null : c.getColumnType();
    }

    public int getRowCount() {
        return this.m_rows.getRowCount();
    }

    public int getMinimumRow() {
        return this.m_rows.getMinimumRow();
    }

    public int getMaximumRow() {
        return this.m_rows.getMaximumRow();
    }

    public boolean isCellEditable(int row, int col) {
        if (!this.m_rows.isValidRow(row)) {
            return false;
        }
        return this.getColumn(col).isCellEditable(row);
    }

    public int getModificationCount() {
        return this.m_modCount;
    }

    public void setTupleManager(TupleManager tm) {
        this.m_tuples.invalidateAll();
        this.m_tuples = tm;
    }

    public Schema getSchema() {
        if (this.m_schema == null) {
            Schema s = new Schema();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                s.addColumn(this.getColumnName(i), this.getColumnType(i), this.getColumn(i).getDefaultValue());
            }
            s.lockSchema();
            this.m_schema = s;
        }
        return this.m_schema;
    }

    protected void invalidateSchema() {
        this.m_schema = null;
    }

    public int getColumnRow(int row, int col) {
        return this.m_rows.getColumnRow(row, col);
    }

    public int getTableRow(int colrow, int col) {
        return this.m_rows.getTableRow(colrow, col);
    }

    public int addRow() {
        int r = this.m_rows.addRow();
        this.updateRowCount();
        this.fireTableEvent(r, r, -1, 1);
        return r;
    }

    public void addRows(int nrows) {
        for (int i = 0; i < nrows; ++i) {
            this.addRow();
        }
    }

    protected void updateRowCount() {
        int maxrow = this.m_rows.getMaximumRow() + 1;
        Iterator cols = this.getColumns();
        while (cols.hasNext()) {
            Column c = (Column)cols.next();
            c.setMaximumRow(maxrow);
        }
    }

    public boolean removeRow(int row) {
        if (this.m_rows.isValidRow(row)) {
            this.fireTableEvent(row, row, -1, -1);
            this.m_tuples.invalidate(row);
            this.m_rows.releaseRow(row);
            Iterator cols = this.getColumns();
            while (cols.hasNext()) {
                Column c = (Column)cols.next();
                c.revertToDefault(row);
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        IntIterator rows = this.rows(true);
        while (rows.hasNext()) {
            this.removeRow(rows.nextInt());
        }
    }

    public boolean isValidRow(int row) {
        return this.m_rows.isValidRow(row);
    }

    protected boolean hasColumn(String name) {
        return this.getColumnNumber(name) != -1;
    }

    public String getColumnName(int col) {
        return (String)this.m_names.get(col);
    }

    public int getColumnNumber(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        return e == null ? -1 : e.colnum;
    }

    public int getColumnNumber(Column col) {
        return this.m_columns.indexOf(col);
    }

    public Column getColumn(int col) {
        this.m_lastCol = col;
        return (Column)this.m_columns.get(col);
    }

    public Column getColumn(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        return e != null ? e.column : null;
    }

    @Override
    public void addColumn(String name, Class type) {
        this.addColumn(name, type, null);
    }

    @Override
    public void addColumn(String name, Class type, Object defaultValue) {
        Column col = ColumnFactory.getColumn(type, this.m_rows.getMaximumRow() + 1, defaultValue);
        this.addColumn(name, col);
    }

    @Override
    public void addColumn(String name, String expr) {
        Expression ex = ExpressionParser.parse(expr);
        Throwable t = ExpressionParser.getError();
        if (t != null) {
            throw new RuntimeException(t);
        }
        this.addColumn(name, ex);
    }

    @Override
    public void addColumn(String name, Expression expr) {
        this.addColumn(name, ColumnFactory.getColumn(this, expr));
    }

    public void addConstantColumn(String name, Class type, Object dflt) {
        this.addColumn(name, ColumnFactory.getConstantColumn(type, dflt));
    }

    protected void addColumn(String name, Column col) {
        int idx = this.getColumnNumber(name);
        if (idx >= 0 && idx < this.m_columns.size()) {
            throw new IllegalArgumentException("Table already has column with name \"" + name + "\"");
        }
        this.m_columns.add(col);
        this.m_names.add(name);
        this.m_lastCol = this.m_columns.size() - 1;
        ColumnEntry entry = new ColumnEntry(this.m_lastCol, col, new ColumnMetadata(this, name));
        ColumnEntry oldEntry = this.m_entries.put(name, entry);
        if (oldEntry != null) {
            oldEntry.dispose();
        }
        this.invalidateSchema();
        col.addColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), this.m_lastCol, 1);
    }

    protected Column removeColumn(int idx) {
        if (idx < 0 || idx >= this.m_columns.size()) {
            throw new IllegalArgumentException("Column index is not legal.");
        }
        String name = (String)this.m_names.get(idx);
        ((ColumnEntry)this.m_entries.get(name)).dispose();
        Column col = (Column)this.m_columns.remove(idx);
        this.m_entries.remove(name);
        this.m_names.remove(idx);
        this.renumberColumns();
        this.m_lastCol = -1;
        this.invalidateSchema();
        col.removeColumnListener(this);
        this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), idx, -1);
        return col;
    }

    public Column removeColumn(String field) {
        int idx = this.m_names.indexOf(field);
        if (idx < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        return this.removeColumn(idx);
    }

    public void removeColumn(Column c) {
        int idx = this.m_columns.indexOf(c);
        if (idx < 0) {
            throw new IllegalArgumentException("No such column.");
        }
        this.removeColumn(idx);
    }

    protected void renumberColumns() {
        Iterator iter = this.m_names.iterator();
        int idx = 0;
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ColumnEntry e = (ColumnEntry)this.m_entries.get(name);
            e.colnum = idx++;
        }
    }

    protected Iterator getColumns() {
        return this.m_columns.iterator();
    }

    protected Iterator getColumnNames() {
        return this.m_names.iterator();
    }

    public ColumnMetadata getMetadata(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        if (e == null) {
            throw new IllegalArgumentException("Unknown column name: " + field);
        }
        return e.metadata;
    }

    public Index index(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        if (e == null) {
            throw new IllegalArgumentException("Unknown column name: " + field);
        }
        if (e.index != null) {
            return e.index;
        }
        Column col = e.column;
        try {
            e.index = new TreeIndex(this, this.m_rows, col, null);
        }
        catch (IncompatibleComparatorException ice) {
            // empty catch block
        }
        return e.index;
    }

    public Index getIndex(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        if (e == null) {
            throw new IllegalArgumentException("Unknown column name: " + field);
        }
        return e.index;
    }

    protected Index getIndex(String field, Class expType, boolean create) {
        if (!expType.equals(this.getColumnType(field))) {
            throw new IllegalArgumentException("Column type does not match.");
        }
        if (this.getIndex(field) == null && create) {
            this.index(field);
        }
        return this.getIndex(field);
    }

    public boolean removeIndex(String field) {
        ColumnEntry e = (ColumnEntry)this.m_entries.get(field);
        if (e == null) {
            throw new IllegalArgumentException("Unknown column name: " + field);
        }
        if (e.index == null) {
            return false;
        }
        e.index.dispose();
        e.index = null;
        return true;
    }

    public Tuple getTuple(int row) {
        return this.m_tuples.getTuple(row);
    }

    @Override
    public Tuple addTuple(Tuple t) {
        if (t.getTable() == this) {
            return null;
        }
        Schema s = t.getSchema();
        if (this.getSchema().isAssignableFrom(s)) {
            int r = this.addRow();
            for (int i = 0; i < s.getColumnCount(); ++i) {
                String field = s.getColumnName(i);
                this.set(r, field, t.get(i));
            }
            return this.getTuple(r);
        }
        return null;
    }

    @Override
    public Tuple setTuple(Tuple t) {
        this.clear();
        return this.addTuple(t);
    }

    @Override
    public boolean removeTuple(Tuple t) {
        if (this.containsTuple(t)) {
            this.removeRow(t.getRow());
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTuple(Tuple t) {
        return t.getTable() == this && this.isValidRow(t.getRow());
    }

    @Override
    public int getTupleCount() {
        return this.getRowCount();
    }

    @Override
    public boolean isAddColumnSupported() {
        return true;
    }

    public boolean canGet(String field, Class type) {
        Column c = this.getColumn(field);
        return c == null ? false : c.canGet(type);
    }

    public boolean canSet(String field, Class type) {
        Column c = this.getColumn(field);
        return c == null ? false : c.canSet(type);
    }

    public Object get(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).get(row);
    }

    public void set(int row, String field, Object val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).set(val, row);
    }

    public Object get(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).get(row);
    }

    public void set(int row, int col, Object val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).set(val, row);
    }

    public Object getDefault(String field) {
        int col = this.getColumnNumber(field);
        return this.getColumn(col).getDefaultValue();
    }

    public void revertToDefault(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).revertToDefault(row);
    }

    public final boolean canGetInt(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetInt();
    }

    public final boolean canSetInt(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetInt();
    }

    public final int getInt(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getInt(row);
    }

    public final void setInt(int row, String field, int val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setInt(val, row);
    }

    public final int getInt(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getInt(row);
    }

    public final void setInt(int row, int col, int val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setInt(val, row);
    }

    public final boolean canGetLong(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetLong();
    }

    public final boolean canSetLong(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetLong();
    }

    public final long getLong(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getLong(row);
    }

    public final void setLong(int row, String field, long val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setLong(val, row);
    }

    public final long getLong(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getLong(row);
    }

    public final void setLong(int row, int col, long val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setLong(val, row);
    }

    public final boolean canGetFloat(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetFloat();
    }

    public final boolean canSetFloat(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetFloat();
    }

    public final float getFloat(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getFloat(row);
    }

    public final void setFloat(int row, String field, float val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setFloat(val, row);
    }

    public final float getFloat(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getFloat(row);
    }

    public final void setFloat(int row, int col, float val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setFloat(val, row);
    }

    public final boolean canGetDouble(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetDouble();
    }

    public final boolean canSetDouble(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetDouble();
    }

    public final double getDouble(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getDouble(row);
    }

    public final void setDouble(int row, String field, double val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setDouble(val, row);
    }

    public final double getDouble(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getDouble(row);
    }

    public final void setDouble(int row, int col, double val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setDouble(val, row);
    }

    public final boolean canGetBoolean(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetBoolean();
    }

    public final boolean canSetBoolean(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetBoolean();
    }

    public final boolean getBoolean(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getBoolean(row);
    }

    public final void setBoolean(int row, String field, boolean val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setBoolean(val, row);
    }

    public final boolean getBoolean(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getBoolean(row);
    }

    public final void setBoolean(int row, int col, boolean val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setBoolean(val, row);
    }

    public final boolean canGetString(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetString();
    }

    public final boolean canSetString(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetString();
    }

    public final String getString(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getString(row);
    }

    public final void setString(int row, String field, String val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setString(val, row);
    }

    public final String getString(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getString(row);
    }

    public final void setString(int row, int col, String val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setString(val, row);
    }

    public final boolean canGetDate(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canGetDate();
    }

    public final boolean canSetDate(String field) {
        Column col = this.getColumn(field);
        return col == null ? false : col.canSetDate();
    }

    public final Date getDate(int row, String field) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getDate(row);
    }

    public final void setDate(int row, String field, Date val) {
        int col = this.getColumnNumber(field);
        row = this.getColumnRow(row, col);
        this.getColumn(col).setDate(val, row);
    }

    public final Date getDate(int row, int col) {
        row = this.getColumnRow(row, col);
        return this.getColumn(col).getDate(row);
    }

    public final void setDate(int row, int col, Date val) {
        row = this.getColumnRow(row, col);
        this.getColumn(col).setDate(val, row);
    }

    public Table select(Predicate filter, Sort sort) {
        Table t = this.getSchema().instantiate();
        Iterator tuples = this.tuples(filter, sort);
        while (tuples.hasNext()) {
            t.addTuple((Tuple)tuples.next());
        }
        return t;
    }

    public void remove(Predicate filter) {
        IntIterator ii = this.rows(filter);
        while (ii.hasNext()) {
            this.removeRow(ii.nextInt());
        }
    }

    public TableIterator iterator() {
        return this.iterator(this.rows());
    }

    public TableIterator iterator(IntIterator rows) {
        return new TableIterator(this, rows);
    }

    @Override
    public Iterator tuples() {
        return this.m_tuples.iterator(this.rows());
    }

    public Iterator tuplesReversed() {
        return this.m_tuples.iterator(this.rows(true));
    }

    public Iterator tuples(IntIterator rows) {
        return this.m_tuples.iterator(rows);
    }

    public IntIterator rows() {
        return this.m_rows.rows();
    }

    public IntIterator rows(Predicate filter) {
        return FilterIteratorFactory.rows(this, filter);
    }

    public IntIterator rows(boolean reverse) {
        return this.m_rows.rows(reverse);
    }

    public IntIterator rowsSortedBy(String field, boolean ascend) {
        Class type = this.getColumnType(field);
        Index index = this.getIndex(field, type, true);
        int t = ascend ? 32 : 16;
        return index.allRows(t);
    }

    public IntIterator rangeSortedBy(String field, int lo, int hi, int indexType) {
        Index index = this.getIndex(field, Integer.TYPE, true);
        return index.rows(lo, hi, indexType);
    }

    public IntIterator rangeSortedBy(String field, long lo, long hi, int indexType) {
        Index index = this.getIndex(field, Long.TYPE, true);
        return index.rows(lo, hi, indexType);
    }

    public IntIterator rangeSortedBy(String field, float lo, float hi, int indexType) {
        Index index = this.getIndex(field, Float.TYPE, true);
        return index.rows(lo, hi, indexType);
    }

    public IntIterator rangeSortedBy(String field, double lo, double hi, int indexType) {
        Index index = this.getIndex(field, Double.TYPE, true);
        return index.rows(lo, hi, indexType);
    }

    public IntIterator rangeSortedBy(String field, Object lo, Object hi, int indexType) {
        Class type = TypeLib.getSharedType(lo, hi);
        if (type == null) {
            throw new IllegalArgumentException("Incompatible arguments");
        }
        Index index = this.getIndex(field, type, true);
        return index.rows(lo, hi, indexType);
    }

    @Override
    public void columnChanged(Column src, int idx, boolean prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, double prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, float prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, int prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, long prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int idx, Object prev) {
        this.handleColumnChanged(src, idx, idx);
    }

    @Override
    public void columnChanged(Column src, int type, int start, int end) {
        this.handleColumnChanged(src, start, end);
    }

    protected void handleColumnChanged(Column c, int start, int end) {
        while (!this.isValidRow(start) && start <= end) {
            ++start;
        }
        if (start > end) {
            return;
        }
        int idx = this.m_lastCol != -1 && c == this.getColumn(this.m_lastCol) ? this.m_lastCol : this.getColumnNumber(c);
        if (idx >= 0) {
            this.fireTableEvent(start, end, idx, 0);
        }
    }

    public void addTableListener(TableListener listnr) {
        if (!this.m_listeners.contains(listnr)) {
            this.m_listeners.add(listnr);
        }
    }

    public void removeTableListener(TableListener listnr) {
        this.m_listeners.remove(listnr);
    }

    public void removeAllTableListeners() {
        this.m_listeners.clear();
    }

    protected void fireTableEvent(int row0, int row1, int col, int type) {
        ++this.m_modCount;
        if (type != 0 && col == -1) {
            this.fireTupleEvent(this, row0, row1, type);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] lstnrs = this.m_listeners.getArray();
            for (int i = 0; i < lstnrs.length; ++i) {
                ((TableListener)lstnrs[i]).tableChanged(this, row0, row1, col, type);
            }
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Table[");
        sbuf.append("rows=").append(this.getRowCount());
        sbuf.append(", cols=").append(this.getColumnCount());
        sbuf.append(", maxrow=").append(this.m_rows.getMaximumRow());
        sbuf.append("]");
        return sbuf.toString();
    }

    protected static class ColumnEntry {
        public int colnum;
        public Column column;
        public ColumnMetadata metadata;
        public Index index;

        public ColumnEntry(int col, Column column, ColumnMetadata metadata) {
            this.colnum = col;
            this.column = column;
            this.metadata = metadata;
            this.index = null;
        }

        public void dispose() {
            if (this.metadata != null) {
                this.metadata.dispose();
            }
            if (this.index != null) {
                this.index.dispose();
            }
        }
    }
}

