/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class PanControl
extends ControlAdapter {
    private boolean m_panOverItem;
    private int m_xDown;
    private int m_yDown;
    private int m_button;

    public PanControl() {
        this(16, false);
    }

    public PanControl(boolean panOverItem) {
        this(16, panOverItem);
    }

    public PanControl(int mouseButton) {
        this(mouseButton, false);
    }

    public PanControl(int mouseButton, boolean panOverItem) {
        this.m_button = mouseButton;
        this.m_panOverItem = panOverItem;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            e.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            this.m_xDown = e.getX();
            this.m_yDown = e.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            Display display = (Display)e.getComponent();
            int x = e.getX();
            int y = e.getY();
            int dx = x - this.m_xDown;
            int dy = y - this.m_yDown;
            display.pan(dx, dy);
            this.m_xDown = x;
            this.m_yDown = y;
            display.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (UILib.isButtonPressed(e, this.m_button)) {
            e.getComponent().setCursor(Cursor.getDefaultCursor());
            this.m_xDown = -1;
            this.m_yDown = -1;
        }
    }

    @Override
    public void itemPressed(VisualItem item, MouseEvent e) {
        if (this.m_panOverItem) {
            this.mousePressed(e);
        }
    }

    @Override
    public void itemDragged(VisualItem item, MouseEvent e) {
        if (this.m_panOverItem) {
            this.mouseDragged(e);
        }
    }

    @Override
    public void itemReleased(VisualItem item, MouseEvent e) {
        if (this.m_panOverItem) {
            this.mouseReleased(e);
        }
    }
}

