/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.Display;
import prefuse.action.GroupAction;
import prefuse.util.PrefuseLib;
import prefuse.visual.VisualItem;

public abstract class Layout
extends GroupAction {
    protected Rectangle2D m_bounds = null;
    protected Point2D m_anchor = null;
    protected boolean m_margin = false;
    protected Insets m_insets = new Insets(0, 0, 0, 0);
    protected double[] m_bpts = new double[4];
    protected Rectangle2D m_tmpb = new Rectangle2D.Double();
    protected Point2D m_tmpa = new Point2D.Double();

    public Layout() {
    }

    public Layout(String group) {
        super(group);
    }

    public Layout(String group, long duration) {
        super(group, duration);
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.m_insets.top = top;
        this.m_insets.left = left;
        this.m_insets.bottom = bottom;
        this.m_insets.right = right;
        this.m_margin = true;
    }

    public Rectangle2D getLayoutBounds() {
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        if (this.m_vis != null && this.m_vis.getDisplayCount() > 0) {
            Display d = this.m_vis.getDisplay(0);
            Insets i = this.m_margin ? this.m_insets : d.getInsets(this.m_insets);
            this.m_bpts[0] = i.left;
            this.m_bpts[1] = i.top;
            this.m_bpts[2] = d.getWidth() - i.right;
            this.m_bpts[3] = d.getHeight() - i.bottom;
            d.getInverseTransform().transform(this.m_bpts, 0, this.m_bpts, 0, 2);
            this.m_tmpb.setRect(this.m_bpts[0], this.m_bpts[1], this.m_bpts[2] - this.m_bpts[0], this.m_bpts[3] - this.m_bpts[1]);
            return this.m_tmpb;
        }
        return null;
    }

    public void setLayoutBounds(Rectangle2D b) {
        this.m_bounds = b;
    }

    public Point2D getLayoutAnchor() {
        if (this.m_anchor != null) {
            return this.m_anchor;
        }
        this.m_tmpa.setLocation(0.0, 0.0);
        if (this.m_vis != null) {
            Display d = this.m_vis.getDisplay(0);
            this.m_tmpa.setLocation((double)d.getWidth() / 2.0, (double)d.getHeight() / 2.0);
            d.getInverseTransform().transform(this.m_tmpa, this.m_tmpa);
        }
        return this.m_tmpa;
    }

    public void setLayoutAnchor(Point2D a) {
        this.m_anchor = a;
    }

    public void setX(VisualItem item, VisualItem referrer, double x) {
        PrefuseLib.setX(item, referrer, x);
    }

    public void setY(VisualItem item, VisualItem referrer, double y) {
        PrefuseLib.setY(item, referrer, y);
    }
}

