/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop;

import de.sciss.desktop.Desktop;
import de.sciss.desktop.Platform;
import de.sciss.desktop.impl.DummyPlatform$;
import java.awt.Desktop;
import java.awt.Image;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.GenSeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;

public final class Desktop$ {
    public static Desktop$ MODULE$;
    private Platform platform;
    private boolean isQuitSupported;
    private final String osName;
    private final boolean isLinux;
    private final boolean isMac;
    private final boolean isWindows;
    private final Object sync;
    private IndexedSeq<Function0<Object>> quitAcceptors;
    private volatile byte bitmap$0;

    static {
        new Desktop$();
    }

    private String osName() {
        return this.osName;
    }

    public boolean isLinux() {
        return this.isLinux;
    }

    public boolean isMac() {
        return this.isMac;
    }

    public boolean isWindows() {
        return this.isWindows;
    }

    private <A> A getModule(String name) {
        return (A)Class.forName(name + "$").getField("MODULE$").get(null);
    }

    private Platform platform$lzycompute() {
        Desktop$ desktop$ = this;
        synchronized (desktop$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.platform = (Platform)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.isLinux() ? (Platform)this.getModule("de.sciss.desktop.impl.LinuxPlatform") : (this.isMac() && this.hasEAWT() ? (Platform)this.getModule("de.sciss.desktop.impl.MacPlatform") : DummyPlatform$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> DummyPlatform$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.platform;
    }

    public Platform platform() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.platform$lzycompute() : this.platform;
    }

    private boolean hasEAWT() {
        boolean bl;
        try {
            Class.forName("com.apple.eawt.Application");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public void revealFile(File file) {
        this.platform().revealFile(file);
    }

    public void moveFileToTrash(File file) {
        this.platform().moveFileToTrash(file);
    }

    public void setDockBadge(Option<String> label) {
        this.platform().setDockBadge(label);
    }

    public void setDockImage(Image image) {
        this.platform().setDockImage(image);
    }

    public void requestUserAttention(boolean repeat) {
        this.platform().requestUserAttention(repeat);
    }

    public boolean requestUserAttention$default$1() {
        return false;
    }

    public void requestForeground(boolean allWindows) {
        this.platform().requestForeground(allWindows);
    }

    public boolean requestForeground$default$1() {
        return false;
    }

    private Desktop jDesktop() {
        return Desktop.getDesktop();
    }

    public void openFile(File file) {
        this.jDesktop().open(file);
    }

    public void editFile(File file) {
        this.jDesktop().edit(file);
    }

    public void printFile(File file) {
        this.jDesktop().print(file);
    }

    public void browseURI(URI uri) {
        this.jDesktop().browse(uri);
    }

    public void composeMail(Option<URI> uri) {
        Desktop desktop = this.jDesktop();
        uri.fold((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.jDesktop().mail(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            desktop.mail(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<URI> composeMail$default$1() {
        return None$.MODULE$;
    }

    public PartialFunction<Desktop.Update, BoxedUnit> addListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        return this.platform().addListener(pf);
    }

    public void removeListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        this.platform().removeListener(pf);
    }

    private Object sync() {
        return this.sync;
    }

    private IndexedSeq<Function0<Object>> quitAcceptors() {
        return this.quitAcceptors;
    }

    private void quitAcceptors_$eq(IndexedSeq<Function0<Object>> x$1) {
        this.quitAcceptors = x$1;
    }

    private boolean isQuitSupported$lzycompute() {
        Desktop$ desktop$ = this;
        synchronized (desktop$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.isQuitSupported = this.initQuit();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.isQuitSupported;
    }

    public boolean isQuitSupported() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.isQuitSupported$lzycompute() : this.isQuitSupported;
    }

    private boolean initQuit() {
        return this.platform().setQuitHandler((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.mayQuit());
    }

    public Function0<Object> addQuitAcceptor(Function0<Object> accept) {
        Function0<Object> function0;
        Object object = this.sync();
        synchronized (object) {
            this.isQuitSupported();
            Function0<Object> fun = accept;
            this.quitAcceptors_$eq((IndexedSeq<Function0<Object>>)((IndexedSeq)this.quitAcceptors().$colon$plus(fun, IndexedSeq$.MODULE$.canBuildFrom())));
            function0 = fun;
        }
        return function0;
    }

    public void removeQuitAcceptor(Function0<Object> accept) {
        Object object = this.sync();
        synchronized (object) {
            int idx = this.quitAcceptors().indexOf(accept);
            if (idx >= 0) {
                this.quitAcceptors_$eq((IndexedSeq<Function0<Object>>)((IndexedSeq)this.quitAcceptors().patch(idx, (GenSeq)Nil$.MODULE$, 1, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public boolean mayQuit() {
        boolean bl;
        Object object = this.sync();
        synchronized (object) {
            bl = this.quitAcceptors().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.apply$mcZ$sp()));
        }
        return bl;
    }

    private Desktop$() {
        MODULE$ = this;
        this.osName = (String)package$.MODULE$.props().apply((Object)"os.name");
        this.isLinux = this.osName().contains("Linux");
        this.isMac = this.osName().contains("Mac");
        this.isWindows = this.osName().contains("Windows");
        this.sync = new Object();
        this.quitAcceptors = (IndexedSeq)IndexedSeq$.MODULE$.empty();
    }
}

