/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop.impl;

import de.sciss.desktop.Desktop;
import de.sciss.desktop.Platform;
import de.sciss.file.package;
import de.sciss.file.package$;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LinuxPlatform$
implements Platform {
    public static final LinuxPlatform$ MODULE$;
    private final String[] execDirs;

    static {
        new LinuxPlatform$();
    }

    public String toString() {
        return "LinuxPlatform";
    }

    private Option<File> findExec(String fileName) {
        String[] folders = this.execDirs;
        for (int i = 0; i < folders.length; ++i) {
            String folder = folders[i];
            File f = new File(folder, fileName);
            if (!f.canExecute()) continue;
            return new Some((Object)f);
        }
        return None$.MODULE$;
    }

    public void revealFile(File file) {
        Option<File> option;
        block4: {
            block3: {
                File fileAbs;
                block2: {
                    fileAbs = package.RichFile$.MODULE$.absolute$extension(package$.MODULE$.RichFile(file));
                    option = this.findExec("nautilus");
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    File cmd = (File)some.x();
                    scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(cmd)), package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(fileAbs))}))).$bang();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.findExec("xdg-open").foreach((Function1)new Serializable(fileAbs){
                    public static final long serialVersionUID = 0L;
                    private final File fileAbs$1;

                    public final void apply(File cmd) {
                        package.RichFile$.MODULE$.parentOption$extension(package$.MODULE$.RichFile(this.fileAbs$1)).foreach((Function1)new Serializable(this, cmd){
                            public static final long serialVersionUID = 0L;
                            private final File cmd$1;

                            public final int apply(File parent) {
                                return scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(this.cmd$1)), package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(parent))}))).$bang();
                            }
                            {
                                this.cmd$1 = cmd$1;
                            }
                        });
                    }
                    {
                        this.fileAbs$1 = fileAbs$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private File xdgDataHome() {
        return (File)scala.sys.package$.MODULE$.env().get((Object)"XDG_DATA_HOME").fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply() {
                return package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(package$.MODULE$.userHome()), ".local")), "share");
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(String path) {
                return package$.MODULE$.file(path);
            }
        });
    }

    private File createUniqueFile(File parent, String base, String ext) {
        String ext1 = ext.isEmpty() || ext.charAt(0) == '.' ? ext : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ext}));
        return this.loop$1(1, parent, base, ext1);
    }

    private String escapedPath(File f) {
        String u = f.toURI().toString();
        Predef$.MODULE$.assert(u.startsWith("file:"));
        return u.substring(5);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveFileToTrash(File file) {
        File file2;
        File trash = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(this.xdgDataHome()), "Trash");
        Object object = trash.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)trash.mkdirs());
        File files = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(trash), "files");
        Object object2 = files.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)files.mkdir());
        File target0 = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(files), package.RichFile$.MODULE$.name$extension(package$.MODULE$.RichFile(file)));
        if (target0.exists()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = package.RichFile$.MODULE$.baseAndExt$extension(package$.MODULE$.RichFile(file));
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String base = (String)tuple22._1();
            String ext = (String)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)base, (Object)ext);
            String base2 = (String)tuple23._1();
            String ext2 = (String)tuple23._2();
            file2 = this.createUniqueFile(files, base2, ext2);
        } else {
            file2 = target0;
        }
        File targetFile = file2;
        File info = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(trash), "info");
        Object object3 = info.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)info.mkdir());
        File infoFile = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(info), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".trashinfo"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package.RichFile$.MODULE$.name$extension(package$.MODULE$.RichFile(targetFile))})));
        int mvRes = scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mv", package.RichFile$.MODULE$.absolutePath$extension(package$.MODULE$.RichFile(file)), package.RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(targetFile))}))).$bang();
        if (mvRes != 0) return;
        String sourceEscape = this.escapedPath(package.RichFile$.MODULE$.absolute$extension(package$.MODULE$.RichFile(file)));
        String deletionDate = new SimpleDateFormat("YYYY-MM-DD'T'hh:mm:ss", Locale.US).format(new Date());
        String infoString = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Trash Info]\n           |Path=", "\n           |DeletionDate=", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceEscape, deletionDate})))).stripMargin();
        FileOutputStream infoS = new FileOutputStream(infoFile);
        infoS.write(infoString.getBytes("UTF-8"));
        infoS.close();
    }

    public PartialFunction<Desktop.Update, BoxedUnit> addListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        return pf;
    }

    public void removeListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
    }

    public void setDockImage(Image image) {
    }

    public void setDockBadge(Option<String> label) {
    }

    public void requestUserAttention(boolean repeat) {
    }

    public void requestForeground(boolean allWindows) {
    }

    public boolean setQuitHandler(Function0<Future<BoxedUnit>> test) {
        return false;
    }

    public boolean setAboutHandler(Function0<BoxedUnit> action) {
        return false;
    }

    public boolean setPreferencesHandler(Function0<BoxedUnit> action) {
        return false;
    }

    private final File loop$1(int count, File parent$1, String base$1, String ext1$1) {
        File test;
        while (true) {
            String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base$1, BoxesRunTime.boxToInteger((int)count), ext1$1}));
            test = package.RichFile$.MODULE$.$div$extension(package$.MODULE$.RichFile(parent$1), name);
            if (!test.exists()) break;
            ++count;
        }
        return test;
    }

    private LinuxPlatform$() {
        MODULE$ = this;
        this.execDirs = (String[])((Object[])new String[]{"/usr/local/bin", "/usr/bin"});
    }
}

