/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsAbstractController;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class FileController
extends FsAbstractController<FsModel> {
    private final Path target;

    FileController(FsModel model) {
        super(model);
        if (null != model.getParent()) {
            throw new IllegalArgumentException();
        }
        this.target = Paths.get(model.getMountPoint().toUri());
    }

    private BasicFileAttributeView getBasicFileAttributeView(Path file) {
        BasicFileAttributeView view = Files.getFileAttributeView(file, BasicFileAttributeView.class, new LinkOption[0]);
        assert (null != view);
        return view;
    }

    public FsController<?> getParent() {
        return null;
    }

    public boolean isReadOnly() throws IOException {
        return false;
    }

    public FileEntry getEntry(FsEntryName name) throws IOException {
        FileEntry entry = new FileEntry(this.target, name);
        return Files.exists(entry.getPath(), new LinkOption[0]) ? entry : null;
    }

    public boolean isReadable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isReadable(file);
    }

    public boolean isWritable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isWritable(file);
    }

    public boolean isExecutable(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        return Files.isExecutable(file);
    }

    public void setReadOnly(FsEntryName name) throws IOException {
        Path file = this.target.resolve(name.getPath());
        if (!file.toFile().setReadOnly()) {
            if (Files.exists(file, new LinkOption[0])) {
                throw new AccessDeniedException(file.toString());
            }
            throw new FileNotFoundException(file.toString());
        }
    }

    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        Path file = this.target.resolve(name.getPath());
        EnumMap<Entry.Access, Long> t = new EnumMap<Entry.Access, Long>(times);
        this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime((Long)t.remove(Entry.Access.WRITE)), FileController.toFileTime((Long)t.remove(Entry.Access.READ)), FileController.toFileTime((Long)t.remove(Entry.Access.CREATE)));
        return t.isEmpty();
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        Path file = this.target.resolve(name.getPath());
        FileTime time = FileTime.fromMillis(value);
        this.getBasicFileAttributeView(file).setTimes(types.get((Enum)Entry.Access.WRITE) ? time : null, types.get((Enum)Entry.Access.READ) ? time : null, types.get((Enum)Entry.Access.CREATE) ? time : null);
        return types.clear((Enum)Entry.Access.WRITE).clear((Enum)Entry.Access.READ).clear((Enum)Entry.Access.CREATE).isEmpty();
    }

    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new FileEntry(this.target, name).getInputSocket();
    }

    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new FileEntry(this.target, name).getOutputSocket(options, template);
    }

    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        Path file = this.target.resolve(name.getPath());
        switch (type) {
            case FILE: {
                if (options.get((Enum)FsOutputOption.EXCLUSIVE)) {
                    Files.createFile(file, new FileAttribute[0]);
                    break;
                }
                Files.newOutputStream(file, new OpenOption[0]).close();
                break;
            }
            case DIRECTORY: {
                Files.createDirectory(file, new FileAttribute[0]);
                break;
            }
            default: {
                throw new IOException(file + " (entry type not supported: " + type + ")");
            }
        }
        if (null != template) {
            this.getBasicFileAttributeView(file).setTimes(FileController.toFileTime(template.getTime(Entry.Access.WRITE)), FileController.toFileTime(template.getTime(Entry.Access.READ)), FileController.toFileTime(template.getTime(Entry.Access.CREATE)));
        }
    }

    @Nullable
    private static FileTime toFileTime(Long time) {
        return null == time ? null : FileController.toFileTime((long)time);
    }

    @Nullable
    private static FileTime toFileTime(long time) {
        return -1L == time ? null : FileTime.fromMillis(time);
    }

    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        Path file = this.target.resolve(name.getPath());
        Files.delete(file);
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncException, ControlFlowException {
    }
}

