/*
 * Decompiled with CFR 0.152.
 */
package de.sayayi.lib.antlr4;

import de.sayayi.lib.antlr4.SyntaxErrorFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAntlr4Parser {
    private final SyntaxErrorFormatter syntaxErrorFormatter;

    protected AbstractAntlr4Parser() {
        this(DefaultSyntaxErrorFormatter.INSTANCE);
    }

    protected <L extends Lexer, P extends Parser, C extends ParserRuleContext, R> R parse(@NotNull L lexer, @NotNull Function<L, P> parserSupplier, @NotNull Function<P, C> ruleExecutor, @NotNull ParseTreeListener listener, @NotNull Function<C, R> contextResultExtractor) {
        C parserRuleContext = this.parse(lexer, parserSupplier, ruleExecutor);
        this.walk(listener, (ParseTree)parserRuleContext);
        return contextResultExtractor.apply(parserRuleContext);
    }

    @NotNull
    protected <L extends Lexer, P extends Parser, C extends ParserRuleContext> C parse(@NotNull L lexer, @NotNull Function<L, P> parserSupplier, @NotNull Function<P, C> ruleExecutor) {
        final String parserInput = ((ParserInputSupplier)lexer).getParserInput();
        BaseErrorListener errorListener = new BaseErrorListener(){

            public void syntaxError(@NotNull Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
                AbstractAntlr4Parser.this.syntaxError(parserInput, recognizer, (Token)offendingSymbol, line, charPositionInLine, msg, ex);
            }
        };
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        Parser parser = (Parser)parserSupplier.apply(lexer);
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return (C)((ParserRuleContext)ruleExecutor.apply(parser));
    }

    private void syntaxError(@NotNull String parserInput, @NotNull Recognizer<?, ?> recognizer, Token offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
        if (offendingSymbol == null && recognizer instanceof Lexer) {
            CharStream inputStream = ((Lexer)recognizer).getInputStream();
            offendingSymbol = new PositionToken(line, charPositionInLine, inputStream.index(), inputStream);
        }
        this.syntaxError(parserInput, this.analyseStartStopToken(offendingSymbol, ex), msg, ex);
    }

    @Contract(value="null, null -> fail", pure=true)
    @NotNull
    protected Token[] analyseStartStopToken(Token offendingSymbol, RecognitionException ex) {
        if (ex != null) {
            Token offendingToken = ex.getOffendingToken();
            if (offendingToken != null) {
                return new Token[]{offendingToken, offendingToken};
            }
            RuleContext ctx = ex.getCtx();
            if (ctx instanceof ParserRuleContext) {
                ParserRuleContext parserRuleContext = (ParserRuleContext)ctx;
                return new Token[]{parserRuleContext.getStart(), parserRuleContext.getStop()};
            }
        }
        return new Token[]{Objects.requireNonNull(offendingSymbol), offendingSymbol};
    }

    @Contract(mutates="param2")
    private void walk(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (listener instanceof WalkerSupplier) {
            switch (((WalkerSupplier)listener).getWalker()) {
                case WALK_EXIT_RULES_ONLY: {
                    this.walkExitsOnly(listener, parseTree);
                    return;
                }
                case WALK_ENTER_AND_EXIT_RULES_ONLY: {
                    this.walkEnterAndExitsOnly(listener, parseTree);
                    return;
                }
                case WALK_FULL_HEAP: {
                    new IterativeParseTreeWalker().walk(listener, parseTree);
                    return;
                }
            }
        }
        ParseTreeWalker.DEFAULT.walk(listener, parseTree);
    }

    @Contract(mutates="param2")
    private void walkEnterAndExitsOnly(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (parseTree instanceof ParserRuleContext) {
            ((ParserRuleContext)parseTree).enterRule(listener);
            List children = ((ParserRuleContext)parseTree).children;
            if (children != null) {
                for (ParseTree parseTreeChild : children) {
                    this.walkEnterAndExitsOnly(listener, parseTreeChild);
                }
            }
            ((ParserRuleContext)parseTree).exitRule(listener);
        }
    }

    @Contract(mutates="param2")
    private void walkExitsOnly(@NotNull ParseTreeListener listener, @NotNull ParseTree parseTree) {
        if (parseTree instanceof ParserRuleContext) {
            List children = ((ParserRuleContext)parseTree).children;
            if (children != null) {
                for (ParseTree parseTreeChild : children) {
                    this.walkExitsOnly(listener, parseTreeChild);
                }
            }
            ((ParserRuleContext)parseTree).exitRule(listener);
        }
    }

    @Contract(value="_, _, _ -> fail")
    protected void syntaxError(@NotNull String parserInput, @NotNull ParserRuleContext ctx, @NotNull String errorMsg) {
        this.syntaxError(parserInput, new Token[]{ctx.getStart(), ctx.getStop()}, errorMsg, null);
    }

    @Contract(value="_, _, _ -> fail")
    protected void syntaxError(@NotNull String parserInput, @NotNull Token token, @NotNull String errorMsg) {
        this.syntaxError(parserInput, new Token[]{token, token}, errorMsg, null);
    }

    @Contract(value="_, _, _, _ -> fail")
    private void syntaxError(@NotNull String parserInput, @NotNull Token[] startStopToken, @NotNull String errorMsg, RecognitionException ex) {
        Token startToken = startStopToken[0];
        Token stopToken = startStopToken[1];
        throw this.createException(parserInput, startToken, stopToken, this.syntaxErrorFormatter.format(parserInput, startToken, stopToken, errorMsg, ex), errorMsg, ex);
    }

    @NotNull
    protected abstract RuntimeException createException(@NotNull String var1, @NotNull Token var2, @NotNull Token var3, @NotNull String var4, @NotNull String var5, RecognitionException var6);

    protected AbstractAntlr4Parser(SyntaxErrorFormatter syntaxErrorFormatter) {
        this.syntaxErrorFormatter = syntaxErrorFormatter;
    }

    private static enum DefaultSyntaxErrorFormatter implements SyntaxErrorFormatter
    {
        INSTANCE;


        @Override
        @NotNull
        public String format(@NotNull String parserInput, @NotNull Token startToken, @NotNull Token stopToken, @NotNull String errorMsg, RecognitionException ex) {
            String[] lines = parserInput.split("\r?\n");
            return lines.length == 1 ? this.syntaxErrorSingleLine(errorMsg, parserInput, startToken, stopToken) : this.syntaxErrorMultiLine(errorMsg, lines, startToken, stopToken);
        }

        @Contract(pure=true)
        @NotNull
        private String syntaxErrorSingleLine(@NotNull String errorMsg, @NotNull String compilerInput, @NotNull Token startToken, @NotNull Token stopToken) {
            int startIndex = startToken.getStartIndex();
            int stopIndex = stopToken.getStopIndex();
            char[] marker = new char[stopIndex + 1];
            Arrays.fill(marker, 0, startIndex, ' ');
            Arrays.fill(marker, startIndex, stopIndex + 1, '^');
            return errorMsg + ":\n" + compilerInput + '\n' + this.trimRight(String.valueOf(marker));
        }

        @Contract(pure=true)
        @NotNull
        private String syntaxErrorMultiLine(@NotNull String errorMsg, @NotNull String[] lines, @NotNull Token startToken, @NotNull Token stopToken) {
            StringBuilder text = new StringBuilder(errorMsg).append(":\n");
            int lineStart = startToken.getLine();
            int colStart = startToken.getStartIndex();
            int lineStop = stopToken.getLine();
            int colStop = stopToken.getStopIndex();
            int lineCount = lines.length;
            String format = lineCount >= 100 ? " %03d: " : (lineCount >= 10 ? " %02d: " : " %1d: ");
            for (int n = 1; n <= lineCount; ++n) {
                String line = this.trimRight(lines[n - 1]);
                int lineLength = line.length();
                String lineNumber = String.format(format, n);
                text.append(lineNumber).append(line).append('\n');
                if (n < lineStart || n > lineStop || lineLength <= 0) continue;
                boolean nonSpace = false;
                for (int c = -lineNumber.length(); c < lineLength; ++c) {
                    if (lineStart == n && c < colStart || lineStop == n && c > colStop || c < 0) {
                        text.append(' ');
                        continue;
                    }
                    text.append((nonSpace |= !Character.isSpaceChar(line.charAt(c))) ? (char)'^' : ' ');
                }
                text.append('\n');
            }
            return this.trimRight(text.toString());
        }

        @Contract(pure=true)
        @NotNull
        private String trimRight(@NotNull String s) {
            int len;
            char[] chars = s.toCharArray();
            for (len = chars.length; len > 0 && chars[len - 1] <= ' '; --len) {
            }
            return len < chars.length ? new String(chars, 0, len) : s;
        }
    }

    private static final class PositionToken
    implements Token {
        private final int line;
        private final int startIndex;
        private final int stopIndex;
        private final CharStream inputStream;

        public String getText() {
            return null;
        }

        public int getType() {
            return 0;
        }

        public int getCharPositionInLine() {
            return this.startIndex;
        }

        public int getChannel() {
            return 0;
        }

        public int getTokenIndex() {
            return -1;
        }

        public TokenSource getTokenSource() {
            return null;
        }

        private PositionToken(int line, int startIndex, int stopIndex, CharStream inputStream) {
            this.line = line;
            this.startIndex = startIndex;
            this.stopIndex = stopIndex;
            this.inputStream = inputStream;
        }

        public int getLine() {
            return this.line;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getStopIndex() {
            return this.stopIndex;
        }

        public CharStream getInputStream() {
            return this.inputStream;
        }
    }

    public static enum Walker {
        WALK_FULL_RECURSIVE,
        WALK_FULL_HEAP,
        WALK_EXIT_RULES_ONLY,
        WALK_ENTER_AND_EXIT_RULES_ONLY;

    }

    public static interface WalkerSupplier {
        @Contract(pure=true)
        @NotNull
        public Walker getWalker();
    }

    public static interface ParserInputSupplier {
        @Contract(pure=true)
        @NotNull
        public String getParserInput();
    }
}

