/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.xml.elements;

import de.saxsys.svgfx.xml.core.IDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ElementBase<TDataProvider extends IDataProvider, TResult, TParent extends ElementBase<TDataProvider, ?, ?>> {
    private final String name;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final TParent parent;
    private final List<ElementBase> children;
    private final TDataProvider dataProvider;

    public ElementBase(String name, Attributes attributes, TParent parent, TDataProvider dataProvider) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("given value must not be null");
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException("given data provider must not be null");
        }
        this.name = name;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.attributes.put(attributes.getQName(i), attributes.getValue(i));
            }
        }
        this.parent = parent;
        this.children = new ArrayList<ElementBase>();
        this.dataProvider = dataProvider;
    }

    public String getName() {
        return this.name;
    }

    public final Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public TParent getParent() {
        return this.parent;
    }

    public List<ElementBase> getChildren() {
        return this.children;
    }

    public TDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public abstract TResult getResult() throws SAXException;

    public String getAttribute(String key) {
        return this.getAttributes().get(key);
    }

    public abstract void startProcessing() throws SAXException;

    public abstract void processCharacterData(char[] var1, int var2, int var3) throws SAXException;

    public abstract void endProcessing() throws SAXException;

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("<").append(this.name);
        this.attributes.entrySet().stream().forEach(attribute -> data.append(String.format(" %s:%s", attribute.getKey(), attribute.getValue())));
        data.append(">");
        return data.toString();
    }
}

