/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.xml.core;

import de.saxsys.svgfx.xml.core.IDataProvider;
import de.saxsys.svgfx.xml.core.IElementCreator;
import de.saxsys.svgfx.xml.elements.ElementBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParser<TResult, TDataProvider extends IDataProvider, TElementCreator extends IElementCreator<TDataProvider, TElement>, TElement extends ElementBase<TDataProvider, ?, TElement>>
extends DefaultHandler {
    private final TElementCreator elementCreator;
    private final TDataProvider dataProvider;
    private final ReadOnlyObjectWrapper<State> state = new ReadOnlyObjectWrapper((Object)State.IDLE);
    private TResult result;
    private long attemptedParses;
    private long successfulParses;
    private TElement currentElement;

    public SAXParser(TElementCreator elementCreator, TDataProvider dataProvider) throws IllegalArgumentException {
        if (elementCreator == null) {
            throw new IllegalArgumentException("given elementcreator must not be null");
        }
        if (dataProvider == null) {
            throw new IllegalArgumentException("given dataProvider must not be null");
        }
        this.elementCreator = elementCreator;
        this.dataProvider = dataProvider;
        this.result = null;
    }

    public final TResult getResult() {
        return this.result;
    }

    public final long getAttemptedParses() {
        return this.attemptedParses;
    }

    public final long getSuccessfulParses() {
        return this.successfulParses;
    }

    public final void setSuccessfulParses(long value) {
        this.successfulParses = value;
    }

    public final State getState() {
        return (State)((Object)this.state.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        ReadOnlyObjectWrapper<State> readOnlyObjectWrapper = this.state;
        synchronized (readOnlyObjectWrapper) {
            this.state.set((Object)state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isBusy() {
        ReadOnlyObjectWrapper<State> readOnlyObjectWrapper = this.state;
        synchronized (readOnlyObjectWrapper) {
            return this.state.get() != State.IDLE && this.state.get() != State.FINISHED;
        }
    }

    protected abstract TResult enteringDocument() throws SAXException;

    protected abstract void leavingDocument(TResult var1) throws SAXException;

    protected abstract void consumeElementStart(TResult var1, TDataProvider var2, TElement var3) throws SAXException;

    protected abstract void consumeElementEnd(TResult var1, TDataProvider var2, TElement var3) throws SAXException;

    public final ReadOnlyProperty<State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public final void clear() {
        this.result = null;
        this.dataProvider.clear();
    }

    public final void parse(String path) throws SAXParseException, IllegalArgumentException, IllegalStateException, IOException {
        this.parse(new File(path));
    }

    public final void parse(File file) throws SAXParseException, IllegalArgumentException, IllegalStateException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("given file must not be null");
        }
        FileInputStream stream = new FileInputStream(file);
        this.parse(new InputSource(stream));
        ((InputStream)stream).close();
    }

    public final void parse(InputSource data) throws SAXParseException, IllegalArgumentException, IllegalStateException {
        if (data == null) {
            throw new IllegalArgumentException("given data must not be null");
        }
        if (this.isBusy()) {
            throw new IllegalStateException("Can not attempt to parse while the parser is still working");
        }
        try {
            this.setState(State.PREPARING);
            this.dataProvider.clear();
            ++this.attemptedParses;
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(this);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.parse(data);
            ++this.successfulParses;
        }
        catch (Exception e) {
            throw new SAXParseException(null, null, e);
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        this.result = this.enteringDocument();
        this.currentElement = null;
        this.setState(State.STARTING);
    }

    @Override
    public final void endDocument() throws SAXException {
        this.currentElement = null;
        this.setState(State.FINISHED);
        this.leavingDocument(this.result);
    }

    @Override
    public final void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        this.setState(State.PARSING_ENTERING_ELEMENT);
        TElement nextElement = this.elementCreator.createElement(qName, attributes, this.currentElement, this.dataProvider);
        if (nextElement != null) {
            if (this.currentElement != null) {
                ((ElementBase)this.currentElement).getChildren().add((ElementBase)nextElement);
            }
            this.currentElement = nextElement;
            ((ElementBase)this.currentElement).startProcessing();
            this.consumeElementStart(this.result, this.dataProvider, this.currentElement);
        }
        this.setState(State.PARSING_ENTERING_ELEMENT_FINISHED);
    }

    @Override
    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.setState(State.PARSING_LEAVING_ELEMENT);
        if (this.currentElement != null && ((ElementBase)this.currentElement).getName().equals(qName)) {
            ((ElementBase)this.currentElement).endProcessing();
            this.consumeElementEnd(this.result, this.dataProvider, this.currentElement);
            this.currentElement = ((ElementBase)this.currentElement).getParent();
        }
        this.setState(State.PARSING_LEAVING_ELEMENT_FINISHED);
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        this.setState(State.PARSING_ENTERING_ELEMENT_CHARACTERS);
        if (this.currentElement != null) {
            ((ElementBase)this.currentElement).processCharacterData(ch, start, length);
        }
        this.setState(State.PARSING_ENTERING_ELEMENT_CHARACTERS_FINISHED);
    }

    public static enum State {
        IDLE,
        PREPARING,
        STARTING,
        PARSING_ENTERING_ELEMENT,
        PARSING_ENTERING_ELEMENT_FINISHED,
        PARSING_ENTERING_ELEMENT_CHARACTERS,
        PARSING_ENTERING_ELEMENT_CHARACTERS_FINISHED,
        PARSING_LEAVING_ELEMENT,
        PARSING_LEAVING_ELEMENT_FINISHED,
        FINISHED;

    }
}

