/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.css.core;

import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.utils.StringUtils;
import de.saxsys.svgfx.css.core.CssContentTypeBase;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Pair;
import org.w3c.dom.DOMException;

public abstract class CssStyle<TContentType extends CssContentTypeBase> {
    private Selector selector;
    private String name;
    protected final Map<String, TContentType> properties = new HashMap<String, TContentType>();

    public CssStyle() {
    }

    public CssStyle(String name) {
        this();
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final Map<String, TContentType> getProperties() {
        return this.properties;
    }

    private void setNameAndSelector(String name) {
        if (StringUtils.isNotNullOrEmpty(name)) {
            if (name.startsWith(Selector.ID.getName())) {
                this.selector = Selector.ID;
                this.name = name.replace(Selector.ID.getName(), "");
            } else if (name.startsWith(Selector.CLASS.getName())) {
                this.selector = Selector.CLASS;
                this.name = name.replace(Selector.CLASS.getName(), "");
            } else {
                this.selector = Selector.NONE;
                this.name = name;
            }
        } else {
            this.name = name;
        }
    }

    private Pair<String, TContentType> determineContentType(String data) throws SVGException {
        if (StringUtils.isNullOrEmpty(data)) {
            throw new SVGException("Given data must not be null in order to create a property from it");
        }
        String trimmedData = data.trim();
        int index = trimmedData.indexOf(58);
        if (index == -1 || index >= trimmedData.length() - 1) {
            throw new SVGException("Given data either does not provide a property separator or is to short");
        }
        String name = trimmedData.substring(0, index).trim();
        TContentType content = this.createContentType(StringUtils.stripStringIndicators(name));
        if (content != null) {
            String cssText = StringUtils.stripStringIndicators(trimmedData.substring(index + 1).trim());
            try {
                ((CssContentTypeBase)content).parseCssText(cssText);
            }
            catch (Exception e) {
                throw new SVGException(String.format("Could not parse %s for content type %s", cssText, content.getClass().getName()), e);
            }
        }
        return new Pair((Object)name, content);
    }

    protected abstract TContentType createContentType(String var1);

    public final TContentType getCssContentType(String name) {
        return (TContentType)((CssContentTypeBase)this.properties.get(name));
    }

    public final boolean hasCssContentType(String name) {
        return this.properties.containsKey(name);
    }

    public final <TContent extends TContentType> TContent getCssContentType(String name, Class<TContent> clazz) {
        return (TContent)((CssContentTypeBase)clazz.cast(this.properties.get(name)));
    }

    public final <TContentTypeOther extends TContentType> void combineWithStyle(CssStyle<TContentTypeOther> style) {
        if (style == null) {
            throw new IllegalArgumentException("given style must not be null");
        }
        if (this == style) {
            return;
        }
        for (Map.Entry<String, TContentType> entry : style.properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.put(entry.getKey(), entry.getValue());
        }
    }

    public final void parseCssText(String cssText) throws DOMException {
        this.name = null;
        this.selector = Selector.NONE;
        this.properties.clear();
        StringBuilder dataBuilder = new StringBuilder();
        boolean isInsideDeclarationBlock = false;
        ParsingState state = ParsingState.DATA;
        for (int i = 0; i < cssText.length(); ++i) {
            char character = cssText.charAt(i);
            if (state == ParsingState.COMMENT) {
                if (character != '/' || i <= 0 || cssText.charAt(i - 1) != '*') continue;
                state = ParsingState.DATA;
                continue;
            }
            if (character == '\"') {
                state = state != ParsingState.STRING ? ParsingState.STRING : ParsingState.DATA;
            }
            if (state != ParsingState.STRING) {
                Pair<String, TContentType> property;
                if (character == '/' && i < cssText.length() - 1 && cssText.charAt(i + 1) == '*') {
                    state = ParsingState.COMMENT;
                    continue;
                }
                if (character == '{') {
                    this.setNameAndSelector(dataBuilder.toString().trim());
                    isInsideDeclarationBlock = true;
                    dataBuilder.setLength(0);
                    continue;
                }
                if (character == ';') {
                    property = this.determineContentType(dataBuilder.toString());
                    if (property.getValue() != null) {
                        this.properties.put((String)property.getKey(), property.getValue());
                    }
                    dataBuilder.setLength(0);
                    continue;
                }
                if (character == '}') {
                    if (dataBuilder.toString().trim().length() > 0 && (property = this.determineContentType(dataBuilder.toString())).getValue() != null) {
                        this.properties.put((String)property.getKey(), property.getValue());
                    }
                    isInsideDeclarationBlock = false;
                    break;
                }
                dataBuilder.append(character);
                continue;
            }
            if (!isInsideDeclarationBlock) continue;
            dataBuilder.append(character);
        }
        if (isInsideDeclarationBlock) {
            throw new SVGException("Css text not properly closed");
        }
    }

    public int hashCode() {
        return this.name == null ? super.hashCode() : this.name.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (!result && obj != null && CssStyle.class.isAssignableFrom(obj.getClass())) {
            CssStyle other = (CssStyle)obj;
            result = this.name == null ? other.getName() == null : this.name.equals(other.getName());
        }
        return result;
    }

    private static enum Selector {
        NONE("."),
        CLASS("."),
        ID("#");

        private final String name;

        private Selector(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum ParsingState {
        DATA,
        COMMENT,
        STRING;

    }
}

