/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

public final class StringUtils {
    public static String replaceLast(String source, char toReplace, char toUse) {
        return StringUtils.replaceLast(source, String.valueOf(toReplace), String.valueOf(toUse));
    }

    public static String replaceLast(String source, String toReplace, String toUse) {
        if (source == null) {
            return null;
        }
        int lastIndex = source.lastIndexOf(toReplace);
        if (lastIndex < 0) {
            return source;
        }
        return String.format("%s%s", source.substring(0, lastIndex), source.substring(lastIndex).replaceFirst(toReplace, toUse));
    }

    public static boolean isNullOrEmpty(String data) {
        return data == null || data.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String data) {
        return !StringUtils.isNullOrEmpty(data);
    }

    public static String stripStringIndicators(String data) {
        if (StringUtils.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        return data.substring(data.charAt(0) == '\"' ? 1 : 0, data.charAt(data.length() - 1) == '\"' ? data.length() - 1 : data.length());
    }

    private StringUtils() {
    }
}

