/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.utils;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssContentTypeBase;
import de.saxsys.svgfx.core.css.SVGCssContentTypeDouble;
import de.saxsys.svgfx.core.css.SVGCssContentTypeLength;
import de.saxsys.svgfx.core.css.SVGCssContentTypePaint;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeDashArray;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeLineCap;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeLineJoin;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeType;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGLinearGradient;
import de.saxsys.svgfx.core.elements.SVGRadialGradient;
import de.saxsys.svgfx.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Shear;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public final class SVGUtils {
    private static final char CLOSING_BRACE = ')';

    private SVGUtils() {
    }

    public static String stripIRIIdentifiers(String data) throws IllegalArgumentException {
        if (StringUtils.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        int dataLengthReduction = 1;
        int identifierLength = "url(#".length();
        int index = -1;
        if (data.length() > "url(#".length() && data.startsWith("url(#")) {
            index = "url(#".length();
        }
        if (index == -1) {
            dataLengthReduction = 0;
            identifierLength = "#".length();
            if (data.length() > "#".length() && data.startsWith("#")) {
                index = "#".length();
            }
        }
        if (index > -1) {
            return data.substring(identifierLength, data.length() - dataLengthReduction);
        }
        return null;
    }

    public static <TSVGElementBase extends SVGElementBase<?>> TSVGElementBase resolveIRI(String data, SVGDataProvider dataProvider, Class<TSVGElementBase> clazz) throws SVGException, IllegalArgumentException {
        TSVGElementBase result;
        if (dataProvider == null) {
            throw new IllegalArgumentException("given dataprovider must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("given clazz must not be null");
        }
        String reference = SVGUtils.stripIRIIdentifiers(data);
        if (StringUtils.isNullOrEmpty(reference)) {
            throw new SVGException(String.format("Given data %s appears to not be a IRI reference.", data));
        }
        try {
            result = dataProvider.getData(clazz, reference);
        }
        catch (Exception e) {
            throw new SVGException("An error occurred during the parsing of the reference", e);
        }
        if (result == null) {
            throw new SVGException(String.format("Given reference %s could not be resolved", data));
        }
        return result;
    }

    public static Paint parseColor(String data, SVGDataProvider dataProvider) throws SVGException, IllegalArgumentException {
        if (StringUtils.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("given data must not be null or empty");
        }
        SVGElementBase reference = null;
        if (data.startsWith("url(#")) {
            reference = SVGUtils.resolveIRI(data, dataProvider, SVGElementBase.class);
        }
        Color result = null;
        if (reference != null) {
            if (reference instanceof SVGLinearGradient) {
                result = (Paint)((SVGLinearGradient)reference).getResult();
            } else if (reference instanceof SVGRadialGradient) {
                result = (Paint)((SVGRadialGradient)reference).getResult();
            }
            if (result == null) {
                throw new IllegalArgumentException("given data can not be resolved to a color");
            }
        } else {
            result = data.equals("none") ? Color.TRANSPARENT : Color.web((String)data);
        }
        return result;
    }

    public static <TShape extends Shape> void applyStyle(TShape shape, SVGCssStyle style, SVGDataProvider dataProvider) throws IllegalArgumentException {
        if (dataProvider == null) {
            throw new IllegalArgumentException("Given dataProvider must not be null");
        }
        if (shape == null) {
            throw new IllegalArgumentException("Given shape must not be null");
        }
        if (style == null) {
            throw new IllegalArgumentException("Given style must not be null");
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.FILL.getName())) {
            shape.setFill((Paint)style.getCssContentType(SVGCssStyle.PresentationAttribute.FILL.getName(), SVGCssContentTypePaint.class).getValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE.getName())) {
            shape.setStroke((Paint)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE.getName(), SVGCssContentTypePaint.class).getValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_TYPE.getName())) {
            shape.setStrokeType((StrokeType)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_TYPE.getName(), SVGCssContentTypeStrokeType.class).getValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_WIDTH.getName())) {
            shape.setStrokeWidth(((Double)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_WIDTH.getName(), SVGCssContentTypeLength.class).getValue()).doubleValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_DASHARRAY.getName())) {
            shape.getStrokeDashArray().clear();
            shape.getStrokeDashArray().addAll(style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_DASHARRAY.getName(), SVGCssContentTypeStrokeDashArray.class).getDashValues());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_DASHOFFSET.getName())) {
            shape.setStrokeDashOffset(((Double)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_DASHOFFSET.getName(), SVGCssContentTypeLength.class).getValue()).doubleValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_LINEJOIN.getName())) {
            shape.setStrokeLineJoin((StrokeLineJoin)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_LINEJOIN.getName(), SVGCssContentTypeStrokeLineJoin.class).getValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_LINECAP.getName())) {
            shape.setStrokeLineCap((StrokeLineCap)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_LINECAP.getName(), SVGCssContentTypeStrokeLineCap.class).getValue());
        }
        if (style.hasCssContentType(SVGCssStyle.PresentationAttribute.STROKE_MITERLIMIT.getName())) {
            shape.setStrokeMiterLimit(((Double)style.getCssContentType(SVGCssStyle.PresentationAttribute.STROKE_MITERLIMIT.getName(), SVGCssContentTypeDouble.class).getValue()).doubleValue());
        }
    }

    public static void combineStylesAndResolveInheritance(SVGCssStyle style, SVGCssStyle otherStyle) throws IllegalArgumentException {
        if (style == null) {
            throw new IllegalArgumentException("Given style must not be null");
        }
        if (otherStyle == null) {
            throw new IllegalArgumentException("Given otherStyle must not be null");
        }
        style.combineWithStyle(otherStyle);
        for (Map.Entry property : style.getProperties().entrySet()) {
            if (!((SVGCssContentTypeBase)property.getValue()).getIsInherited()) continue;
            SVGCssContentTypeBase otherProperty = (SVGCssContentTypeBase)otherStyle.getCssContentType(property.getKey());
            if (otherProperty != null && !otherProperty.getIsInherited()) {
                if (otherProperty.getIsNone()) {
                    ((SVGCssContentTypeBase)property.getValue()).parseCssText(SVGCssContentTypeBase.NONE_INDICATOR);
                    continue;
                }
                ((SVGCssContentTypeBase)property.getValue()).setValue(otherProperty.getValue());
                ((SVGCssContentTypeBase)property.getValue()).setUnit(otherProperty.getUnit());
                continue;
            }
            ((SVGCssContentTypeBase)property.getValue()).setValue(((SVGCssContentTypeBase)property.getValue()).getDefaultValue());
            ((SVGCssContentTypeBase)property.getValue()).setUnit(null);
        }
    }

    public static Transform getTransform(String data) throws SVGException {
        if (StringUtils.isNullOrEmpty(data)) {
            return null;
        }
        Transform result = null;
        EnumSet<SVGElementBase.Matrix> allMatrices = EnumSet.allOf(SVGElementBase.Matrix.class);
        allMatrices.remove((Object)SVGElementBase.Matrix.NONE);
        block0: for (int i = 0; i < data.length(); ++i) {
            for (SVGElementBase.Matrix matrix : allMatrices) {
                if (!data.startsWith(matrix.getName(), i)) continue;
                int start = i + matrix.getName().length() + 1;
                i = data.indexOf(41, start);
                Transform transform = SVGUtils.getTransform(matrix, data.substring(start, i), false);
                if (result == null) {
                    result = transform;
                    continue block0;
                }
                result = result.createConcatenation(transform);
                continue block0;
            }
        }
        return result;
    }

    public static Transform getTransform(SVGElementBase.Matrix matrix, String data, boolean checkIfStartWithMatrix) throws SVGException {
        Shear result;
        if (StringUtils.isNullOrEmpty(data)) {
            throw new IllegalArgumentException("Given data must not be null or empty");
        }
        if (matrix == SVGElementBase.Matrix.NONE) {
            throw new IllegalArgumentException("Given matrix must not be NONE");
        }
        String actualData = data;
        if (checkIfStartWithMatrix) {
            if (!data.startsWith(matrix.getName())) {
                throw new IllegalArgumentException(String.format("Given data does not start with the expected Matrix: %s", matrix.getName()));
            }
            actualData = actualData.substring(matrix.getName().length()).trim();
        }
        if (actualData.charAt(0) == '(') {
            actualData = actualData.substring(1);
        }
        if (actualData.charAt(actualData.length() - 1) == ')') {
            actualData = actualData.substring(0, actualData.length());
        }
        List<String> values = SVGUtils.split(actualData, Arrays.asList(Character.valueOf(' '), Character.valueOf(',')), (currentData, index) -> true);
        switch (matrix) {
            case MATRIX: {
                if (values.size() != 6) {
                    throw new SVGException(String.format("Given number of values does not match for matrix %s. Expected 6 values but got %d", matrix.getName(), values.size()));
                }
                try {
                    result = new Affine(Double.parseDouble(values.get(0).trim()), Double.parseDouble(values.get(2).trim()), Double.parseDouble(values.get(4).trim()), Double.parseDouble(values.get(1).trim()), Double.parseDouble(values.get(3).trim()), Double.parseDouble(values.get(5).trim()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(e);
                }
            }
            case TRANSLATE: 
            case SCALE: {
                if (values.size() != 1 && values.size() != 2) {
                    throw new SVGException(String.format("Given number of values does not match for matrix %s. Expected 1 or 2 values but got %d", matrix.getName(), values.size()));
                }
                try {
                    double y;
                    double x = Double.parseDouble(values.get(0).trim());
                    double d = y = values.size() == 2 ? Double.parseDouble(values.get(1).trim()) : x;
                    if (matrix == SVGElementBase.Matrix.TRANSLATE) {
                        result = new Translate(x, y);
                        break;
                    }
                    result = new Scale(x, y);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(e);
                }
            }
            case ROTATE: {
                if (values.size() != 1 && values.size() != 3) {
                    throw new SVGException(String.format("Given number of values does not match for matrix %s. Expected 1 or 3 values but got %d", matrix.getName(), values.size()));
                }
                try {
                    double x = values.size() == 3 ? Double.parseDouble(values.get(1).trim()) : 0.0;
                    double y = values.size() == 3 ? Double.parseDouble(values.get(2).trim()) : 0.0;
                    result = new Rotate(Double.parseDouble(values.get(0).trim()), x, y);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SVGException(e);
                }
            }
            default: {
                double shearing;
                if (values.size() != 1) {
                    throw new SVGException(String.format("Given number of values does not match for matrix %s. Expected 1 value but got %d", matrix.getName(), values.size()));
                }
                try {
                    shearing = Double.parseDouble(values.get(0).trim());
                }
                catch (NumberFormatException e) {
                    throw new SVGException(e);
                }
                result = matrix == SVGElementBase.Matrix.SKEW_X ? new Shear(shearing, 0.0) : new Shear(0.0, shearing);
            }
        }
        return result;
    }

    public static List<String> split(String toSplit, List<Character> delimiters, SplitConsumer dataConsumer) throws SVGException, IllegalArgumentException {
        if (StringUtils.isNullOrEmpty(toSplit)) {
            throw new IllegalArgumentException("Given toSplit must not be null or empty");
        }
        if (dataConsumer == null) {
            throw new IllegalArgumentException("Given dataConsumer must not be null");
        }
        if (delimiters == null || delimiters.isEmpty()) {
            throw new IllegalArgumentException("Given delimiters must not be null or empty");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < toSplit.length(); ++i) {
            boolean isLastCharacter;
            char character = toSplit.charAt(i);
            boolean isDelimiter = delimiters.contains(Character.valueOf(character));
            boolean bl = isLastCharacter = i == toSplit.length() - 1;
            if (isLastCharacter || isDelimiter) {
                if (isLastCharacter && !isDelimiter) {
                    builder.append(character);
                }
                if (builder.length() <= 0 || !dataConsumer.consume(builder.toString(), i)) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(character);
        }
        return result;
    }

    @FunctionalInterface
    public static interface SplitConsumer {
        public boolean consume(String var1, int var2) throws SVGException;
    }
}

