/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementMapping;
import de.saxsys.svgfx.core.utils.SVGUtils;
import de.saxsys.svgfx.core.utils.StringUtils;
import javafx.scene.Group;
import javafx.scene.Node;
import org.xml.sax.Attributes;

@SVGElementMapping(value="use")
public class SVGUse
extends SVGElementBase<Group> {
    public SVGUse(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected Group createResult(SVGCssStyle style) throws SVGException {
        String reference = this.getAttributes().get(SVGElementBase.XLinkAttribute.XLINK_HREF.getName());
        if (StringUtils.isNullOrEmpty(reference)) {
            throw new SVGException("XLink attribute is invalid.");
        }
        SVGElementBase referencedElement = SVGUtils.resolveIRI(reference, (SVGDataProvider)this.getDataProvider(), SVGElementBase.class);
        String positionX = this.getAttribute(SVGElementBase.CoreAttribute.POSITION_X.getName());
        String positionY = this.getAttribute(SVGElementBase.CoreAttribute.POSITION_Y.getName());
        Group result = new Group();
        result.setLayoutX(StringUtils.isNullOrEmpty(positionX) ? 0.0 : Double.parseDouble(positionX));
        result.setLayoutY(StringUtils.isNullOrEmpty(positionY) ? 0.0 : Double.parseDouble(positionY));
        SVGCssStyle childStyle = referencedElement.getCssStyleAndResolveInheritance();
        SVGUtils.combineStylesAndResolveInheritance(childStyle, style);
        result.getChildren().add((Object)((Node)referencedElement.createAndInitializeResult(childStyle)));
        return result;
    }

    @Override
    protected void initializeResult(Group node, SVGCssStyle inheritanceResolver) throws SVGException {
    }
}

