/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementMapping;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import de.saxsys.svgfx.core.utils.StringUtils;
import javafx.scene.shape.Rectangle;
import org.xml.sax.Attributes;

@SVGElementMapping(value="rect")
public class SVGRectangle
extends SVGShapeBase<Rectangle> {
    public SVGRectangle(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final Rectangle createResult(SVGCssStyle style) {
        String positionX = this.getAttribute(SVGElementBase.CoreAttribute.POSITION_X.getName());
        String positionY = this.getAttribute(SVGElementBase.CoreAttribute.POSITION_Y.getName());
        return new Rectangle(StringUtils.isNullOrEmpty(positionX) ? 0.0 : Double.parseDouble(positionX), StringUtils.isNullOrEmpty(positionY) ? 0.0 : Double.parseDouble(positionY), Double.parseDouble(this.getAttribute(SVGElementBase.CoreAttribute.WIDTH.getName())), Double.parseDouble(this.getAttribute(SVGElementBase.CoreAttribute.HEIGHT.getName())));
    }

    @Override
    protected void initializeResult(Rectangle rect, SVGCssStyle style) throws SVGException {
        super.initializeResult(rect, style);
        if (StringUtils.isNotNullOrEmpty(this.getAttribute(SVGElementBase.CoreAttribute.RADIUS_X.getName()))) {
            rect.setArcWidth(Double.parseDouble(this.getAttribute(SVGElementBase.CoreAttribute.RADIUS_X.getName())) * 2.0);
        }
        if (StringUtils.isNotNullOrEmpty(this.getAttribute(SVGElementBase.CoreAttribute.RADIUS_Y.getName()))) {
            rect.setArcHeight(Double.parseDouble(this.getAttribute(SVGElementBase.CoreAttribute.RADIUS_Y.getName())) * 2.0);
        }
    }
}

