/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementMapping;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.utils.StringUtils;
import java.util.List;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.xml.sax.Attributes;

@SVGElementMapping(value="radialGradient")
public class SVGRadialGradient
extends SVGGradientBase<RadialGradient> {
    public SVGRadialGradient(String name, Attributes attributes, SVGElementBase<SVGDataProvider> parent, SVGDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final RadialGradient createResult(SVGCssStyle style) {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException("Given radial gradient does not have colors");
        }
        String centerX = this.getAttribute(SVGElementBase.CoreAttribute.CENTER_X.getName());
        String centerY = this.getAttribute(SVGElementBase.CoreAttribute.CENTER_Y.getName());
        String focusX = this.getAttribute(SVGElementBase.CoreAttribute.FOCUS_X.getName());
        String focusY = this.getAttribute(SVGElementBase.CoreAttribute.FOCUS_Y.getName());
        double cx = StringUtils.isNullOrEmpty(centerX) ? 0.0 : Double.parseDouble(centerX);
        double cy = StringUtils.isNullOrEmpty(centerY) ? 0.0 : Double.parseDouble(centerY);
        double fx = StringUtils.isNullOrEmpty(focusX) ? cx : Double.parseDouble(focusX);
        double fy = StringUtils.isNullOrEmpty(focusY) ? cy : Double.parseDouble(focusY);
        double diffX = fx - cx;
        double diffY = fy - cy;
        double distance = diffX != 0.0 && diffY != 0.0 ? Math.hypot(diffX, diffY) : 0.0;
        double angle = diffX != 0.0 && diffY != 0.0 ? Math.atan2(diffY, diffX) : 0.0;
        return new RadialGradient(angle, distance, cx, cy, Double.parseDouble(this.getAttribute(SVGElementBase.CoreAttribute.RADIUS.getName())), false, CycleMethod.NO_CYCLE, stops);
    }
}

