/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGShapeBase;
import de.saxsys.svgfx.core.utils.SVGUtils;
import de.saxsys.svgfx.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.shape.Shape;
import org.xml.sax.Attributes;

public abstract class SVGPolyBase<TShape extends Shape>
extends SVGShapeBase<TShape> {
    private static char POINTS_DELIMITER = (char)32;
    private static char POSITION_DELIMITER = (char)44;
    private static String POSITION_DELIMITER_STRING = String.valueOf(POSITION_DELIMITER);

    public SVGPolyBase(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    public final List<Double> getPoints() throws SVGException, IllegalArgumentException {
        ArrayList<Double> actualPoints = new ArrayList<Double>();
        String points = this.getAttribute(SVGElementBase.CoreAttribute.POINTS.getName());
        if (StringUtils.isNullOrEmpty(points)) {
            return actualPoints;
        }
        List<String> values = SVGUtils.split(points, Collections.singletonList(Character.valueOf(POINTS_DELIMITER)), (currentData, index) -> {
            boolean containsDelimiter = currentData.contains(POSITION_DELIMITER_STRING);
            if (containsDelimiter && currentData.charAt(currentData.length() - 1) != POSITION_DELIMITER) {
                return true;
            }
            if (index == points.length() - 1 || points.charAt(index + 1) != POINTS_DELIMITER) {
                throw new SVGException("Invalid points format");
            }
            return false;
        });
        for (String pointsSplit : values) {
            String[] pointSplit = pointsSplit.split(POSITION_DELIMITER_STRING);
            if (pointSplit.length != 2) {
                throw new IllegalArgumentException("At least one point does not provide x and y position");
            }
            actualPoints.add(Double.parseDouble(pointSplit[0].trim()));
            actualPoints.add(Double.parseDouble(pointSplit[1].trim()));
        }
        return actualPoints;
    }
}

