/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementMapping;
import de.saxsys.svgfx.core.elements.SVGGradientBase;
import de.saxsys.svgfx.core.utils.StringUtils;
import java.util.List;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import org.xml.sax.Attributes;

@SVGElementMapping(value="linearGradient")
public class SVGLinearGradient
extends SVGGradientBase<LinearGradient> {
    public SVGLinearGradient(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) {
        super(name, attributes, parent, dataProvider);
    }

    @Override
    protected final LinearGradient createResult(SVGCssStyle style) throws SVGException {
        List<Stop> stops = this.getStops();
        if (stops.isEmpty()) {
            throw new SVGException("Given linear gradient does not have colors");
        }
        String startX = this.getAttribute(SVGElementBase.CoreAttribute.START_X.getName());
        String startY = this.getAttribute(SVGElementBase.CoreAttribute.START_Y.getName());
        String endX = this.getAttribute(SVGElementBase.CoreAttribute.END_X.getName());
        String endY = this.getAttribute(SVGElementBase.CoreAttribute.END_Y.getName());
        return new LinearGradient(StringUtils.isNullOrEmpty(startX) ? 0.0 : Double.parseDouble(startX), StringUtils.isNullOrEmpty(startY) ? 0.0 : Double.parseDouble(startY), StringUtils.isNullOrEmpty(endX) ? 1.0 : Double.parseDouble(endX), StringUtils.isNullOrEmpty(endY) ? 1.0 : Double.parseDouble(endY), false, CycleMethod.NO_CYCLE, stops);
    }
}

