/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.definitions.Constants;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.elements.SVGElementMapping;
import de.saxsys.svgfx.xml.core.IElementCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class SVGElementCreator
implements IElementCreator<SVGDataProvider, SVGElementBase<?>> {
    private final Map<String, Constructor<? extends SVGElementBase<?>>> knownClasses = new HashMap();

    public SVGElementCreator() {
        for (Class<SVGElementBase<?>> clazz : Constants.SVG_ELEMENT_CLASSES) {
            SVGElementMapping annotation = clazz.getAnnotation(SVGElementMapping.class);
            if (annotation == null) continue;
            try {
                this.knownClasses.put(annotation.value(), clazz.getConstructor(String.class, Attributes.class, SVGElementBase.class, SVGDataProvider.class));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("element %s does not have a matching constructor", annotation.value()), e);
            }
        }
    }

    public Map<String, Constructor<? extends SVGElementBase<?>>> getKnownClasses() {
        return this.knownClasses;
    }

    @Override
    public SVGElementBase<?> createElement(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) {
        Constructor<SVGElementBase<?>> constructor = this.knownClasses.get(name);
        if (constructor != null) {
            try {
                return constructor.newInstance(name, attributes, parent, dataProvider);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

