/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.elements;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssContentTypeString;
import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGClipPath;
import de.saxsys.svgfx.core.utils.SVGUtils;
import de.saxsys.svgfx.core.utils.StringUtils;
import de.saxsys.svgfx.css.definitions.Constants;
import de.saxsys.svgfx.xml.elements.ElementBase;
import java.util.EnumSet;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.xml.sax.Attributes;

public abstract class SVGElementBase<TResult>
extends ElementBase<SVGDataProvider, TResult, SVGElementBase<?>> {
    private TResult result;

    public SVGElementBase(String name, Attributes attributes, SVGElementBase<?> parent, SVGDataProvider dataProvider) throws IllegalArgumentException {
        super(name, attributes, parent, dataProvider);
    }

    private void cleanStyleBeforeUsing(SVGCssStyle style) {
        String clipPathReference;
        SVGCssContentTypeString clipPath;
        String id = this.getAttribute(CoreAttribute.ID.getName());
        if (StringUtils.isNotNullOrEmpty(id) && (clipPath = style.getCssContentType(SVGCssStyle.PresentationAttribute.CLIP_PATH.getName(), SVGCssContentTypeString.class)) != null && StringUtils.isNotNullOrEmpty(clipPathReference = SVGUtils.stripIRIIdentifiers((String)clipPath.getValue())) && clipPathReference.equals(id)) {
            style.getProperties().remove(SVGCssStyle.PresentationAttribute.CLIP_PATH.getName());
        }
    }

    protected abstract TResult createResult(SVGCssStyle var1) throws SVGException;

    protected abstract void initializeResult(TResult var1, SVGCssStyle var2) throws SVGException;

    public final SVGCssStyle getCssStyleAndResolveInheritance() {
        return this.getCssStyleAndResolveInheritance(this.getParent() != null ? ((SVGElementBase)this.getParent()).getCssStyleAndResolveInheritance() : new SVGCssStyle((SVGDataProvider)this.getDataProvider()));
    }

    public final SVGCssStyle getCssStyleAndResolveInheritance(SVGCssStyle otherStyle) {
        SVGCssStyle style = this.getCssStyle();
        SVGUtils.combineStylesAndResolveInheritance(style, otherStyle);
        return style;
    }

    public final SVGCssStyle getCssStyle() {
        SVGCssStyle referencedStyle;
        SVGCssStyle style = this.getPresentationCssStyle();
        SVGCssStyle ownStyle = this.getOwnStyle();
        if (ownStyle != null) {
            if (style == null) {
                style = ownStyle;
            } else {
                style.combineWithStyle(ownStyle);
            }
        }
        if ((referencedStyle = this.getReferencedStyle()) != null) {
            if (style == null) {
                style = referencedStyle;
            } else {
                style.combineWithStyle(referencedStyle);
            }
        }
        if (style == null) {
            style = new SVGCssStyle((SVGDataProvider)this.getDataProvider());
        }
        return style;
    }

    public final SVGCssStyle getOwnStyle() {
        if (StringUtils.isNullOrEmpty(this.getAttribute(CoreAttribute.STYLE.getName()))) {
            return null;
        }
        String attribute = this.getAttribute(CoreAttribute.STYLE.getName());
        SVGCssStyle ownStyle = new SVGCssStyle((SVGDataProvider)this.getDataProvider());
        ownStyle.parseCssText(String.format("ownStyle%s%s%s%s", Character.valueOf('{'), attribute, attribute.endsWith(Constants.PROPERTY_END_STRING) ? "" : Character.valueOf(';'), Character.valueOf('}')));
        return ownStyle;
    }

    public final SVGCssStyle getReferencedStyle() throws SVGException {
        if (StringUtils.isNullOrEmpty(this.getAttribute(CoreAttribute.CLASS.getName()))) {
            return null;
        }
        String reference = this.getAttribute(CoreAttribute.CLASS.getName());
        try {
            return ((SVGDataProvider)this.getDataProvider()).getStyles().stream().filter(data -> data.getName().endsWith(reference)).findFirst().get();
        }
        catch (Exception e) {
            throw new SVGException(String.format("Given style reference %s was not found", reference), e);
        }
    }

    public final SVGCssStyle getPresentationCssStyle() {
        SVGCssStyle result = null;
        StringBuilder cssText = new StringBuilder();
        for (SVGCssStyle.PresentationAttribute attribute : EnumSet.allOf(SVGCssStyle.PresentationAttribute.class)) {
            String data = this.getAttribute(attribute.getName());
            if (!StringUtils.isNotNullOrEmpty(data)) continue;
            if (cssText.length() == 0) {
                cssText.append("presentationStyle{");
            }
            cssText.append(String.format("%s%s%s%s", attribute.getName(), Character.valueOf(':'), data, Character.valueOf(';')));
        }
        if (cssText.length() > 0) {
            cssText.append('}');
            result = new SVGCssStyle((SVGDataProvider)this.getDataProvider());
            result.parseCssText(cssText.toString());
        }
        return result;
    }

    public final Transform getTransformation() throws SVGException {
        if (StringUtils.isNotNullOrEmpty(this.getAttribute(CoreAttribute.TRANSFORM.getName()))) {
            return SVGUtils.getTransform(this.getAttribute(CoreAttribute.TRANSFORM.getName()));
        }
        return null;
    }

    public final Node getClipPath() throws SVGException {
        return this.getClipPath(this.getCssStyleAndResolveInheritance());
    }

    public final Node getClipPath(SVGCssStyle style) throws SVGException {
        SVGCssContentTypeString referenceIRI = style.getCssContentType(SVGCssStyle.PresentationAttribute.CLIP_PATH.getName(), SVGCssContentTypeString.class);
        if (referenceIRI != null && StringUtils.isNotNullOrEmpty((String)referenceIRI.getValue())) {
            return (Node)SVGUtils.resolveIRI((String)referenceIRI.getValue(), (SVGDataProvider)this.getDataProvider(), SVGClipPath.class).createAndInitializeResult();
        }
        return null;
    }

    public final TResult getResult(SVGCssStyle style) throws SVGException {
        if (this.result == null) {
            this.result = this.createAndInitializeResult(style);
        }
        return this.result;
    }

    public final TResult createAndInitializeResult() throws SVGException {
        return this.createAndInitializeResult(this.getCssStyleAndResolveInheritance());
    }

    public final TResult createAndInitializeResult(SVGCssStyle style) throws SVGException {
        TResult result;
        this.cleanStyleBeforeUsing(style);
        try {
            result = this.createResult(style);
            this.initializeResult(result, style);
        }
        catch (Exception e) {
            throw new SVGException(String.format("Creation of element %s failed.\nOriginal element is %s ", this.getClass().getName(), this.toString()), e);
        }
        return result;
    }

    @Override
    public final TResult getResult() throws SVGException {
        if (this.result == null) {
            this.result = this.createAndInitializeResult();
        }
        return this.result;
    }

    @Override
    public void startProcessing() throws SVGException {
    }

    @Override
    public void processCharacterData(char[] ch, int start, int length) throws SVGException {
    }

    @Override
    public void endProcessing() throws SVGException {
    }

    public static enum Matrix {
        NONE(""),
        MATRIX("matrix"),
        TRANSLATE("translate"),
        SCALE("scale"),
        ROTATE("rotate"),
        SKEW_X("skewX"),
        SKEW_Y("skewY");

        private final String name;

        private Matrix(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }

    public static enum XLinkAttribute {
        XLINK_HREF("xlink:href");

        private final String name;

        private XLinkAttribute(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }

    public static enum CoreAttribute {
        ID("id"),
        TRANSFORM("transform"),
        STYLE("style"),
        CLASS("class"),
        CENTER_X("cx"),
        CENTER_Y("cy"),
        RADIUS("r"),
        RADIUS_X("rx"),
        RADIUS_Y("ry"),
        FOCUS_X("fx"),
        FOCUS_Y("fy"),
        POINTS("points"),
        START_X("x1"),
        START_Y("y1"),
        END_X("x2"),
        END_Y("y2"),
        PATH_DESCRIPTION("d"),
        POSITION_X("x"),
        POSITION_Y("y"),
        WIDTH("width"),
        HEIGHT("height"),
        OFFSET("offset"),
        TYPE("type");

        private final String name;

        private CoreAttribute(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }
}

