/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.css;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.SVGException;
import de.saxsys.svgfx.core.css.SVGCssContentTypeBase;
import de.saxsys.svgfx.core.css.SVGCssContentTypeDouble;
import de.saxsys.svgfx.core.css.SVGCssContentTypeFillRule;
import de.saxsys.svgfx.core.css.SVGCssContentTypeLength;
import de.saxsys.svgfx.core.css.SVGCssContentTypePaint;
import de.saxsys.svgfx.core.css.SVGCssContentTypeString;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeDashArray;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeLineCap;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeLineJoin;
import de.saxsys.svgfx.core.css.SVGCssContentTypeStrokeType;
import de.saxsys.svgfx.css.core.CssStyle;
import java.lang.reflect.InvocationTargetException;

public class SVGCssStyle
extends CssStyle<SVGCssContentTypeBase> {
    private final SVGDataProvider provider;

    public SVGCssStyle(SVGDataProvider provider) {
        this.provider = provider;
    }

    public SVGCssStyle(String name, SVGDataProvider provider) {
        super(name);
        this.provider = provider;
    }

    @Override
    protected SVGCssContentTypeBase createContentType(String name) {
        for (PresentationAttribute attribute : PresentationAttribute.values()) {
            if (!attribute.getName().equals(name)) continue;
            try {
                return attribute.getContentTypeClass().getConstructor(SVGDataProvider.class).newInstance(this.provider);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new SVGException("could not create an element for Content type class", e);
            }
        }
        return new SVGCssContentTypeString(this.provider);
    }

    public static enum PresentationAttribute {
        STROKE("stroke", SVGCssContentTypePaint.class),
        STROKE_TYPE("stroke-type", SVGCssContentTypeStrokeType.class),
        STROKE_DASHARRAY("stroke-dasharray", SVGCssContentTypeStrokeDashArray.class),
        STROKE_DASHOFFSET("stroke-dashoffset", SVGCssContentTypeLength.class),
        STROKE_LINECAP("stroke-linecap", SVGCssContentTypeStrokeLineCap.class),
        STROKE_LINEJOIN("stroke-linejoin", SVGCssContentTypeStrokeLineJoin.class),
        STROKE_MITERLIMIT("stroke-miterlimit", SVGCssContentTypeDouble.class),
        STROKE_OPACITY("stroke-opacity", SVGCssContentTypeDouble.class),
        STROKE_WIDTH("stroke-width", SVGCssContentTypeLength.class),
        CLIP_PATH("clip-path", SVGCssContentTypeString.class),
        CLIP_RULE("clip-rule", SVGCssContentTypeString.class),
        FILL("fill", SVGCssContentTypePaint.class),
        FILL_OPACITY("fill-opacity", SVGCssContentTypeDouble.class),
        FILL_RULE("fill-rule", SVGCssContentTypeFillRule.class),
        STOP_COLOR("stop-color", SVGCssContentTypePaint.class),
        STOP_OPACITY("stop-opacity", SVGCssContentTypeDouble.class),
        COLOR("color", SVGCssContentTypePaint.class),
        OPACITY("opacity", SVGCssContentTypeDouble.class);

        private final String name;
        private final Class<? extends SVGCssContentTypeBase> contentTypeClass;

        private PresentationAttribute(String name, Class<? extends SVGCssContentTypeBase> contentTypeClass) {
            this.name = name;
            this.contentTypeClass = contentTypeClass;
        }

        public final String getName() {
            return this.name;
        }

        public final Class<? extends SVGCssContentTypeBase> getContentTypeClass() {
            return this.contentTypeClass;
        }
    }
}

