/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.css;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.core.css.SVGCssContentTypeBase;
import java.util.EnumSet;
import javafx.util.Pair;

public class SVGCssContentTypeLength
extends SVGCssContentTypeBase<Double, Unit> {
    public static final double DEFAULT_VALUE = 0.0;

    public SVGCssContentTypeLength(SVGDataProvider dataProvider) {
        super(0.0, dataProvider);
    }

    @Override
    protected Pair<Double, Unit> getValueAndUnit(String cssText) {
        Unit usedUnit = Unit.NONE;
        for (Unit unit : EnumSet.complementOf(EnumSet.of(Unit.NONE))) {
            if (!cssText.endsWith(unit.getName())) continue;
            usedUnit = unit;
            break;
        }
        return new Pair((Object)Double.parseDouble(cssText.substring(0, cssText.length() - usedUnit.getName().length()).replaceAll(",", ".")), (Object)usedUnit);
    }

    public static enum Unit {
        NONE(""),
        RELATIVE_SELF("em"),
        RELATIVE_HEIGHT("ex"),
        PIXEL("px"),
        INCH("in"),
        CENTIMETER("cm"),
        MILLIMETER("mm"),
        POINT("pt"),
        PICAS("pc"),
        PERCENT("%");

        private final String name;

        private Unit(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }
    }
}

