/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core.css;

import de.saxsys.svgfx.core.SVGDataProvider;
import de.saxsys.svgfx.css.core.CssContentTypeBase;
import javafx.util.Pair;

public abstract class SVGCssContentTypeBase<TValue, TUnit>
extends CssContentTypeBase<TValue, TUnit> {
    public static String INHERIT_INDICATOR = "inherit";
    public static String NONE_INDICATOR = "none";
    private boolean isInherited;
    private boolean isNone;
    private final SVGDataProvider dataProvider;

    public SVGCssContentTypeBase(TValue defaultValue, SVGDataProvider dataProvider) {
        super(defaultValue);
        this.dataProvider = dataProvider;
    }

    public boolean getIsInherited() {
        return this.isInherited;
    }

    public boolean getIsNone() {
        return this.isNone;
    }

    public SVGDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected abstract Pair<TValue, TUnit> getValueAndUnit(String var1);

    @Override
    public final void parseCssText(String cssText) {
        Pair<TValue, TUnit> data;
        this.isInherited = INHERIT_INDICATOR.equals(cssText);
        this.isNone = NONE_INDICATOR.equals(cssText);
        if (!this.isInherited && !this.isNone && (data = this.getValueAndUnit(cssText)) != null) {
            this.value = data.getKey();
            this.unit = data.getValue();
        }
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.isNone) ^ Boolean.hashCode(this.isInherited) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (result && obj instanceof SVGCssContentTypeBase) {
            SVGCssContentTypeBase base = (SVGCssContentTypeBase)obj;
            result = this.isNone == base.isNone && this.isInherited == base.isInherited;
        }
        return result;
    }
}

