/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.svgfx.core;

import de.saxsys.svgfx.core.css.SVGCssStyle;
import de.saxsys.svgfx.core.elements.SVGElementBase;
import de.saxsys.svgfx.core.utils.StringUtils;
import de.saxsys.svgfx.xml.core.IDataProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SVGDataProvider
implements IDataProvider {
    final Map<String, SVGElementBase> data = new HashMap<String, SVGElementBase>();
    final Set<SVGCssStyle> styles = new HashSet<SVGCssStyle>();

    public final Map<String, SVGElementBase> getUnmodifiableData() {
        return Collections.unmodifiableMap(this.data);
    }

    public final Set<SVGCssStyle> getStyles() {
        return this.styles;
    }

    public final boolean hasData(String key) {
        return this.data.get(key) != null;
    }

    public final void setData(String key, SVGElementBase data) {
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("given key must not be null or empty");
        }
        if (data == null) {
            throw new IllegalArgumentException("given data must not be null");
        }
        this.data.put(key, data);
    }

    public final <TData extends SVGElementBase> TData getData(Class<TData> clazz, String key) {
        if (clazz == null) {
            throw new IllegalArgumentException("given class must not be null or empty");
        }
        if (StringUtils.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("given key must not be null or empty");
        }
        SVGElementBase data = this.data.get(key);
        if (data != null && clazz.isAssignableFrom(data.getClass())) {
            return (TData)((SVGElementBase)clazz.cast(data));
        }
        return null;
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.styles.clear();
    }
}

