/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.BeanSetPropertyField;
import de.saxsys.mvvmfx.utils.mapping.PropertyField;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.SetPropertyAccessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;

class FxSetPropertyField<M, E, T extends ObservableSet<E>, R extends Property<T>>
implements PropertyField<T, M, R> {
    private Set<E> defaultValue;
    private final SetPropertyAccessor<M, E> accessor;
    private final SetProperty<E> targetProperty;

    public FxSetPropertyField(SideEffect updateFunction, SetPropertyAccessor<M, E> accessor, Supplier<SetProperty<E>> propertySupplier) {
        this(updateFunction, accessor, propertySupplier, Collections.emptySet());
    }

    public FxSetPropertyField(SideEffect updateFunction, SetPropertyAccessor<M, E> accessor, Supplier<SetProperty<E>> propertySupplier, Set<E> defaultValue) {
        this.accessor = accessor;
        this.defaultValue = defaultValue;
        this.targetProperty = propertySupplier.get();
        this.targetProperty.setValue(FXCollections.observableSet(new HashSet()));
        this.targetProperty.addListener(change -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
        BeanSetPropertyField.setAll(this.accessor.apply(wrappedObject), this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        BeanSetPropertyField.setAll(this.targetProperty, this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public void resetToDefault() {
        BeanSetPropertyField.setAll(this.targetProperty, this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = new HashSet(this.accessor.apply(wrappedObject).getValue());
    }

    @Override
    public R getProperty() {
        return (R)this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        SetProperty<E> wrapperValue;
        ObservableSet modelValue = this.accessor.apply(wrappedObject).getValue();
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty);
    }
}

