/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.Context;
import de.saxsys.mvvmfx.Initialize;
import de.saxsys.mvvmfx.InjectContext;
import de.saxsys.mvvmfx.InjectScope;
import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.SceneLifecycle;
import de.saxsys.mvvmfx.Scope;
import de.saxsys.mvvmfx.ScopeProvider;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.internal.ContextImpl;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.PreventGarbageCollectionStore;
import de.saxsys.mvvmfx.internal.viewloader.ReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.View;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableBooleanValue;
import net.jodah.typetools.TypeResolver;

public class ViewLoaderReflectionUtils {
    public static Optional<Field> getViewModelField(Class<? extends View> viewType, Class<?> viewModelType) {
        List<Field> allViewModelFields = ViewLoaderReflectionUtils.getViewModelFields(viewType);
        if (allViewModelFields.isEmpty()) {
            return Optional.empty();
        }
        if (allViewModelFields.size() > 1) {
            throw new RuntimeException("The View <" + viewType + "> may only define one viewModel but there were <" + allViewModelFields.size() + "> viewModel fields with the @InjectViewModel annotation!");
        }
        Field field = allViewModelFields.get(0);
        if (!ViewModel.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("The View <" + viewType + "> has a field annotated with @InjectViewModel but the type of the field doesn't implement the 'ViewModel' interface!");
        }
        if (!field.getType().isAssignableFrom(viewModelType)) {
            throw new RuntimeException("The View <" + viewType + "> has a field annotated with @InjectViewModel but the type of the field doesn't match the generic ViewModel type of the View class. The declared generic type is <" + viewModelType + "> but the actual type of the field is <" + field.getType() + ">.");
        }
        return Optional.of(field);
    }

    public static List<Field> getScopeFields(Class<?> viewModelType) {
        List<Field> allScopeFields = ViewLoaderReflectionUtils.getFieldsWithAnnotation(viewModelType, InjectScope.class);
        allScopeFields.stream().forEach(field -> {
            if (!Scope.class.isAssignableFrom(field.getType())) {
                throw new RuntimeException("The ViewModel <" + viewModelType + "> has a field annotated with @InjectScope but the type of the field doesn't implement the 'Scope' interface!");
            }
        });
        return allScopeFields;
    }

    private static Optional<Field> getContextField(Class<? extends View> viewType) {
        List<Field> allViewModelFields = ViewLoaderReflectionUtils.getContextFields(viewType);
        if (allViewModelFields.isEmpty()) {
            return Optional.empty();
        }
        if (allViewModelFields.size() > 1) {
            throw new RuntimeException("The View <" + viewType + "> may only define one Context but there were <" + allViewModelFields.size() + "> Context fields with the @InjectContext annotation!");
        }
        Field field = allViewModelFields.get(0);
        if (!field.getType().isAssignableFrom(Context.class)) {
            throw new RuntimeException("The View <" + viewType + "> has a field annotated with @InjectContext but the type of the field doesn't match the type Context. The actual type of the field is <" + field.getType() + ">.");
        }
        return Optional.of(field);
    }

    private static List<Field> getContextFields(Class<? extends View> viewType) {
        return ViewLoaderReflectionUtils.getFieldsWithAnnotation(viewType, InjectContext.class);
    }

    public static List<Field> getViewModelFields(Class<? extends View> viewType) {
        return ViewLoaderReflectionUtils.getFieldsWithAnnotation(viewType, InjectViewModel.class);
    }

    private static <T, A extends Annotation> List<Field> getFieldsWithAnnotation(Class<T> classType, Class<A> annotationType) {
        return ReflectionUtils.getFieldsFromClassHierarchy(classType).stream().filter(field -> field.isAnnotationPresent(annotationType)).collect(Collectors.toList());
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType getExistingViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            return (ViewModelType)ReflectionUtils.accessMember((AccessibleObject)field, () -> (ViewModel)field.get(view), "Can't get the viewModel of type <" + viewModelType + ">");
        }
        return null;
    }

    public static void injectViewModel(View view, ViewModel viewModel) {
        if (viewModel == null) {
            return;
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModel.getClass());
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            ReflectionUtils.accessMember((AccessibleObject)field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel == null) {
                    field.set(view, viewModel);
                }
            }, "Can't inject ViewModel of type <" + viewModel.getClass() + "> into the view <" + view + ">");
        }
    }

    public static <V extends View<? extends VM>, VM extends ViewModel> void createAndInjectViewModel(V view, Consumer<ViewModel> newVmConsumer) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            List<Field> viewModelFields = ViewLoaderReflectionUtils.getViewModelFields(view.getClass());
            if (!viewModelFields.isEmpty()) {
                throw new RuntimeException("The given view of type <" + view.getClass() + "> has no generic viewModel type declared but tries to inject a viewModel.");
            }
            return;
        }
        if (viewModelType == TypeResolver.Unknown.class) {
            return;
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            ReflectionUtils.accessMember((AccessibleObject)field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel == null) {
                    Object newViewModel = DependencyInjector.getInstance().getInstanceOf(viewModelType);
                    field.set(view, newViewModel);
                    newVmConsumer.accept((ViewModel)newViewModel);
                }
            }, "Can't inject ViewModel of type <" + viewModelType + "> into the view <" + view + ">");
        }
    }

    static void createAndInjectScopes(Object viewModel, ContextImpl context) {
        Class<?> viewModelClass = viewModel.getClass();
        for (Annotation annotation : viewModelClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAssignableFrom(ScopeProvider.class)) continue;
            ScopeProvider provider = (ScopeProvider)annotation;
            Class<? extends Scope>[] scopes = ViewLoaderReflectionUtils.getScopesFromProvider(provider, viewModelClass);
            for (int i = 0; i < scopes.length; ++i) {
                Class<? extends Scope> scopeType = scopes[i];
                context.addScopeToContext(DependencyInjector.getInstance().getInstanceOf(scopeType));
            }
        }
        List<Field> scopeFields = ViewLoaderReflectionUtils.getScopeFields(viewModel.getClass());
        scopeFields.forEach(scopeField -> ReflectionUtils.accessMember((AccessibleObject)scopeField, () -> ViewLoaderReflectionUtils.injectScopeIntoField(scopeField, viewModel, context), "Can't inject Scope into ViewModel <" + viewModel.getClass() + ">"));
    }

    private static Class<? extends Scope>[] getScopesFromProvider(ScopeProvider scopeProvider, Class<?> aViewModelClass) {
        Class<? extends Scope>[] scopes = scopeProvider.value();
        if (scopes.length == 0) {
            scopes = scopeProvider.scopes();
        }
        if (scopes.length == 0) {
            String message = String.format("The scope provider '%s' has to provide at least one scope.", aViewModelClass.getCanonicalName());
            throw new IllegalArgumentException(message);
        }
        return scopes;
    }

    public static void injectContext(View codeBehind, ContextImpl context) {
        Optional<Field> contextField = ViewLoaderReflectionUtils.getContextField(codeBehind.getClass());
        if (contextField.isPresent()) {
            Field field = contextField.get();
            ReflectionUtils.accessMember((AccessibleObject)field, () -> field.set(codeBehind, context), "Can't inject Context into the view <" + codeBehind + ">");
        }
    }

    static Object injectScopeIntoField(Field scopeField, Object viewModel, ContextImpl context) throws IllegalAccessException {
        Class<?> scopeType = scopeField.getType();
        InjectScope[] annotations = (InjectScope[])scopeField.getAnnotationsByType(InjectScope.class);
        if (annotations.length != 1) {
            throw new RuntimeException("A field to inject a Scope into should have exactly one @InjectScope annotation but the viewModel <" + viewModel + "> has a field that violates this rule.");
        }
        Object newScope = context.getScope(scopeType);
        if (newScope == null) {
            throw new IllegalStateException("A scope was requested but no @ScopeProvider found in the hierarchy. Declare it like this: @ScopeProvider(" + scopeType.getName() + ".class )");
        }
        if (!newScope.getClass().equals(scopeType)) {
            throw new IllegalStateException("something went wrong...");
        }
        scopeField.set(viewModel, newScope);
        return newScope;
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType createViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            return null;
        }
        if (TypeResolver.Unknown.class == viewModelType) {
            return null;
        }
        return (ViewModelType)((ViewModel)DependencyInjector.getInstance().getInstanceOf(viewModelType));
    }

    public static <ViewModelType extends ViewModel> void initializeViewModel(ViewModelType viewModel) {
        if (viewModel == null) {
            return;
        }
        Collection<Method> initializeMethods = ViewLoaderReflectionUtils.getInitializeMethods(viewModel.getClass());
        initializeMethods.forEach(initMethod -> {
            boolean postConstructPresent = Arrays.stream(initMethod.getAnnotations()).map(Annotation::annotationType).map(Class::getName).anyMatch("javax.annotation.PostConstruct"::equals);
            if (postConstructPresent) {
                throw new IllegalStateException(String.format("initialize method of ViewModel [%s] is annotated with @PostConstruct. This will lead to unexpected behaviour and duplicate initialization. Please rename the method or remove the @PostConstruct annotation. See mvvmFX wiki for more details: https://github.com/sialcasa/mvvmFX/wiki/Dependency-Injection#lifecycle-postconstruct", viewModel));
            }
            ReflectionUtils.accessMember((AccessibleObject)initMethod, () -> initMethod.invoke((Object)viewModel, new Object[0]), "mvvmFX wasn't able to call the initialize method of ViewModel [" + viewModel + "].");
        });
    }

    private static Collection<Method> getInitializeMethods(Class<?> classType) {
        ArrayList<Method> initializeMethods = new ArrayList<Method>();
        Arrays.stream(classType.getMethods()).filter(method -> "initialize".equals(method.getName())).filter(method -> Void.TYPE.equals(method.getReturnType())).filter(method -> method.getParameterCount() == 0).forEach(initializeMethods::add);
        Arrays.stream(classType.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Initialize.class)).forEach(initializeMethods::add);
        return initializeMethods;
    }

    static void addSceneLifecycleHooks(ViewModel viewModel, ObservableBooleanValue viewInSceneProperty) {
        if (viewModel != null && viewModel instanceof SceneLifecycle) {
            SceneLifecycle lifecycleViewModel = (SceneLifecycle)((Object)viewModel);
            PreventGarbageCollectionStore.getInstance().put(viewInSceneProperty);
            viewInSceneProperty.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    lifecycleViewModel.onViewAdded();
                } else {
                    lifecycleViewModel.onViewRemoved();
                    PreventGarbageCollectionStore.getInstance().remove(viewInSceneProperty);
                }
            });
        }
    }

    static void checkScopesInView(View codeBehind) {
        List<Field> scopeFields = ReflectionUtils.getFieldsWithAnnotation(codeBehind, InjectScope.class);
        if (!scopeFields.isEmpty()) {
            throw new IllegalStateException("The view class [" + codeBehind.getClass().getSimpleName() + "] tries to inject a Scope with @InjectScope. This would be a violation of the mvvm pattern. Scopes are only supported in ViewModels.");
        }
    }
}

