/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.bytez.malloc;

import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import jdk.incubator.foreign.MemorySegment;
import org.nustaq.offheap.bytez.malloc.MemoryBytez;

public class MMFBytez
extends MemoryBytez {
    private File file;

    public MMFBytez(String filePath, long length, boolean clearFile) throws Exception {
        this.init(filePath, length, clearFile);
    }

    protected void init(String file, long length, boolean clearFile) throws Exception {
        File f = new File(file);
        if (f.exists() && clearFile) {
            f.delete();
        }
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            f.createNewFile();
        }
        this.memseg = MemorySegment.mapFromPath((Path)f.toPath(), (long)length, (FileChannel.MapMode)FileChannel.MapMode.READ_WRITE);
        this.file = f;
    }

    public void freeAndClose() {
        this.memseg.close();
    }

    public File getFile() {
        return this.file;
    }
}

