/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.serializers;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.nustaq.serialization.FSTBasicObjectSerializer;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTObjectInput;
import org.nustaq.serialization.FSTObjectOutput;

public class FSTThrowableSerializer
extends FSTBasicObjectSerializer {
    @Override
    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        Throwable t = (Throwable)toWrite;
        out.writeStringUTF(t.getMessage() != null ? t.getMessage() : "null");
        StackTraceElement[] ste = t.getStackTrace();
        out.writeObject(ste);
        out.writeObject(t.getCause());
        out.writeObject(t.getSuppressed());
    }

    @Override
    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPosition) throws Exception {
        Throwable[] suppressed;
        Constructor constructor = objectClass.getConstructor(String.class);
        Throwable t = (Throwable)constructor.newInstance(in.readStringUTF());
        StackTraceElement[] ste = (StackTraceElement[])in.readObject();
        if (ste != null) {
            t.setStackTrace(ste);
        }
        t.initCause((Throwable)in.readObject());
        for (Throwable s : suppressed = (Throwable[])in.readObject()) {
            t.addSuppressed(s);
        }
        return t;
    }
}

