/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.nustaq.offheap.structs.Align;
import org.nustaq.serialization.FSTClassInstantiator;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.annotations.AnonymousTransient;
import org.nustaq.serialization.annotations.Conditional;
import org.nustaq.serialization.annotations.Flat;
import org.nustaq.serialization.annotations.OneOf;
import org.nustaq.serialization.annotations.Predict;
import org.nustaq.serialization.annotations.Serialize;
import org.nustaq.serialization.annotations.Transient;
import org.nustaq.serialization.annotations.Version;
import org.nustaq.serialization.util.FSTMap;
import org.nustaq.serialization.util.FSTUtil;

public final class FSTClazzInfo {
    public static boolean BufferConstructorMeta = true;
    public static boolean BufferFieldMeta = true;
    public static ConcurrentHashMap<Class, Field[]> sharedFieldSets = new ConcurrentHashMap();
    public static final Comparator<FSTFieldInfo> defFieldComparator = new Comparator<FSTFieldInfo>(){

        @Override
        public int compare(FSTFieldInfo o1, FSTFieldInfo o2) {
            int res = 0;
            if (o1.getVersion() != o2.getVersion()) {
                return o1.getVersion() < o2.getVersion() ? -1 : 1;
            }
            if (o1.getType() == Boolean.TYPE && o2.getType() != Boolean.TYPE) {
                return -1;
            }
            if (o1.getType() != Boolean.TYPE && o2.getType() == Boolean.TYPE) {
                return 1;
            }
            if (o1.isConditional() && !o2.isConditional()) {
                res = 1;
            } else if (!o1.isConditional() && o2.isConditional()) {
                res = -1;
            } else if (o1.isPrimitive() && !o2.isPrimitive()) {
                res = -1;
            } else if (!o1.isPrimitive() && o2.isPrimitive()) {
                res = 1;
            }
            if (res == 0) {
                res = o1.getType().getSimpleName().compareTo(o2.getType().getSimpleName());
            }
            if (res == 0) {
                res = o1.getName().compareTo(o2.getName());
            }
            if (res == 0) {
                return o1.getField().getDeclaringClass().getName().compareTo(o2.getField().getDeclaringClass().getName());
            }
            return res;
        }
    };
    Class[] predict;
    private boolean ignoreAnn;
    FSTMap<String, FSTFieldInfo> fieldMap;
    Method writeReplaceMethod;
    Method readResolveMethod;
    FSTMap<Class, FSTCompatibilityInfo> compInfo;
    Object decoderAttached;
    boolean requiresCompatibleMode;
    boolean externalizable;
    boolean flat;
    boolean isAsciiNameShortString = false;
    boolean requiresInit = false;
    boolean hasTransient;
    FSTObjectSerializer ser;
    FSTFieldInfo[] fieldInfo;
    Class clazz;
    Object[] enumConstants;
    Constructor cons;
    int clzId = -1;
    int structSize = 0;
    FSTConfiguration conf;
    protected FSTClassInstantiator instantiator;
    boolean crossPlatform;
    byte[] bufferedName;
    static AtomicInteger fiCount = new AtomicInteger(0);
    static AtomicInteger missCount = new AtomicInteger(0);

    public Object getDecoderAttached() {
        return this.decoderAttached;
    }

    public void setDecoderAttached(Object decoderAttached) {
        this.decoderAttached = decoderAttached;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSTClazzInfo(FSTConfiguration conf, Class clazz, FSTClazzInfoRegistry infoRegistry, boolean ignoreAnnotations) {
        String name;
        this.conf = conf;
        this.crossPlatform = conf.isCrossPlatform();
        this.clazz = clazz;
        this.enumConstants = clazz.getEnumConstants();
        this.ignoreAnn = ignoreAnnotations;
        this.createFields(clazz);
        this.instantiator = conf.getInstantiator(clazz);
        if (Externalizable.class.isAssignableFrom(clazz)) {
            this.externalizable = true;
            this.cons = this.instantiator.findConstructorForExternalize(clazz);
        } else if (Serializable.class.isAssignableFrom(clazz) || clazz == Object.class) {
            this.externalizable = false;
            this.cons = this.instantiator.findConstructorForSerializable(clazz);
        } else if (!conf.isStructMode()) {
            if (!conf.isForceSerializable() && this.getSer() == null) throw new RuntimeException("Class " + clazz.getName() + " does not implement Serializable or externalizable");
            this.externalizable = false;
            this.cons = this.instantiator.findConstructorForSerializable(clazz);
        } else {
            this.cons = this.instantiator.findConstructorForSerializable(clazz);
        }
        if (!ignoreAnnotations) {
            Predict annotation = clazz.getAnnotation(Predict.class);
            if (annotation != null) {
                this.predict = annotation.value();
            }
            this.flat = clazz.isAnnotationPresent(Flat.class);
        }
        if (this.cons != null) {
            this.cons.setAccessible(true);
        }
        if ((name = clazz.getName()).length() < 127) {
            this.isAsciiNameShortString = true;
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) <= '\u007f') continue;
                this.isAsciiNameShortString = false;
                break;
            }
        }
        boolean bl = this.requiresInit = this.isExternalizable() || this.useCompatibleMode() || this.hasTransient || conf.isForceClzInit();
        if (!this.useCompatibleMode() || !this.crossPlatform || this.getSer() != null || clazz.isEnum()) return;
        throw new RuntimeException("cannot support legacy JDK serialization methods in crossplatform mode. Define a serializer for this class " + clazz.getName());
    }

    public byte[] getBufferedName() {
        if (this.bufferedName == null) {
            this.bufferedName = this.getClazz().getName().getBytes();
        }
        return this.bufferedName;
    }

    public String toString() {
        return "FSTClazzInfo{clazz=" + this.clazz + '}';
    }

    public boolean isAsciiNameShortString() {
        return this.isAsciiNameShortString;
    }

    public int getClzId() {
        return this.clzId;
    }

    public void setClzId(int clzId) {
        this.clzId = clzId;
    }

    public int getNumBoolFields() {
        FSTFieldInfo[] fis = this.getFieldInfo();
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fstFieldInfo = fis[i];
            if (fstFieldInfo.getType() == Boolean.TYPE) continue;
            return i;
        }
        return fis.length;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public final boolean isFlat() {
        return this.flat;
    }

    public final Class[] getPredict() {
        return this.predict;
    }

    public final Object newInstance(boolean doesRequireInit) {
        return this.instantiator.newInstance(this.clazz, this.cons, doesRequireInit || this.requiresInit, this.conf.isForceSerializable());
    }

    public final List<Field> getAllFields(Class c, List<Field> res) {
        Field field;
        int i;
        Field[] declaredFields;
        if (res == null) {
            res = new ArrayList<Field>();
        }
        if (c == null) {
            return res;
        }
        Field[] fieldArray = declaredFields = BufferFieldMeta ? sharedFieldSets.get(c) : null;
        if (declaredFields == null) {
            declaredFields = c.getDeclaredFields();
            if (BufferFieldMeta) {
                sharedFieldSets.put(c, declaredFields);
            }
        }
        List<Field> c1 = Arrays.asList(declaredFields);
        Collections.reverse(c1);
        for (i = 0; i < c1.size(); ++i) {
            field = c1.get(i);
            res.add(0, field);
        }
        for (i = 0; i < res.size(); ++i) {
            field = res.get(i);
            if (!Modifier.isStatic(field.getModifiers()) && !this.isTransient(c, field)) continue;
            if (this.isTransient(c, field)) {
                this.hasTransient = true;
            }
            res.remove(i);
            --i;
        }
        List<Field> allFields = this.getAllFields(c.getSuperclass(), res);
        return new ArrayList<Field>(allFields);
    }

    private boolean isTransient(Class c, Field field) {
        if (Modifier.isTransient(field.getModifiers())) {
            return true;
        }
        while (c.getName().indexOf("$") >= 0) {
            c = c.getSuperclass();
        }
        if (field.getName().startsWith("this$") && c.getAnnotation(AnonymousTransient.class) != null) {
            return true;
        }
        return c.getAnnotation(Transient.class) != null && field.getAnnotation(Serialize.class) == null;
    }

    public final FSTFieldInfo[] getFieldInfo() {
        return this.fieldInfo;
    }

    public final FSTFieldInfo[] getFieldInfoFiltered(Class ... toRemove) {
        FSTFieldInfo[] fis = this.getFieldInfo();
        int count = 0;
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fi = fis[i];
            boolean skip = false;
            for (int j = 0; j < toRemove.length; ++j) {
                Class aClass = toRemove[j];
                if (fi.getField().getDeclaringClass() != aClass) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            ++count;
        }
        FSTFieldInfo[] res = new FSTFieldInfo[count];
        count = 0;
        for (int i = 0; i < fis.length; ++i) {
            FSTFieldInfo fi = fis[i];
            boolean skip = false;
            for (int j = 0; j < toRemove.length; ++j) {
                Class aClass = toRemove[j];
                if (fi.getField().getDeclaringClass() != aClass) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            res[count++] = fis[i];
        }
        return res;
    }

    public final FSTFieldInfo getFieldInfo(String name, Class declaringClass) {
        if (this.fieldMap == null) {
            this.buildFieldMap();
        }
        if (declaringClass == null) {
            return this.fieldMap.get(name);
        }
        return this.fieldMap.get(declaringClass.getName() + "#" + name);
    }

    private void buildFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new FSTMap(this.fieldInfo.length);
            for (int i = 0; i < this.fieldInfo.length; ++i) {
                Field field = this.fieldInfo[i].getField();
                if (field == null) continue;
                this.fieldMap.put(field.getDeclaringClass().getName() + "#" + field.getName(), this.fieldInfo[i]);
                this.fieldMap.put(field.getName(), this.fieldInfo[i]);
            }
        }
    }

    private void createFields(Class c) {
        FSTFieldInfo fstFieldInfo;
        int i;
        if (c.isInterface() || c.isPrimitive()) {
            return;
        }
        List<Field> fields = this.getAllFields(c, null);
        this.fieldInfo = new FSTFieldInfo[fields.size()];
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            Field field = fields.get(i2);
            this.fieldInfo[i2] = this.createFieldInfo(field);
        }
        Comparator<FSTFieldInfo> infocomp = new Comparator<FSTFieldInfo>(){

            @Override
            public int compare(FSTFieldInfo o1, FSTFieldInfo o2) {
                int res = 0;
                res = o1.getType().getSimpleName().compareTo(o2.getType().getSimpleName());
                if (res == 0) {
                    res = o1.getType().getName().compareTo(o2.getType().getName());
                }
                if (res == 0) {
                    Class<?> declaringClass = o1.getType().getDeclaringClass();
                    Class<?> declaringClass1 = o2.getType().getDeclaringClass();
                    if (declaringClass == null && declaringClass1 == null) {
                        return 0;
                    }
                    if (declaringClass != null && declaringClass1 == null) {
                        return 1;
                    }
                    if (declaringClass == null && declaringClass1 != null) {
                        return -1;
                    }
                    if (res == 0) {
                        return declaringClass.getName().compareTo(declaringClass1.getName());
                    }
                }
                return res;
            }
        };
        boolean requiresCompatibilityData = false;
        if (!Externalizable.class.isAssignableFrom(c) && this.getSerNoStore() == null) {
            for (Class tmpCls = c; tmpCls != Object.class; tmpCls = tmpCls.getSuperclass()) {
                if (FSTUtil.findPrivateMethod(tmpCls, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE) == null && FSTUtil.findPrivateMethod(tmpCls, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE) == null && FSTUtil.findDerivedMethod(tmpCls, "writeReplace", null, Object.class) == null && FSTUtil.findDerivedMethod(tmpCls, "readResolve", null, Object.class) == null) continue;
                requiresCompatibilityData = true;
                break;
            }
        }
        if (!this.conf.isStructMode() && requiresCompatibilityData) {
            this.getCompInfo();
            this.buildFieldMap();
            fields.clear();
            for (Class curCl = c; curCl != Object.class; curCl = curCl.getSuperclass()) {
                ObjectStreamClass os = null;
                try {
                    os = ObjectStreamClass.lookup(curCl);
                }
                catch (Exception e) {
                    FSTUtil.rethrow(e);
                }
                if (os == null) continue;
                ObjectStreamField[] fi = os.getFields();
                ArrayList<FSTFieldInfo> curClzFields = new ArrayList<FSTFieldInfo>();
                if (fi != null) {
                    for (int i3 = 0; i3 < fi.length; ++i3) {
                        ObjectStreamField objectStreamField = fi[i3];
                        String ff = objectStreamField.getName();
                        FSTFieldInfo fstFieldInfo2 = this.fieldMap.get(curCl.getName() + "#" + ff);
                        if (fstFieldInfo2 != null && fstFieldInfo2.getField() != null) {
                            curClzFields.add(fstFieldInfo2);
                            fields.add(fstFieldInfo2.getField());
                            continue;
                        }
                        FSTFieldInfo fake = new FSTFieldInfo(null, null, true);
                        fake.type = objectStreamField.getType();
                        fake.fakeName = objectStreamField.getName();
                        curClzFields.add(fake);
                    }
                }
                Collections.sort(curClzFields, infocomp);
                FSTCompatibilityInfo info = new FSTCompatibilityInfo(curClzFields, curCl);
                this.getCompInfo().put(curCl, info);
                if (!info.needsCompatibleMode()) continue;
                this.requiresCompatibleMode = true;
            }
        }
        Comparator<FSTFieldInfo> comp = defFieldComparator;
        if (!this.conf.isStructMode()) {
            Arrays.sort(this.fieldInfo, comp);
        }
        int off = 8;
        for (i = 0; i < this.fieldInfo.length; ++i) {
            fstFieldInfo = this.fieldInfo[i];
            Align al = fstFieldInfo.getField().getAnnotation(Align.class);
            if (al != null) {
                fstFieldInfo.align = al.value();
                int alignOff = fstFieldInfo.align(off);
                fstFieldInfo.alignPad = alignOff - off;
                off = alignOff;
            }
            fstFieldInfo.setStructOffset(off);
            off += fstFieldInfo.getStructSize();
        }
        this.structSize = off;
        this.writeReplaceMethod = FSTUtil.findDerivedMethod(c, "writeReplace", null, Object.class);
        this.readResolveMethod = FSTUtil.findDerivedMethod(c, "readResolve", null, Object.class);
        if (this.writeReplaceMethod != null) {
            this.writeReplaceMethod.setAccessible(true);
        }
        if (this.readResolveMethod != null) {
            this.readResolveMethod.setAccessible(true);
        }
        i = 0;
        while (i < this.fieldInfo.length) {
            fstFieldInfo = this.fieldInfo[i];
            fstFieldInfo.indexId = i++;
        }
    }

    public int getStructSize() {
        return this.structSize;
    }

    public boolean useCompatibleMode() {
        return this.requiresCompatibleMode || this.writeReplaceMethod != null || this.readResolveMethod != null;
    }

    protected FSTFieldInfo createFieldInfo(Field field) {
        FSTFieldInfo res;
        FSTConfiguration.FieldKey key = null;
        if (this.conf.fieldInfoCache != null && (res = this.conf.fieldInfoCache.get(key = new FSTConfiguration.FieldKey(field.getDeclaringClass(), field.getName()))) != null) {
            fiCount.incrementAndGet();
            return res;
        }
        field.setAccessible(true);
        Predict predict = this.crossPlatform ? null : field.getAnnotation(Predict.class);
        FSTFieldInfo result = new FSTFieldInfo(predict != null ? predict.value() : null, field, this.ignoreAnn);
        if (this.conf.fieldInfoCache != null && key != null) {
            this.conf.fieldInfoCache.put(key, result);
        }
        missCount.incrementAndGet();
        return result;
    }

    public final Method getReadResolveMethod() {
        return this.readResolveMethod;
    }

    public final Method getWriteReplaceMethod() {
        return this.writeReplaceMethod;
    }

    public final Class getClazz() {
        return this.clazz;
    }

    public Object[] getEnumConstants() {
        return this.enumConstants;
    }

    public FSTMap<Class, FSTCompatibilityInfo> getCompInfo() {
        if (this.compInfo == null) {
            this.compInfo = new FSTMap(3);
        }
        return this.compInfo;
    }

    public FSTObjectSerializer getSer() {
        if (this.ser == null) {
            if (this.clazz == null) {
                return null;
            }
            this.ser = this.getSerNoStore();
            if (this.ser == null) {
                this.ser = FSTSerializerRegistry.NULL;
            }
        }
        if (this.ser == FSTSerializerRegistry.NULL) {
            return null;
        }
        return this.ser;
    }

    public FSTObjectSerializer getSerNoStore() {
        return this.conf.getCLInfoRegistry().getSerializerRegistry().getSerializer(this.clazz);
    }

    static class FSTCompatibilityInfo {
        Method writeMethod;
        Method readMethod;
        ObjectStreamClass objectStreamClass;
        List<FSTFieldInfo> infos;
        Class clazz;
        FSTFieldInfo[] infoArr;

        public FSTCompatibilityInfo(List<FSTFieldInfo> inf, Class c) {
            this.readClazz(c);
            this.infos = inf;
            this.clazz = c;
        }

        public List<FSTFieldInfo> getFields() {
            return this.infos;
        }

        public FSTFieldInfo[] getFieldArray() {
            if (this.infoArr == null) {
                List<FSTFieldInfo> fields = this.getFields();
                FSTFieldInfo[] fstFieldInfos = new FSTFieldInfo[fields.size()];
                fields.toArray(fstFieldInfos);
                Arrays.sort(fstFieldInfos, defFieldComparator);
                this.infoArr = fstFieldInfos;
            }
            return this.infoArr;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public boolean needsCompatibleMode() {
            return this.writeMethod != null || this.readMethod != null;
        }

        public void readClazz(Class c) {
            this.writeMethod = FSTUtil.findPrivateMethod(c, "writeObject", new Class[]{ObjectOutputStream.class}, Void.TYPE);
            this.readMethod = FSTUtil.findPrivateMethod(c, "readObject", new Class[]{ObjectInputStream.class}, Void.TYPE);
            if (this.writeMethod != null) {
                this.writeMethod.setAccessible(true);
            }
            if (this.readMethod != null) {
                this.readMethod.setAccessible(true);
            }
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public void setReadMethod(Method readMethod) {
            this.readMethod = readMethod;
        }

        public Method getWriteMethod() {
            return this.writeMethod;
        }

        public void setWriteMethod(Method writeMethod) {
            this.writeMethod = writeMethod;
        }

        public boolean isAsymmetric() {
            return this.getReadMethod() == null && this.getWriteMethod() != null || this.getWriteMethod() == null && this.getReadMethod() != null;
        }
    }

    public static final class FSTFieldInfo {
        public static final int BOOL = 1;
        public static final int BYTE = 2;
        public static final int CHAR = 3;
        public static final int SHORT = 4;
        public static final int INT = 5;
        public static final int LONG = 6;
        public static final int FLOAT = 7;
        public static final int DOUBLE = 8;
        Class[] possibleClasses;
        FSTClazzInfo lastInfo;
        String[] oneOf = null;
        int arrayDim;
        Class arrayType;
        boolean flat = false;
        boolean isConditional = false;
        final Field field;
        Class type;
        boolean integral = false;
        boolean primitive = false;
        boolean isArr = false;
        byte version;
        int integralType;
        long memOffset = -1L;
        boolean isAndroid = FSTConfiguration.isAndroid;
        int structOffset = 0;
        int indexId;
        int align = 0;
        int alignPad = 0;
        Object bufferedName;
        public String fakeName;

        public FSTFieldInfo(Class[] possibleClasses, Field fi, boolean ignoreAnnotations) {
            this.possibleClasses = possibleClasses;
            this.field = fi;
            if (fi == null) {
                this.isArr = false;
            } else {
                this.isArr = this.field.getType().isArray();
                this.type = fi.getType();
                this.primitive = this.type.isPrimitive();
                if (FSTUtil.unFlaggedUnsafe != null) {
                    fi.setAccessible(true);
                    if (!Modifier.isStatic(fi.getModifiers())) {
                        try {
                            this.memOffset = (int)FSTUtil.unFlaggedUnsafe.objectFieldOffset(fi);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.isArray()) {
                String clName = this.field.getType().getName();
                this.arrayDim = 1 + clName.lastIndexOf(91);
                this.arrayType = this.calcComponentType(this.field.getType());
            }
            this.calcIntegral();
            if (fi != null && !ignoreAnnotations) {
                OneOf annotation;
                this.version = fi.isAnnotationPresent(Version.class) ? fi.getAnnotation(Version.class).value() : (byte)0;
                this.flat = fi.isAnnotationPresent(Flat.class);
                this.isConditional = fi.isAnnotationPresent(Conditional.class);
                if (this.isIntegral()) {
                    this.isConditional = false;
                }
                if ((annotation = fi.getAnnotation(OneOf.class)) != null) {
                    this.oneOf = annotation.value();
                }
            }
        }

        public byte getVersion() {
            return this.version;
        }

        public Object getBufferedName() {
            return this.bufferedName;
        }

        public void setBufferedName(Object bufferedName) {
            this.bufferedName = bufferedName;
        }

        public int align(int off) {
            while (off / this.align * this.align != off) {
                ++off;
            }
            return off;
        }

        public int getIndexId() {
            return this.indexId;
        }

        public int getStructOffset() {
            return this.structOffset;
        }

        public void setStructOffset(int structOffset) {
            this.structOffset = structOffset;
        }

        public String[] getOneOf() {
            return this.oneOf;
        }

        public long getMemOffset() {
            return this.memOffset;
        }

        public int getAlign() {
            return this.align;
        }

        public int getAlignPad() {
            return this.alignPad;
        }

        public boolean isConditional() {
            return this.isConditional;
        }

        public FSTClazzInfo getLastInfo() {
            return this.lastInfo;
        }

        public void setLastInfo(FSTClazzInfo lastInfo) {
            this.lastInfo = lastInfo;
        }

        Class calcComponentType(Class c) {
            if (c.isArray()) {
                return this.calcComponentType(c.getComponentType());
            }
            return c;
        }

        public boolean isVolatile() {
            return Modifier.isVolatile(this.getField().getModifiers());
        }

        public final Class getType() {
            return this.type;
        }

        public boolean isArray() {
            return this.isArr;
        }

        public int getArrayDepth() {
            return this.arrayDim;
        }

        public Class getArrayType() {
            return this.arrayType;
        }

        public Class[] getPossibleClasses() {
            return this.possibleClasses;
        }

        void setPossibleClasses(Class[] possibleClasses) {
            this.possibleClasses = possibleClasses;
        }

        public Field getField() {
            return this.field;
        }

        public void calcIntegral() {
            if (this.field == null) {
                return;
            }
            if (this.isArray()) {
                this.integral = this.isIntegral(this.getArrayType());
            } else {
                this.integral = this.isIntegral(this.field.getType());
                Class<?> type = this.field.getType();
                this.integralType = FSTFieldInfo.getIntegralCode(type);
            }
        }

        public static int getIntegralCode(Class type) {
            if (type == Boolean.TYPE) {
                return 1;
            }
            if (type == Byte.TYPE) {
                return 2;
            }
            if (type == Character.TYPE) {
                return 3;
            }
            if (type == Short.TYPE) {
                return 4;
            }
            if (type == Integer.TYPE) {
                return 5;
            }
            if (type == Long.TYPE) {
                return 6;
            }
            if (type == Float.TYPE) {
                return 7;
            }
            if (type == Double.TYPE) {
                return 8;
            }
            return 0;
        }

        public int getIntegralType() {
            return this.integralType;
        }

        public boolean isIntegral(Class type) {
            return type.isPrimitive();
        }

        public boolean isIntegral() {
            return this.integral;
        }

        public String getDesc() {
            return this.field != null ? "<" + this.field.getName() + " of " + this.field.getDeclaringClass().getSimpleName() + ">" : "<undefined referencee>";
        }

        public String toString() {
            return this.getDesc();
        }

        public boolean isFlat() {
            return this.flat;
        }

        public int getComponentStructSize() {
            if (this.arrayType == Boolean.TYPE || this.arrayType == Byte.TYPE) {
                return 1;
            }
            if (this.arrayType == Character.TYPE || this.arrayType == Short.TYPE) {
                return 2;
            }
            if (this.arrayType == Integer.TYPE || this.arrayType == Float.TYPE) {
                return 4;
            }
            if (this.arrayType == Long.TYPE || this.arrayType == Double.TYPE) {
                return 8;
            }
            return 0;
        }

        public int getStructSize() {
            if (this.type == Boolean.TYPE || this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE || this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE || this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE || this.type == Double.TYPE) {
                return 8;
            }
            if (this.isArray()) {
                if (this.isIntegral()) {
                    return 8;
                }
                return 16;
            }
            return 4;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public final int getByteValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getByte(obj, this.memOffset);
            }
            return this.field.getByte(obj);
        }

        public final int getCharValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getChar(obj, this.memOffset);
            }
            return this.field.getChar(obj);
        }

        public final int getShortValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getShort(obj, this.memOffset);
            }
            return this.field.getShort(obj);
        }

        public final int getIntValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unFlaggedUnsafe.getInt(obj, this.memOffset);
        }

        public final long getLongValueUnsafe(Object obj) throws IllegalAccessException {
            return FSTUtil.unFlaggedUnsafe.getLong(obj, this.memOffset);
        }

        public final boolean getBooleanValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getBoolean(obj, this.memOffset);
            }
            return this.field.getBoolean(obj);
        }

        public final Object getObjectValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getObject(obj, this.memOffset);
            }
            return this.field.get(obj);
        }

        public final float getFloatValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getFloat(obj, this.memOffset);
            }
            return this.field.getFloat(obj);
        }

        public final void setCharValue(Object newObj, char c) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putChar(newObj, this.memOffset, c);
                return;
            }
            this.field.setChar(newObj, c);
        }

        public final void setShortValue(Object newObj, short i1) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putShort(newObj, this.memOffset, i1);
                return;
            }
            this.field.setShort(newObj, i1);
        }

        public final void setObjectValue(Object target, Object value) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putObject(target, this.memOffset, value);
                return;
            }
            this.field.set(target, value);
        }

        public final void setFloatValue(Object newObj, float l) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putFloat(newObj, this.memOffset, l);
                return;
            }
            this.field.setFloat(newObj, l);
        }

        public final void setDoubleValue(Object newObj, double l) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putDouble(newObj, this.memOffset, l);
                return;
            }
            this.field.setDouble(newObj, l);
        }

        public final void setLongValue(Object newObj, long i1) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putLong(newObj, this.memOffset, i1);
                return;
            }
            this.field.setLong(newObj, i1);
        }

        public final long getLongValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getLong(obj, this.memOffset);
            }
            return this.field.getLong(obj);
        }

        public final double getDoubleValue(Object obj) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getDouble(obj, this.memOffset);
            }
            return this.field.getDouble(obj);
        }

        public final void setIntValue(Object newObj, int i1) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putInt(newObj, this.memOffset, i1);
                return;
            }
            this.field.setInt(newObj, i1);
        }

        public final int getIntValue(Object obj) throws IllegalAccessException {
            if (this.memOffset >= 0L) {
                return FSTUtil.unFlaggedUnsafe.getInt(obj, this.memOffset);
            }
            return this.field.getInt(obj);
        }

        public final void setBooleanValue(Object newObj, boolean i1) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putBoolean(newObj, this.memOffset, i1);
                return;
            }
            this.field.setBoolean(newObj, i1);
        }

        public final void setByteValue(Object newObj, byte b) throws IllegalAccessException {
            if (!this.isAndroid && this.memOffset >= 0L) {
                FSTUtil.unFlaggedUnsafe.putByte(newObj, this.memOffset, b);
                return;
            }
            this.field.setByte(newObj, b);
        }

        public String getName() {
            return this.field != null ? this.field.getName() : this.fakeName;
        }
    }
}

