/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap;

import org.nustaq.offheap.FSTCodedOffheapMap;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.bytesource.ByteArrayByteSource;
import org.nustaq.offheap.bytez.bytesource.BytezByteSource;
import org.nustaq.serialization.simpleapi.FSTBufferTooSmallException;
import org.nustaq.serialization.simpleapi.FSTCoder;
import org.nustaq.serialization.util.FSTUtil;

public abstract class FSTSerializedOffheapMap<K, V>
extends FSTCodedOffheapMap<K, V> {
    protected ByteArrayByteSource tmpVal;
    FSTCoder coder;
    protected byte[] buffer = new byte[2048];

    public FSTSerializedOffheapMap(int keyLen, long sizeBytes, int numberOfElems, FSTCoder coder) {
        super(keyLen, sizeBytes, numberOfElems);
        this.coder = coder;
        this.tmpVal = new ByteArrayByteSource(this.buffer);
    }

    public FSTSerializedOffheapMap(String mappedFile, int keyLen, long sizeMemBytes, int numberOfElems, FSTCoder coder) throws Exception {
        super(mappedFile, keyLen, sizeMemBytes, numberOfElems);
        this.coder = coder;
        this.tmpVal = new ByteArrayByteSource(this.buffer);
    }

    @Override
    public ByteSource encodeValue(V value) {
        try {
            int len = this.coder.toByteArray(value, this.buffer, 0, this.buffer.length);
            this.tmpVal.setLen(len);
        }
        catch (FSTBufferTooSmallException bts) {
            this.buffer = new byte[this.buffer.length * 2];
            this.tmpVal.setArr(this.buffer);
            this.tmpVal.setOff(0);
            this.tmpVal.setLen(this.buffer.length);
            return this.encodeValue(value);
        }
        catch (Exception e) {
            FSTUtil.rethrow(e);
        }
        return this.tmpVal;
    }

    @Override
    protected int getEntryLengthForContentLength(long lengthOfEntry) {
        return (int)(lengthOfEntry * 2L);
    }

    @Override
    public V decodeValue(BytezByteSource val) {
        while (val.getLen() > this.buffer.length) {
            this.buffer = new byte[this.buffer.length * 2];
            this.tmpVal.setArr(this.buffer);
            this.tmpVal.setOff(0);
            this.tmpVal.setLen(this.buffer.length);
        }
        this.memory.getArr(val.getOff(), this.buffer, 0, val.getLen());
        return (V)this.coder.toObject(this.buffer);
    }

    public FSTCoder getCoder() {
        return this.coder;
    }
}

