/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTSerializerRegistry;
import org.nustaq.serialization.FSTSerializerRegistryDelegate;
import org.nustaq.serialization.util.FSTMap;

public class FSTClazzInfoRegistry {
    FSTMap mInfos = new FSTMap(97);
    FSTSerializerRegistry serializerRegistry = new FSTSerializerRegistry();
    boolean ignoreAnnotations = false;
    final AtomicBoolean rwLock = new AtomicBoolean(false);
    private boolean structMode = false;
    FSTConfiguration conf;

    public static void addAllReferencedClasses(Class cl, ArrayList<String> names, String filter) {
        HashSet<String> names1 = new HashSet<String>();
        FSTClazzInfoRegistry.addAllReferencedClasses(cl, names1, new HashSet<String>(), filter);
        names.addAll(names1);
    }

    static void addAllReferencedClasses(Class cl, HashSet<String> names, HashSet<String> topLevelDone, String filter) {
        if (cl == null || topLevelDone.contains(cl.getName()) || !cl.getName().startsWith(filter)) {
            return;
        }
        topLevelDone.add(cl.getName());
        Field[] declaredFields = cl.getDeclaredFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            Field declaredField = declaredFields[i];
            Class<?> type = declaredField.getType();
            if (type.isPrimitive() || type.isArray()) continue;
            names.add(type.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(type, names, topLevelDone, filter);
        }
        Class<?>[] declaredClasses = cl.getDeclaredClasses();
        for (int i = 0; i < declaredClasses.length; ++i) {
            Class<?> declaredClass = declaredClasses[i];
            if (declaredClass.isPrimitive() || declaredClass.isArray()) continue;
            names.add(declaredClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(declaredClass, names, topLevelDone, filter);
        }
        Method[] declaredMethods = cl.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method declaredMethod = declaredMethods[i];
            Class<?> returnType = declaredMethod.getReturnType();
            if (!returnType.isPrimitive() && !returnType.isArray()) {
                names.add(returnType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(returnType, names, topLevelDone, filter);
            }
            Class<?>[] parameterTypes = declaredMethod.getParameterTypes();
            for (int j = 0; j < parameterTypes.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                if (parameterType.isPrimitive() || parameterType.isArray()) continue;
                names.add(parameterType.getName());
                FSTClazzInfoRegistry.addAllReferencedClasses(parameterType, names, topLevelDone, filter);
            }
        }
        Class<?>[] classes = cl.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            Class<?> aClass = classes[i];
            if (aClass.isPrimitive() || aClass.isArray()) continue;
            names.add(aClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(aClass, names, topLevelDone, filter);
        }
        Class<?> enclosingClass = cl.getEnclosingClass();
        if (enclosingClass != null) {
            names.add(enclosingClass.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(enclosingClass, names, topLevelDone, filter);
        }
        names.add(cl.getName());
        FSTClazzInfoRegistry.addAllReferencedClasses(cl.getSuperclass(), names, topLevelDone, filter);
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface.isPrimitive() || anInterface.isArray()) continue;
            names.add(anInterface.getName());
            FSTClazzInfoRegistry.addAllReferencedClasses(anInterface, names, topLevelDone, filter);
        }
    }

    public FSTClazzInfoRegistry(FSTConfiguration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSTClazzInfo getCLInfo(Class c) {
        while (!this.rwLock.compareAndSet(false, true)) {
        }
        try {
            FSTClazzInfo res = (FSTClazzInfo)this.mInfos.get(c);
            if (res == null) {
                if (c == null) {
                    this.rwLock.set(false);
                    throw new NullPointerException("Class is null");
                }
                res = new FSTClazzInfo(this.conf, c, this, this.ignoreAnnotations);
                this.mInfos.put(c, res);
            }
            FSTClazzInfo fSTClazzInfo = res;
            return fSTClazzInfo;
        }
        finally {
            this.rwLock.set(false);
        }
    }

    public FSTSerializerRegistry getSerializerRegistry() {
        return this.serializerRegistry;
    }

    public final boolean isIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public void setSerializerRegistryDelegate(FSTSerializerRegistryDelegate delegate) {
        this.serializerRegistry.setDelegate(delegate);
    }

    public FSTSerializerRegistryDelegate getSerializerRegistryDelegate() {
        return this.serializerRegistry.getDelegate();
    }

    public void setStructMode(boolean structMode) {
        this.structMode = structMode;
    }

    public boolean isStructMode() {
        return this.structMode;
    }
}

