/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import java.io.IOException;
import java.io.InputStream;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzNameRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.util.FSTInputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTStreamDecoder
implements FSTDecoder {
    private FSTInputStream input;
    byte[] ascStringCache;
    FSTConfiguration conf;
    public FSTClazzNameRegistry clnames;
    char[] chBufS;

    public FSTStreamDecoder(FSTConfiguration conf) {
        this.conf = conf;
        this.clnames = (FSTClazzNameRegistry)conf.getCachedObject(FSTClazzNameRegistry.class);
        if (this.clnames == null) {
            this.clnames = new FSTClazzNameRegistry(conf.getClassRegistry(), conf);
        } else {
            this.clnames.clear();
        }
    }

    @Override
    public int ensureReadAhead(int bytes) {
        this.input.ensureReadAhead(bytes);
        return 0;
    }

    char[] getCharBuf(int siz) {
        char[] chars = this.chBufS;
        if (chars == null || chars.length < siz) {
            this.chBufS = chars = new char[Math.max(siz, 15)];
        }
        return chars;
    }

    @Override
    public String readStringUTF() throws IOException {
        int len = this.readFInt();
        char[] charBuf = this.getCharBuf(len * 3);
        this.input.ensureReadAhead(len * 3);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        int chcount = 0;
        for (int i = 0; i < len; ++i) {
            char head;
            if ((head = (char)(buf[count++] + 256 & 0xFF)) < '\u00ff') {
                charBuf[chcount++] = head;
                continue;
            }
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            charBuf[chcount++] = (char)((ch1 << 0) + (ch2 << 8));
        }
        this.input.pos = count;
        return new String(charBuf, 0, chcount);
    }

    @Override
    public byte readObjectHeaderTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public String readStringAsc() throws IOException {
        int len = this.readFInt();
        if (this.ascStringCache == null || this.ascStringCache.length < len) {
            this.ascStringCache = new byte[len];
        }
        this.input.ensureReadAhead(len);
        System.arraycopy(this.input.buf, this.input.pos, this.ascStringCache, 0, len);
        this.input.pos += len;
        return new String(this.ascStringCache, 0, 0, len);
    }

    @Override
    public Object readFPrimitiveArray(Object array, Class componentType, int len) {
        try {
            if (componentType == Byte.TYPE) {
                byte[] arr = (byte[])array;
                this.ensureReadAhead(arr.length);
                System.arraycopy(this.input.buf, this.input.pos, arr, 0, len);
                this.input.pos += len;
                return arr;
            }
            if (componentType == Integer.TYPE) {
                int[] arr = (int[])array;
                this.readFIntArr(len, arr);
                return arr;
            }
            if (componentType == Long.TYPE) {
                long[] arr = (long[])array;
                this.readFLongArr(len, arr);
                return arr;
            }
            if (componentType == Character.TYPE) {
                char[] arr = (char[])array;
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFChar();
                }
                return arr;
            }
            if (componentType == Double.TYPE) {
                double[] arr = (double[])array;
                this.ensureReadAhead(arr.length * 8);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFDouble();
                }
                return arr;
            }
            if (componentType == Short.TYPE) {
                short[] arr = (short[])array;
                this.ensureReadAhead(arr.length * 2);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFShort();
                }
                return arr;
            }
            if (componentType == Float.TYPE) {
                float[] arr = (float[])array;
                this.ensureReadAhead(arr.length * 4);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFFloat();
                }
                return arr;
            }
            if (componentType == Boolean.TYPE) {
                boolean[] arr = (boolean[])array;
                this.ensureReadAhead(arr.length);
                for (int j = 0; j < len; ++j) {
                    arr[j] = this.readFByte() != 0;
                }
                return arr;
            }
            throw new RuntimeException("unexpected primitive type " + componentType.getName());
        }
        catch (IOException e) {
            throw FSTUtil.rethrow(e);
        }
    }

    public void _readFIntArr(int len, int[] arr) throws IOException {
        this.ensureReadAhead(5 * len);
        byte[] buf = this.input.buf;
        int count = this.input.pos;
        for (int j = 0; j < len; ++j) {
            int ch2;
            int ch1;
            int head;
            if ((head = buf[count++]) > -127 && head <= 127) {
                arr[j] = head;
                continue;
            }
            if (head == -128) {
                ch1 = buf[count++] + 256 & 0xFF;
                ch2 = buf[count++] + 256 & 0xFF;
                arr[j] = (short)((ch1 << 8) + (ch2 << 0));
                continue;
            }
            ch1 = buf[count++] + 256 & 0xFF;
            ch2 = buf[count++] + 256 & 0xFF;
            int ch3 = buf[count++] + 256 & 0xFF;
            int ch4 = buf[count++] + 256 & 0xFF;
            arr[j] = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        this.input.pos = count;
    }

    @Override
    public void readFIntArr(int len, int[] arr) throws IOException {
        int bytelen = arr.length * 4;
        this.ensureReadAhead(bytelen);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        for (int j = 0; j < len; ++j) {
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            int ch3 = buf[count++] + 256 & 0xFF;
            int ch4 = buf[count++] + 256 & 0xFF;
            arr[j] = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        }
        this.input.pos += bytelen;
    }

    public void readFLongArr(int len, long[] arr) throws IOException {
        int bytelen = arr.length * 8;
        this.ensureReadAhead(bytelen);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        for (int j = 0; j < len; ++j) {
            long ch8 = buf[count++] + 256 & 0xFF;
            long ch7 = buf[count++] + 256 & 0xFF;
            long ch6 = buf[count++] + 256 & 0xFF;
            long ch5 = buf[count++] + 256 & 0xFF;
            long ch4 = buf[count++] + 256 & 0xFF;
            long ch3 = buf[count++] + 256 & 0xFF;
            long ch2 = buf[count++] + 256 & 0xFF;
            long ch1 = buf[count++] + 256 & 0xFF;
            arr[j] = (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
        }
        this.input.pos += bytelen;
    }

    @Override
    public int readFInt() throws IOException {
        this.ensureReadAhead(5);
        byte head = this.readFByte();
        if (head > -127 && head <= 127) {
            return head;
        }
        if (head == -128) {
            int count = this.input.pos;
            byte[] buf = this.input.buf;
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            this.input.pos = count;
            return (short)((ch2 << 8) + (ch1 << 0));
        }
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch1 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch3 = buf[count++] + 256 & 0xFF;
        int ch4 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        int res = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        return res;
    }

    @Override
    public double readFDouble() throws IOException {
        return Double.longBitsToDouble(this.readPlainLong());
    }

    @Override
    public float readFFloat() throws IOException {
        return Float.intBitsToFloat(this.readPlainInt());
    }

    @Override
    public final byte readFByte() throws IOException {
        this.input.ensureReadAhead(1);
        return this.input.buf[this.input.pos++];
    }

    @Override
    public final int readIntByte() throws IOException {
        this.input.ensureReadAhead(1);
        if (this.input.isFullyRead()) {
            return -1;
        }
        return this.input.buf[this.input.pos++] & 0xFF;
    }

    @Override
    public long readFLong() throws IOException {
        this.input.ensureReadAhead(9);
        byte head = this.readFByte();
        if (head > -126 && head <= 127) {
            return head;
        }
        if (head == -128) {
            int count = this.input.pos;
            byte[] buf = this.input.buf;
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            this.input.pos = count;
            return (short)((ch2 << 8) + (ch1 << 0));
        }
        if (head == -127) {
            int count = this.input.pos;
            byte[] buf = this.input.buf;
            int ch1 = buf[count++] + 256 & 0xFF;
            int ch2 = buf[count++] + 256 & 0xFF;
            int ch3 = buf[count++] + 256 & 0xFF;
            int ch4 = buf[count++] + 256 & 0xFF;
            this.input.pos = count;
            int res = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
            return res;
        }
        this.ensureReadAhead(8);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        long ch8 = buf[count++] + 256 & 0xFF;
        long ch7 = buf[count++] + 256 & 0xFF;
        long ch6 = buf[count++] + 256 & 0xFF;
        long ch5 = buf[count++] + 256 & 0xFF;
        long ch4 = buf[count++] + 256 & 0xFF;
        long ch3 = buf[count++] + 256 & 0xFF;
        long ch2 = buf[count++] + 256 & 0xFF;
        long ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    @Override
    public char readFChar() throws IOException {
        this.input.ensureReadAhead(3);
        char head = (char)(this.readFByte() + 256 & 0xFF);
        if (head >= '\u0000' && head < '\u00ff') {
            return head;
        }
        int ch1 = this.readFByte() & 0xFF;
        int ch2 = this.readFByte() & 0xFF;
        return (char)((ch1 << 0) + (ch2 << 8));
    }

    @Override
    public short readFShort() throws IOException {
        this.input.ensureReadAhead(3);
        int head = this.readFByte() & 0xFF;
        if (head >= 0 && head < 255) {
            return (short)head;
        }
        int ch1 = this.readFByte() & 0xFF;
        int ch2 = this.readFByte() & 0xFF;
        return (short)((ch1 << 0) + (ch2 << 8));
    }

    private char readPlainChar() throws IOException {
        this.input.ensureReadAhead(2);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    private short readPlainShort() throws IOException {
        this.input.ensureReadAhead(2);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch1 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (short)((ch2 << 8) + (ch1 << 0));
    }

    @Override
    public int readPlainInt() throws IOException {
        this.input.ensureReadAhead(4);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        int ch1 = buf[count++] + 256 & 0xFF;
        int ch2 = buf[count++] + 256 & 0xFF;
        int ch3 = buf[count++] + 256 & 0xFF;
        int ch4 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        int res = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
        return res;
    }

    private long readPlainLong() throws IOException {
        this.input.ensureReadAhead(8);
        int count = this.input.pos;
        byte[] buf = this.input.buf;
        long ch8 = buf[count++] + 256 & 0xFF;
        long ch7 = buf[count++] + 256 & 0xFF;
        long ch6 = buf[count++] + 256 & 0xFF;
        long ch5 = buf[count++] + 256 & 0xFF;
        long ch4 = buf[count++] + 256 & 0xFF;
        long ch3 = buf[count++] + 256 & 0xFF;
        long ch2 = buf[count++] + 256 & 0xFF;
        long ch1 = buf[count++] + 256 & 0xFF;
        this.input.pos = count;
        return (ch1 << 56) + (ch2 << 48) + (ch3 << 40) + (ch4 << 32) + (ch5 << 24) + (ch6 << 16) + (ch7 << 8) + (ch8 << 0);
    }

    @Override
    public byte[] getBuffer() {
        return this.input.buf;
    }

    @Override
    public int getInputPos() {
        return this.input.pos;
    }

    @Override
    public void moveTo(int position) {
        this.input.pos = position;
    }

    @Override
    public void reset() {
        this.input.reset();
        this.clnames.clear();
    }

    @Override
    public void setInputStream(InputStream in) {
        if (this.input == null) {
            this.input = new FSTInputStream(in);
        } else {
            this.input.initFromStream(in);
        }
        this.clnames.clear();
    }

    @Override
    public void resetToCopyOf(byte[] bytes, int off, int len) {
        this.input.reset();
        this.input.ensureCapacity(len);
        this.input.count = len;
        System.arraycopy(bytes, off, this.input.buf, 0, len);
        this.clnames.clear();
        this.input.byteBacked = true;
    }

    @Override
    public void resetWith(byte[] bytes, int len) {
        this.clnames.clear();
        this.input.reset();
        this.input.count = len;
        this.input.buf = bytes;
        this.input.pos = 0;
        this.input.byteBacked = true;
    }

    @Override
    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.clnames.decodeClass(this);
    }

    @Override
    public Class classForName(String name) throws ClassNotFoundException {
        return this.clnames.classForName(name);
    }

    @Override
    public void registerClass(Class possible) {
        this.clnames.registerClass(possible);
    }

    @Override
    public void close() {
        this.conf.returnObject(this.clnames);
    }

    @Override
    public void skip(int n) {
        this.input.pos += n;
    }

    @Override
    public void readPlainBytes(byte[] b, int off, int len) {
        this.input.ensureReadAhead(len);
        System.arraycopy(this.input.buf, this.input.pos, b, off, len);
        this.input.pos += len;
    }

    @Override
    public boolean isMapBased() {
        return false;
    }

    @Override
    public Object getDirectObject() {
        return null;
    }

    @Override
    public int getObjectHeaderLen() {
        return -1;
    }

    @Override
    public void consumeEndMarker() {
    }

    @Override
    public Class readArrayHeader() throws Exception {
        return this.readClass().getClazz();
    }

    @Override
    public void readExternalEnd() {
    }

    @Override
    public boolean isEndMarker(String s) {
        return false;
    }

    @Override
    public int readVersionTag() throws IOException {
        return this.readFByte();
    }

    @Override
    public void pushBack(int bytes) {
        this.input.pos -= bytes;
    }
}

