/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTObjectOutput;

public class TCPObjectSocket {
    public static int BUFFER_SIZE = 512000;
    InputStream in;
    OutputStream out;
    FSTConfiguration conf;
    Socket socket;
    Exception lastErr;
    boolean stopped;
    AtomicBoolean readLock = new AtomicBoolean(false);
    AtomicBoolean writeLock = new AtomicBoolean(false);

    public TCPObjectSocket(String host, int port) throws IOException {
        this(new Socket(host, port), FSTConfiguration.createDefaultConfiguration());
    }

    public TCPObjectSocket(String host, int port, FSTConfiguration conf) throws IOException {
        this(new Socket(host, port), conf);
    }

    public TCPObjectSocket(Socket socket, FSTConfiguration conf) throws IOException {
        this.socket = socket;
        this.out = new BufferedOutputStream(socket.getOutputStream(), BUFFER_SIZE);
        this.in = new BufferedInputStream(socket.getInputStream(), BUFFER_SIZE);
        this.conf = conf;
    }

    public Exception getLastErr() {
        return this.lastErr;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public Object readObject() throws Exception {
        try {
            while (!this.readLock.compareAndSet(false, true)) {
            }
            int ch1 = this.in.read() + 256 & 0xFF;
            int ch2 = this.in.read() + 256 & 0xFF;
            int ch3 = this.in.read() + 256 & 0xFF;
            int ch4 = this.in.read() + 256 & 0xFF;
            int len = (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + (ch1 << 0);
            if (len <= 0) {
                throw new EOFException("client closed");
            }
            int orglen = len;
            byte[] buffer = new byte[len];
            while (len > 0) {
                len -= this.in.read(buffer, buffer.length - len, len);
            }
            try {
                Object object = this.conf.getObjectInput(buffer).readObject();
                return object;
            }
            catch (Exception e) {
                System.out.println("orglen: " + orglen + " " + new String(buffer, 0));
                Object retry = this.conf.getObjectInput(buffer).readObject();
                throw e;
            }
        }
        finally {
            this.readLock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object toWrite) throws Exception {
        try {
            while (!this.writeLock.compareAndSet(false, true)) {
            }
            FSTObjectOutput objectOutput = this.conf.getObjectOutput();
            objectOutput.writeObject(toWrite);
            int written = objectOutput.getWritten();
            this.out.write(written >>> 0 & 0xFF);
            this.out.write(written >>> 8 & 0xFF);
            this.out.write(written >>> 16 & 0xFF);
            this.out.write(written >>> 24 & 0xFF);
            this.out.write(objectOutput.getBuffer(), 0, written);
            objectOutput.flush();
        }
        finally {
            this.writeLock.set(false);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void setLastError(Exception ex) {
        this.stopped = true;
        this.lastErr = ex;
    }

    public void close() throws IOException {
        this.flush();
        this.socket.close();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public FSTConfiguration getConf() {
        return this.conf;
    }
}

