/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.util.FSTIdentity2IdMap;
import org.nustaq.serialization.util.FSTInt2ObjectMap;
import org.nustaq.serialization.util.FSTUtil;

public final class FSTObjectRegistry {
    public static final int OBJ_DIVISOR = 16;
    boolean disabled = false;
    FSTIdentity2IdMap objects = new FSTIdentity2IdMap(11);
    FSTInt2ObjectMap idToObject = new FSTInt2ObjectMap(11);
    FSTConfiguration conf;
    FSTClazzInfoRegistry reg;
    Object[] reuseMap = new Object[4000];
    private int highestPos;

    public FSTObjectRegistry(FSTConfiguration conf) {
        this.conf = conf;
        this.disabled = !conf.isShareReferences();
        this.reg = conf.getCLInfoRegistry();
    }

    public void clearFully() {
        this.objects.clear();
        this.idToObject.clear();
        this.disabled = !this.conf.isShareReferences();
        FSTUtil.clear(this.reuseMap);
    }

    public void clearForRead() {
        boolean bl = this.disabled = !this.conf.isShareReferences();
        if (!this.disabled) {
            if (this.idToObject.mKeys.length > 6 * this.idToObject.size() && this.idToObject.size() > 0) {
                this.idToObject = new FSTInt2ObjectMap(this.idToObject.size());
            } else {
                this.idToObject.clear();
            }
            if (this.highestPos > 0) {
                FSTUtil.clear(this.reuseMap, this.highestPos);
            }
        }
        this.highestPos = 0;
    }

    public void clearForWrite() {
        boolean bl = this.disabled = !this.conf.isShareReferences();
        if (!this.disabled) {
            if (this.objects.size() > 0 && this.objects.mKeys.length > 6 * this.objects.size()) {
                this.objects = new FSTIdentity2IdMap(this.objects.size());
            } else {
                this.objects.clear();
            }
        }
    }

    public Object getReadRegisteredObject(int handle) {
        if (this.disabled) {
            return null;
        }
        int pos = handle / 16;
        if (pos < this.reuseMap.length) {
            if (this.reuseMap[pos] == null) {
                return null;
            }
            Object candidate = this.idToObject.get(handle);
            if (candidate == null) {
                return this.reuseMap[pos];
            }
            return candidate;
        }
        this.idToObject.get(handle);
        return this.idToObject.get(handle);
    }

    public void replace(Object old, Object replaced, int streamPos) {
        int pos = streamPos / 16;
        Object[] reuseMap = this.reuseMap;
        if (pos < reuseMap.length) {
            if (this.reuseMap[pos] == old) {
                this.reuseMap[pos] = replaced;
            } else if (this.reuseMap[pos] == null) {
                this.reuseMap[pos] = replaced;
            } else {
                this.idToObject.put(streamPos, replaced);
            }
        } else {
            this.idToObject.put(streamPos, replaced);
        }
    }

    public void registerObjectForRead(Object o, int streamPosition) {
        if (this.disabled) {
            return;
        }
        int pos = streamPosition / 16;
        Object[] reuseMap = this.reuseMap;
        if (pos < reuseMap.length) {
            int n = this.highestPos = pos > this.highestPos ? pos : this.highestPos;
            if (this.reuseMap[pos] == null) {
                this.reuseMap[pos] = o;
            } else {
                this.idToObject.put(streamPosition, o);
            }
        } else {
            this.idToObject.put(streamPosition, o);
        }
    }

    public int registerObjectForWrite(Object o, int streamPosition, FSTClazzInfo clzInfo, int[] reUseType) {
        if (this.disabled) {
            return Integer.MIN_VALUE;
        }
        if (clzInfo != null && clzInfo.isFlat()) {
            return Integer.MIN_VALUE;
        }
        int handle = this.objects.putOrGet(o, streamPosition);
        if (handle >= 0) {
            reUseType[0] = 0;
            return handle;
        }
        return Integer.MIN_VALUE;
    }

    public int getObjectSize() {
        return this.objects.size();
    }
}

