/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap;

import java.util.Iterator;
import org.nustaq.offheap.FSTBinaryOffheapMap;
import org.nustaq.offheap.bytez.ByteSource;
import org.nustaq.offheap.bytez.bytesource.BytezByteSource;

public abstract class FSTCodedOffheapMap<K, V>
extends FSTBinaryOffheapMap {
    public FSTCodedOffheapMap(int keyLen, long sizeMemBytes, int numberOfElems) {
        super(keyLen, sizeMemBytes, numberOfElems);
    }

    public FSTCodedOffheapMap(String mappedFile, int keyLen, long sizeMemBytes, int numberOfElems) throws Exception {
        super(mappedFile, keyLen, sizeMemBytes, numberOfElems);
    }

    public abstract ByteSource encodeKey(K var1);

    public abstract ByteSource encodeValue(V var1);

    public abstract V decodeValue(BytezByteSource var1);

    public V get(K key) {
        ByteSource bkey = this.encodeKey(key);
        BytezByteSource val = this.getBinary(bkey);
        if (val == null) {
            return null;
        }
        try {
            return this.decodeValue(val);
        }
        catch (Exception ex) {
            System.out.println("ERROR in " + (val.getOff() - (long)this.getHeaderLen()) + " " + this.printBinaryKey(bkey) + " " + this.index.get(bkey));
            throw new RuntimeException(ex);
        }
    }

    public void put(K key, V value) {
        ByteSource bkey = this.encodeKey(key);
        ByteSource decoded = this.encodeValue(value);
        this.putBinary(bkey, decoded);
    }

    public void remove(K key) {
        ByteSource bkey = this.encodeKey(key);
        this.removeBinary(bkey);
    }

    public Iterator<V> values() {
        final Iterator<ByteSource> iter = this.binaryValues();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            public V next() {
                BytezByteSource next = (BytezByteSource)iter.next();
                return FSTCodedOffheapMap.this.decodeValue(next);
            }

            @Override
            public void remove() {
                throw new RuntimeException("unimplemented");
            }
        };
    }
}

